/*
 * Decompiled with CFR 0.152.
 */
package jcifs.netbios;

import java.io.UnsupportedEncodingException;
import jcifs.Config;

class Name {
    static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static final int TYPE_OFFSET = 31;
    static final int SCOPE_OFFSET = 33;
    static String defaultScope = Config.getProperty("jcifs.netbios.scope");
    static String encoding = Config.getProperty("jcifs.netbios.encoding", "ISO8859_1");
    String name;
    String scope;
    int hexCode;
    int srcHashCode;

    static String toHexChars(int val) {
        int len = 2;
        char[] tmp = new char[2];
        while (len > 0) {
            tmp[len - 1] = HEX_DIGITS[val & 0xF];
            if (val != 0) {
                val >>>= 4;
            }
            --len;
        }
        return new String(tmp);
    }

    Name() {
    }

    Name(String name, int hexCode, String scope) {
        if (name.length() > 15) {
            name = name.substring(0, 15);
        }
        this.name = name.toUpperCase();
        this.hexCode = hexCode;
        this.scope = scope != null && scope.length() > 0 ? scope : defaultScope;
        this.srcHashCode = 0;
    }

    int writeWireFormat(byte[] dst, int dstIndex) {
        dst[dstIndex] = 32;
        try {
            byte[] tmp = this.name.getBytes(encoding);
            int i = 0;
            while (i < tmp.length) {
                dst[dstIndex + (2 * i + 1)] = (byte)(((tmp[i] & 0xF0) >> 4) + 65);
                dst[dstIndex + (2 * i + 2)] = (byte)((tmp[i] & 0xF) + 65);
                ++i;
            }
            while (i < 15) {
                dst[dstIndex + (2 * i + 1)] = 67;
                dst[dstIndex + (2 * i + 2)] = 65;
                ++i;
            }
            dst[dstIndex + 31] = (byte)(((this.hexCode & 0xF0) >> 4) + 65);
            dst[dstIndex + 31 + 1] = (byte)((this.hexCode & 0xF) + 65);
        }
        catch (UnsupportedEncodingException uee) {}
        return 33 + this.writeScopeWireFormat(dst, dstIndex + 33);
    }

    int readWireFormat(byte[] src, int srcIndex) {
        byte[] tmp = new byte[33];
        int length = 15;
        int i = 0;
        while (i < 15) {
            tmp[i] = (byte)((src[srcIndex + (2 * i + 1)] & 0xFF) - 65 << 4);
            int n = i;
            tmp[n] = (byte)(tmp[n] | (byte)((src[srcIndex + (2 * i + 2)] & 0xFF) - 65 & 0xF));
            if (tmp[i] != 32) {
                length = i + 1;
            }
            ++i;
        }
        try {
            this.name = new String(tmp, 0, length, encoding);
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        this.hexCode = (src[srcIndex + 31] & 0xFF) - 65 << 4;
        this.hexCode |= (src[srcIndex + 31 + 1] & 0xFF) - 65 & 0xF;
        return 33 + this.readScopeWireFormat(src, srcIndex + 33);
    }

    int writeScopeWireFormat(byte[] dst, int dstIndex) {
        if (this.scope == null) {
            dst[dstIndex] = 0;
            return 1;
        }
        dst[dstIndex++] = 46;
        try {
            System.arraycopy(this.scope.getBytes(encoding), 0, dst, dstIndex, this.scope.length());
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        dstIndex += this.scope.length();
        dst[dstIndex++] = 0;
        int i = dstIndex - 2;
        int e = i - this.scope.length();
        int c = 0;
        do {
            if (dst[i] == 46) {
                dst[i] = (byte)c;
                c = 0;
                continue;
            }
            ++c;
        } while (i-- > e);
        return this.scope.length() + 2;
    }

    int readScopeWireFormat(byte[] src, int srcIndex) {
        int n;
        int start = srcIndex;
        if ((n = src[srcIndex++] & 0xFF) == 0) {
            this.scope = null;
            return 1;
        }
        try {
            StringBuffer sb = new StringBuffer(new String(src, srcIndex, n, encoding));
            srcIndex += n;
            while ((n = src[srcIndex++] & 0xFF) != 0) {
                sb.append('.').append(new String(src, srcIndex, n, encoding));
                srcIndex += n;
            }
            this.scope = sb.toString();
        }
        catch (UnsupportedEncodingException uee) {}
        return srcIndex - start;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result += 65599 * this.hexCode;
        result += 65599 * this.srcHashCode;
        if (this.scope != null && this.scope.length() != 0) {
            result += this.scope.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Name)) {
            return false;
        }
        Name n = (Name)obj;
        if (this.scope == null && n.scope == null) {
            return this.name.equals(n.name) && this.hexCode == n.hexCode;
        }
        return this.name.equals(n.name) && this.hexCode == n.hexCode && this.scope.equals(n.scope);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String n = this.name;
        if (n == null) {
            n = "null";
        } else if (n.charAt(0) == '\u0001') {
            char[] c = n.toCharArray();
            c[0] = 46;
            c[1] = 46;
            c[14] = 46;
            n = new String(c);
        }
        sb.append(n).append("<").append(Name.toHexChars(this.hexCode)).append(">");
        if (this.scope != null) {
            sb.append(".").append(this.scope);
        }
        return sb.toString();
    }
}

