/*
 * Decompiled with CFR 0.152.
 */
package jcifs.netbios;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import jcifs.Config;
import jcifs.util.Log;

class SocketOutputStream
extends FilterOutputStream {
    private static int DEFAULT_BUFR_SIZE = 4400;
    private byte[] bufr;
    private int count;
    private int writeSize;

    SocketOutputStream(OutputStream out) {
        this(out, DEFAULT_BUFR_SIZE);
    }

    SocketOutputStream(OutputStream out, int size) {
        super(out);
        this.writeSize = Config.getInt("jcifs.netbios.client.writeSize", size);
        if (this.writeSize <= 0) {
            throw new IllegalArgumentException("buffer size <= 0");
        }
        if (this.writeSize > 131071) {
            throw new IllegalArgumentException("buffer exceeds max netbios message size");
        }
        this.writeSize += 4;
        this.bufr = new byte[this.writeSize];
        this.bufr[0] = 0;
        this.count = 4;
    }

    public synchronized void write(int b) throws IOException {
        if (this.count >= this.bufr.length) {
            this.flush();
        }
        this.bufr[this.count++] = (byte)b;
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (len + 4 > this.bufr.length) {
            Log.println(2, "session service warning", "write len exceeds pre-allocated buffer size; performance will suffer: len=" + len + ",writeSize=" + this.writeSize);
            this.flush();
            byte[] tmp = this.bufr;
            this.bufr = new byte[len + 4];
            System.arraycopy(b, off, this.bufr, this.count, len);
            this.count += len;
            this.flush();
            this.bufr = tmp;
            return;
        }
        if (len > this.bufr.length - this.count) {
            this.flush();
        }
        System.arraycopy(b, off, this.bufr, this.count, len);
        this.count += len;
    }

    public synchronized void flush() throws IOException {
        if (this.count == 4) {
            return;
        }
        int n = this.count - 4;
        this.bufr[1] = (byte)((n & 0x10000) != 0 ? 1 : 0);
        this.bufr[2] = (byte)(n >> 8 & 0xFF);
        this.bufr[3] = (byte)(n & 0xFF);
        this.out.write(this.bufr, 0, this.count);
        this.out.flush();
        this.count = 4;
    }
}

