/*
 * Decompiled with CFR 0.152.
 */
package jcifs.ntlmssp;

import java.io.IOException;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import jcifs.Config;
import jcifs.netbios.NbtAddress;
import jcifs.ntlmssp.NtlmMessage;
import jcifs.ntlmssp.Type2Message;
import jcifs.smb.NtlmPasswordAuthentication;

public class Type3Message
extends NtlmMessage {
    private static final int DEFAULT_FLAGS;
    private static final String DEFAULT_DOMAIN;
    private static final String DEFAULT_USER;
    private static final String DEFAULT_PASSWORD;
    private static final String DEFAULT_WORKSTATION;
    private static final int LM_COMPATIBILITY;
    private static final SecureRandom RANDOM;
    private byte[] lmResponse;
    private byte[] ntResponse;
    private String domain;
    private String user;
    private String workstation;
    private byte[] sessionKey;

    public Type3Message() {
        this.setFlags(Type3Message.getDefaultFlags());
        this.setDomain(Type3Message.getDefaultDomain());
        this.setUser(Type3Message.getDefaultUser());
        this.setWorkstation(Type3Message.getDefaultWorkstation());
    }

    public Type3Message(Type2Message type2) {
        this.setFlags(Type3Message.getDefaultFlags(type2));
        this.setWorkstation(Type3Message.getDefaultWorkstation());
        String domain = Type3Message.getDefaultDomain();
        this.setDomain(domain);
        String user = Type3Message.getDefaultUser();
        this.setUser(user);
        String password = Type3Message.getDefaultPassword();
        switch (LM_COMPATIBILITY) {
            case 0: 
            case 1: {
                this.setLMResponse(Type3Message.getLMResponse(type2, password));
                this.setNTResponse(Type3Message.getNTResponse(type2, password));
                break;
            }
            case 2: {
                byte[] nt = Type3Message.getNTResponse(type2, password);
                this.setLMResponse(nt);
                this.setNTResponse(nt);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                byte[] clientChallenge = new byte[8];
                RANDOM.nextBytes(clientChallenge);
                this.setLMResponse(Type3Message.getLMv2Response(type2, domain, user, password, clientChallenge));
                break;
            }
            default: {
                this.setLMResponse(Type3Message.getLMResponse(type2, password));
                this.setNTResponse(Type3Message.getNTResponse(type2, password));
            }
        }
    }

    public Type3Message(Type2Message type2, String password, String domain, String user, String workstation) {
        this.setFlags(Type3Message.getDefaultFlags(type2));
        this.setDomain(domain);
        this.setUser(user);
        this.setWorkstation(workstation);
        switch (LM_COMPATIBILITY) {
            case 0: 
            case 1: {
                this.setLMResponse(Type3Message.getLMResponse(type2, password));
                this.setNTResponse(Type3Message.getNTResponse(type2, password));
                break;
            }
            case 2: {
                byte[] nt = Type3Message.getNTResponse(type2, password);
                this.setLMResponse(nt);
                this.setNTResponse(nt);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                byte[] clientChallenge = new byte[8];
                RANDOM.nextBytes(clientChallenge);
                this.setLMResponse(Type3Message.getLMv2Response(type2, domain, user, password, clientChallenge));
                break;
            }
            default: {
                this.setLMResponse(Type3Message.getLMResponse(type2, password));
                this.setNTResponse(Type3Message.getNTResponse(type2, password));
            }
        }
    }

    public Type3Message(int flags, byte[] lmResponse, byte[] ntResponse, String domain, String user, String workstation) {
        this.setFlags(flags);
        this.setLMResponse(lmResponse);
        this.setNTResponse(ntResponse);
        this.setDomain(domain);
        this.setUser(user);
        this.setWorkstation(workstation);
    }

    public Type3Message(byte[] material) throws IOException {
        this.parse(material);
    }

    public byte[] getLMResponse() {
        return this.lmResponse;
    }

    public void setLMResponse(byte[] lmResponse) {
        this.lmResponse = lmResponse;
    }

    public byte[] getNTResponse() {
        return this.ntResponse;
    }

    public void setNTResponse(byte[] ntResponse) {
        this.ntResponse = ntResponse;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getWorkstation() {
        return this.workstation;
    }

    public void setWorkstation(String workstation) {
        this.workstation = workstation;
    }

    public byte[] getSessionKey() {
        return this.sessionKey;
    }

    public void setSessionKey(byte[] sessionKey) {
        this.sessionKey = sessionKey;
    }

    public byte[] toByteArray() {
        try {
            int flags = this.getFlags();
            boolean unicode = (flags & 1) != 0;
            String oem = unicode ? null : NtlmMessage.getOEMEncoding();
            String domainName = this.getDomain();
            byte[] domain = null;
            if (domainName != null && domainName.length() != 0) {
                domain = unicode ? domainName.getBytes("UnicodeLittleUnmarked") : domainName.toUpperCase().getBytes(oem);
            }
            int domainLength = domain != null ? domain.length : 0;
            String userName = this.getUser();
            byte[] user = null;
            if (userName != null && userName.length() != 0) {
                user = unicode ? userName.getBytes("UnicodeLittleUnmarked") : userName.toUpperCase().getBytes(oem);
            }
            int userLength = user != null ? user.length : 0;
            String workstationName = this.getWorkstation();
            byte[] workstation = null;
            if (workstationName != null && workstationName.length() != 0) {
                workstation = unicode ? workstationName.getBytes("UnicodeLittleUnmarked") : workstationName.toUpperCase().getBytes(oem);
            }
            int workstationLength = workstation != null ? workstation.length : 0;
            byte[] lmResponse = this.getLMResponse();
            int lmLength = lmResponse != null ? lmResponse.length : 0;
            byte[] ntResponse = this.getNTResponse();
            int ntLength = ntResponse != null ? ntResponse.length : 0;
            byte[] sessionKey = this.getSessionKey();
            int keyLength = sessionKey != null ? sessionKey.length : 0;
            byte[] type3 = new byte[64 + domainLength + userLength + workstationLength + lmLength + ntLength + keyLength];
            System.arraycopy(NtlmMessage.NTLMSSP_SIGNATURE, 0, type3, 0, 8);
            NtlmMessage.writeULong(type3, 8, 3);
            int offset = 64;
            NtlmMessage.writeSecurityBuffer(type3, 12, offset, lmResponse);
            NtlmMessage.writeSecurityBuffer(type3, 20, offset += lmLength, ntResponse);
            NtlmMessage.writeSecurityBuffer(type3, 28, offset += ntLength, domain);
            NtlmMessage.writeSecurityBuffer(type3, 36, offset += domainLength, user);
            NtlmMessage.writeSecurityBuffer(type3, 44, offset += userLength, workstation);
            NtlmMessage.writeSecurityBuffer(type3, 52, offset += workstationLength, sessionKey);
            NtlmMessage.writeULong(type3, 60, flags);
            return type3;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
    }

    public String toString() {
        int i;
        String user = this.getUser();
        String domain = this.getDomain();
        String workstation = this.getWorkstation();
        byte[] lmResponse = this.getLMResponse();
        byte[] ntResponse = this.getNTResponse();
        byte[] sessionKey = this.getSessionKey();
        int flags = this.getFlags();
        StringBuffer buffer = new StringBuffer();
        if (domain != null) {
            buffer.append("domain: ").append(domain);
        }
        if (user != null) {
            if (buffer.length() > 0) {
                buffer.append("; ");
            }
            buffer.append("user: ").append(user);
        }
        if (workstation != null) {
            if (buffer.length() > 0) {
                buffer.append("; ");
            }
            buffer.append("workstation: ").append(workstation);
        }
        if (lmResponse != null) {
            if (buffer.length() > 0) {
                buffer.append("; ");
            }
            buffer.append("lmResponse: ");
            buffer.append("0x");
            i = 0;
            while (i < lmResponse.length) {
                buffer.append(Integer.toHexString(lmResponse[i] >> 4 & 0xF));
                buffer.append(Integer.toHexString(lmResponse[i] & 0xF));
                ++i;
            }
        }
        if (ntResponse != null) {
            if (buffer.length() > 0) {
                buffer.append("; ");
            }
            buffer.append("ntResponse: ");
            buffer.append("0x");
            i = 0;
            while (i < ntResponse.length) {
                buffer.append(Integer.toHexString(ntResponse[i] >> 4 & 0xF));
                buffer.append(Integer.toHexString(ntResponse[i] & 0xF));
                ++i;
            }
        }
        if (sessionKey != null) {
            if (buffer.length() > 0) {
                buffer.append("; ");
            }
            buffer.append("sessionKey: ");
            buffer.append("0x");
            i = 0;
            while (i < sessionKey.length) {
                buffer.append(Integer.toHexString(sessionKey[i] >> 4 & 0xF));
                buffer.append(Integer.toHexString(sessionKey[i] & 0xF));
                ++i;
            }
        }
        if (flags != 0) {
            if (buffer.length() > 0) {
                buffer.append("; ");
            }
            buffer.append("flags: ");
            buffer.append("0x");
            buffer.append(Integer.toHexString(flags >> 28 & 0xF));
            buffer.append(Integer.toHexString(flags >> 24 & 0xF));
            buffer.append(Integer.toHexString(flags >> 20 & 0xF));
            buffer.append(Integer.toHexString(flags >> 16 & 0xF));
            buffer.append(Integer.toHexString(flags >> 12 & 0xF));
            buffer.append(Integer.toHexString(flags >> 8 & 0xF));
            buffer.append(Integer.toHexString(flags >> 4 & 0xF));
            buffer.append(Integer.toHexString(flags & 0xF));
        }
        return buffer.toString();
    }

    public static int getDefaultFlags() {
        return DEFAULT_FLAGS;
    }

    public static int getDefaultFlags(Type2Message type2) {
        if (type2 == null) {
            return DEFAULT_FLAGS;
        }
        int flags = 512;
        return flags |= (type2.getFlags() & 1) != 0 ? 1 : 2;
    }

    public static byte[] getLMResponse(Type2Message type2, String password) {
        if (type2 == null || password == null) {
            return null;
        }
        return NtlmPasswordAuthentication.getPreNTLMResponse(password, type2.getChallenge());
    }

    public static byte[] getLMv2Response(Type2Message type2, String domain, String user, String password, byte[] clientChallenge) {
        if (type2 == null || domain == null || user == null || password == null || clientChallenge == null) {
            return null;
        }
        return NtlmPasswordAuthentication.getLMv2Response(domain, user, password, type2.getChallenge(), clientChallenge);
    }

    public static byte[] getNTResponse(Type2Message type2, String password) {
        if (type2 == null || password == null) {
            return null;
        }
        return NtlmPasswordAuthentication.getNTLMResponse(password, type2.getChallenge());
    }

    public static String getDefaultDomain() {
        return DEFAULT_DOMAIN;
    }

    public static String getDefaultUser() {
        return DEFAULT_USER;
    }

    public static String getDefaultPassword() {
        return DEFAULT_PASSWORD;
    }

    public static String getDefaultWorkstation() {
        return DEFAULT_WORKSTATION;
    }

    private void parse(byte[] material) throws IOException {
        String charset;
        int flags;
        int i = 0;
        while (i < 8) {
            if (material[i] != NtlmMessage.NTLMSSP_SIGNATURE[i]) {
                throw new IOException("Not an NTLMSSP message.");
            }
            ++i;
        }
        if (NtlmMessage.readULong(material, 8) != 3) {
            throw new IOException("Not a Type 3 message.");
        }
        byte[] lmResponse = NtlmMessage.readSecurityBuffer(material, 12);
        int lmResponseOffset = NtlmMessage.readULong(material, 16);
        byte[] ntResponse = NtlmMessage.readSecurityBuffer(material, 20);
        int ntResponseOffset = NtlmMessage.readULong(material, 24);
        byte[] domain = NtlmMessage.readSecurityBuffer(material, 28);
        int domainOffset = NtlmMessage.readULong(material, 32);
        byte[] user = NtlmMessage.readSecurityBuffer(material, 36);
        int userOffset = NtlmMessage.readULong(material, 40);
        byte[] workstation = NtlmMessage.readSecurityBuffer(material, 44);
        int workstationOffset = NtlmMessage.readULong(material, 48);
        if (lmResponseOffset == 52 || ntResponseOffset == 52 || domainOffset == 52 || userOffset == 52 || workstationOffset == 52) {
            flags = 514;
            charset = NtlmMessage.getOEMEncoding();
        } else {
            this.setSessionKey(NtlmMessage.readSecurityBuffer(material, 52));
            flags = NtlmMessage.readULong(material, 60);
            charset = (flags & 1) != 0 ? "UnicodeLittleUnmarked" : NtlmMessage.getOEMEncoding();
        }
        this.setFlags(flags);
        this.setLMResponse(lmResponse);
        if (LM_COMPATIBILITY < 3) {
            this.setNTResponse(ntResponse);
        }
        this.setDomain(new String(domain, charset));
        this.setUser(new String(user, charset));
        this.setWorkstation(new String(workstation, charset));
    }

    static {
        RANDOM = new SecureRandom();
        DEFAULT_FLAGS = 0x200 | (Config.getBoolean("jcifs.smb.client.useUnicode", true) ? 1 : 2);
        DEFAULT_DOMAIN = Config.getProperty("jcifs.smb.client.domain", null);
        DEFAULT_USER = Config.getProperty("jcifs.smb.client.username", null);
        DEFAULT_PASSWORD = Config.getProperty("jcifs.smb.client.password", null);
        String defaultWorkstation = null;
        try {
            defaultWorkstation = NbtAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            // empty catch block
        }
        DEFAULT_WORKSTATION = defaultWorkstation;
        LM_COMPATIBILITY = Config.getInt("jcifs.smb.lmCompatibility", 0);
    }
}

