/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.TimeZone;
import jcifs.Config;
import jcifs.smb.Log;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbException;

abstract class ServerMessageBlock {
    static final int FLAGS_NONE = 0;
    static final int FLAGS_LOCK_AND_READ_WRITE_AND_UNLOCK = 1;
    static final int FLAGS_RECEIVE_BUFFER_POSTED = 2;
    static final int FLAGS_PATH_NAMES_CASELESS = 8;
    static final int FLAGS_PATH_NAMES_CANONICALIZED = 16;
    static final int FLAGS_OPLOCK_REQUESTED_OR_GRANTED = 32;
    static final int FLAGS_NOTIFY_OF_MODIFY_ACTION = 64;
    static final int FLAGS_RESPONSE = 128;
    static final int FLAGS2_NONE = 0;
    static final int FLAGS2_LONG_FILENAMES = 1;
    static final int FLAGS2_EXTENDED_ATTRIBUTES = 2;
    static final int FLAGS2_SECURITY_SIGNATURES = 4;
    static final int FLAGS2_EXTENDED_SECURITY_NEGOTIATION = 2048;
    static final int FLAGS2_RESOLVE_PATHS_IN_DFS = 4096;
    static final int FLAGS2_PERMIT_READ_IF_EXECUTE_PERM = 8192;
    static final int FLAGS2_STATUS32 = 16384;
    static final int FLAGS2_UNICODE = 32768;
    static final int CAP_NONE = 0;
    static final int CAP_RAW_MODE = 1;
    static final int CAP_MPX_MODE = 2;
    static final int CAP_UNICODE = 4;
    static final int CAP_LARGE_FILES = 8;
    static final int CAP_NT_SMBS = 16;
    static final int CAP_RPC_REMOTE_APIS = 32;
    static final int CAP_STATUS32 = 64;
    static final int CAP_LEVEL_II_OPLOCKS = 128;
    static final int CAP_LOCK_AND_READ = 256;
    static final int CAP_NT_FIND = 512;
    static final int CAP_DFS = 4096;
    static final int ATTR_READONLY = 1;
    static final int ATTR_HIDDEN = 2;
    static final int ATTR_SYSTEM = 4;
    static final int ATTR_VOLUME = 8;
    static final int ATTR_DIRECTORY = 16;
    static final int ATTR_ARCHIVE = 32;
    static final int ATTR_COMPRESSED = 2048;
    static final int ATTR_NORMAL = 128;
    static final int ATTR_TEMPORARY = 256;
    static final int FLAGS_TARGET_MUST_BE_FILE = 1;
    static final int FLAGS_TARGET_MUST_BE_DIRECTORY = 2;
    static final int FLAGS_COPY_TARGET_MODE_ASCII = 4;
    static final int FLAGS_COPY_SOURCE_MODE_ASCII = 8;
    static final int FLAGS_VERIFY_ALL_WRITES = 16;
    static final int FLAGS_TREE_COPY = 32;
    static final int OPEN_FUNCTION_FAIL_IF_EXISTS = 0;
    static final int OPEN_FUNCTION_OVERWRITE_IF_EXISTS = 32;
    static final int PID = (int)(Math.random() * 65536.0);
    static final int SECURITY_SHARE = 0;
    static final int SECURITY_USER = 1;
    static final int CMD_OFFSET = 4;
    static final int ERROR_CODE_OFFSET = 5;
    static final int FLAGS_OFFSET = 9;
    static final int SIGNATURE_OFFSET = 14;
    static final int TID_OFFSET = 24;
    static final int HEADER_LENGTH = 32;
    static final long MILLISECONDS_BETWEEN_1970_AND_1601 = 11644473600000L;
    static final TimeZone TZ = TimeZone.getDefault();
    static boolean useBatching = Config.getBoolean("jcifs.smb.client.useBatching", true);
    static String encoding = Config.getProperty("jcifs.smb.client.codepage", Config.getProperty("jcifs.encoding", System.getProperty("file.encoding")));
    static final byte[] header = new byte[]{-1, 83, 77, 66, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static final byte SMB_COM_CREATE_DIRECTORY = 0;
    static final byte SMB_COM_DELETE_DIRECTORY = 1;
    static final byte SMB_COM_CLOSE = 4;
    static final byte SMB_COM_DELETE = 6;
    static final byte SMB_COM_RENAME = 7;
    static final byte SMB_COM_QUERY_INFORMATION = 8;
    static final byte SMB_COM_WRITE = 11;
    static final byte SMB_COM_CHECK_DIRECTORY = 16;
    static final byte SMB_COM_TRANSACTION = 37;
    static final byte SMB_COM_TRANSACTION_SECONDARY = 38;
    static final byte SMB_COM_MOVE = 42;
    static final byte SMB_COM_ECHO = 43;
    static final byte SMB_COM_OPEN_ANDX = 45;
    static final byte SMB_COM_READ_ANDX = 46;
    static final byte SMB_COM_WRITE_ANDX = 47;
    static final byte SMB_COM_TRANSACTION2 = 50;
    static final byte SMB_COM_FIND_CLOSE2 = 52;
    static final byte SMB_COM_TREE_DISCONNECT = 113;
    static final byte SMB_COM_NEGOTIATE = 114;
    static final byte SMB_COM_SESSION_SETUP_ANDX = 115;
    static final byte SMB_COM_LOGOFF_ANDX = 116;
    static final byte SMB_COM_TREE_CONNECT_ANDX = 117;
    static final byte SMB_COM_NT_CREATE_ANDX = -94;
    byte command;
    byte flags = (byte)24;
    int headerStart;
    int length;
    int batchLevel = 0;
    int errorCode;
    int flags2;
    int tid;
    int pid = PID;
    int uid;
    int mid;
    int wordCount;
    int byteCount;
    boolean useUnicode;
    boolean received;
    long responseTimeout = 1L;
    int verifySequence;
    boolean verifyFailed;
    NtlmPasswordAuthentication auth = null;
    String path;

    static void writeInt2(long val, byte[] dst, int dstIndex) {
        dst[dstIndex] = (byte)val;
        dst[++dstIndex] = (byte)(val >> 8);
    }

    static void writeInt4(long val, byte[] dst, int dstIndex) {
        dst[dstIndex] = (byte)val;
        dst[++dstIndex] = (byte)(val >>= 8);
        dst[++dstIndex] = (byte)(val >>= 8);
        dst[++dstIndex] = (byte)(val >> 8);
    }

    static int readInt2(byte[] src, int srcIndex) {
        return (src[srcIndex] & 0xFF) + ((src[srcIndex + 1] & 0xFF) << 8);
    }

    static int readInt4(byte[] src, int srcIndex) {
        return (src[srcIndex] & 0xFF) + ((src[srcIndex + 1] & 0xFF) << 8) + ((src[srcIndex + 2] & 0xFF) << 16) + ((src[srcIndex + 3] & 0xFF) << 24);
    }

    static long readLong(byte[] src, int srcIndex) {
        return ((long)ServerMessageBlock.readInt4(src, srcIndex) & 0xFFFFFFFFL) + ((long)ServerMessageBlock.readInt4(src, srcIndex + 4) << 32);
    }

    static void writeInt8(long val, byte[] dst, int dstIndex) {
        dst[dstIndex] = (byte)val;
        dst[++dstIndex] = (byte)(val >>= 8);
        dst[++dstIndex] = (byte)(val >>= 8);
        dst[++dstIndex] = (byte)(val >>= 8);
        dst[++dstIndex] = (byte)(val >>= 8);
        dst[++dstIndex] = (byte)(val >>= 8);
        dst[++dstIndex] = (byte)(val >>= 8);
        dst[++dstIndex] = (byte)(val >> 8);
    }

    static long readTime(byte[] src, int srcIndex) {
        int low = ServerMessageBlock.readInt4(src, srcIndex);
        int hi = ServerMessageBlock.readInt4(src, srcIndex + 4);
        long t = (long)hi << 32 | (long)low & 0xFFFFFFFFL;
        t = t / 10000L - 11644473600000L;
        return t;
    }

    static void writeTime(long t, byte[] dst, int dstIndex) {
        if (t != 0L) {
            t = (t + 11644473600000L) * 10000L;
        }
        ServerMessageBlock.writeInt8(t, dst, dstIndex);
    }

    static long readUTime(byte[] buffer, int bufferIndex) {
        return (long)ServerMessageBlock.readInt4(buffer, bufferIndex) * 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeUTime(long t, byte[] dst, int dstIndex) {
        if (t == 0L || t == -1L) {
            ServerMessageBlock.writeInt4(-1L, dst, dstIndex);
            return;
        }
        TimeZone timeZone = TZ;
        synchronized (timeZone) {
            if (TZ.inDaylightTime(new Date())) {
                if (!TZ.inDaylightTime(new Date(t))) {
                    t -= 3600000L;
                }
            } else if (TZ.inDaylightTime(new Date(t))) {
                t += 3600000L;
            }
        }
        ServerMessageBlock.writeInt4((int)(t / 1000L), dst, dstIndex);
    }

    ServerMessageBlock() {
    }

    int writeString(String str, byte[] dst, int dstIndex) {
        return this.writeString(str, dst, dstIndex, this.useUnicode);
    }

    int writeString(String str, byte[] dst, int dstIndex, boolean useUnicode) {
        int start;
        block4: {
            start = dstIndex;
            try {
                if (useUnicode) {
                    if ((dstIndex - this.headerStart) % 2 != 0) {
                        dst[dstIndex++] = 0;
                    }
                    System.arraycopy(str.getBytes("UnicodeLittleUnmarked"), 0, dst, dstIndex, str.length() * 2);
                    dstIndex += str.length() * 2;
                    dst[dstIndex++] = 0;
                    dst[dstIndex++] = 0;
                    break block4;
                }
                byte[] b = str.getBytes(encoding);
                System.arraycopy(b, 0, dst, dstIndex, b.length);
                dstIndex += b.length;
                dst[dstIndex++] = 0;
            }
            catch (UnsupportedEncodingException uee) {
                Log.printStackTrace("smb exception", uee);
            }
        }
        return dstIndex - start;
    }

    String readString(byte[] src, int srcIndex) {
        return this.readString(src, srcIndex, 256, this.useUnicode);
    }

    /*
     * Unable to fully structure code
     */
    String readString(byte[] src, int srcIndex, int maxLen, boolean useUnicode) {
        block5: {
            len = 0;
            str = null;
            try {
                if (!useUnicode) ** GOTO lbl15
                if ((srcIndex - this.headerStart) % 2 != 0) {
                    ++srcIndex;
                }
                while (src[srcIndex + len] != 0 || src[srcIndex + len + 1] != 0) {
                    if ((len += 2) <= maxLen) continue;
                    jcifs.util.Log.printHexDump(System.err, src, 0, 256);
                    throw new RuntimeException("zero termination not found");
                }
                str = new String(src, srcIndex, len, "UnicodeLittle");
                break block5;
lbl-1000:
                // 1 sources

                {
                    if (++len <= maxLen) continue;
                    throw new RuntimeException("zero termination not found");
lbl15:
                    // 2 sources

                    ** while (src[srcIndex + len] != 0)
                }
lbl16:
                // 1 sources

                str = new String(src, srcIndex, len, ServerMessageBlock.encoding);
            }
            catch (UnsupportedEncodingException uee) {
                Log.printStackTrace("smb exception", uee);
            }
        }
        return str;
    }

    int stringWireLength(String str, int offset) {
        int len = str.length() + 1;
        if (this.useUnicode) {
            len = str.length() * 2 + 2;
            len = offset % 2 != 0 ? len + 1 : len;
        }
        return len;
    }

    int readStringLength(byte[] src, int srcIndex, int max) {
        int len = 0;
        while (src[srcIndex + len] != 0) {
            if (len++ <= max) continue;
            throw new RuntimeException("zero termination not found: " + this);
        }
        return len;
    }

    int writeWireFormat(byte[] dst, int dstIndex) {
        int start = this.headerStart = dstIndex;
        dstIndex += this.writeHeaderWireFormat(dst, dstIndex);
        this.wordCount = this.writeParameterWordsWireFormat(dst, dstIndex + 1);
        dst[dstIndex++] = (byte)(this.wordCount / 2 & 0xFF);
        this.wordCount /= 2;
        this.byteCount = this.writeBytesWireFormat(dst, (dstIndex += this.wordCount) + 2);
        dst[dstIndex++] = (byte)(this.byteCount & 0xFF);
        dst[dstIndex++] = (byte)(this.byteCount >> 8 & 0xFF);
        this.length = (dstIndex += this.byteCount) - start;
        return this.length;
    }

    int readWireFormat(InputStream in, byte[] buffer, int bufferIndex) throws IOException {
        int n;
        int start = this.headerStart = bufferIndex;
        if (in.read(buffer, bufferIndex, 32) != 32) {
            throw new IOException("unexpected EOF reading smb header");
        }
        bufferIndex += this.readHeaderWireFormat(buffer, bufferIndex);
        this.wordCount = in.read();
        if (this.wordCount == -1) {
            throw new IOException("unexpected EOF reading smb wordCount");
        }
        buffer[bufferIndex++] = (byte)(this.wordCount & 0xFF);
        if (this.wordCount != 0) {
            if (in.read(buffer, bufferIndex, this.wordCount * 2) != this.wordCount * 2) {
                throw new IOException("unexpected EOF reading smb parameter words");
            }
            n = this.readParameterWordsWireFormat(buffer, bufferIndex);
            if (n != this.wordCount * 2) {
                Log.println(2, "smb packet format warning", "wordCount * 2=" + this.wordCount * 2 + " but readParameterWordsWireFormat returned " + n);
            }
            bufferIndex += this.wordCount * 2;
        }
        if (in.read(buffer, bufferIndex, 2) != 2) {
            throw new IOException("unexpected EOF reading smb byteCount");
        }
        this.byteCount = ServerMessageBlock.readInt2(buffer, bufferIndex);
        bufferIndex += 2;
        if (this.byteCount != 0) {
            if (in.read(buffer, bufferIndex, this.byteCount) != this.byteCount) {
                throw new IOException("unexpected EOF reading smb");
            }
            n = this.readBytesWireFormat(buffer, bufferIndex);
            if (n != this.byteCount) {
                Log.println(2, "smb packet format warning", "byteCount=" + this.byteCount + " but readBytesWireFormat returned " + n);
            }
            bufferIndex += this.byteCount;
        }
        this.length = bufferIndex - start;
        return this.length;
    }

    int writeHeaderWireFormat(byte[] dst, int dstIndex) {
        System.arraycopy(header, 0, dst, dstIndex, header.length);
        dst[dstIndex + 4] = this.command;
        dst[dstIndex + 9] = this.flags;
        ServerMessageBlock.writeInt2(this.flags2, dst, dstIndex + 9 + 1);
        ServerMessageBlock.writeInt2(this.tid, dst, dstIndex += 24);
        ServerMessageBlock.writeInt2(this.pid, dst, dstIndex + 2);
        ServerMessageBlock.writeInt2(this.uid, dst, dstIndex + 4);
        ServerMessageBlock.writeInt2(this.mid, dst, dstIndex + 6);
        return 32;
    }

    int readHeaderWireFormat(byte[] buffer, int bufferIndex) throws IOException {
        this.command = buffer[bufferIndex + 4];
        this.errorCode = ServerMessageBlock.readInt4(buffer, bufferIndex + 5);
        this.flags = buffer[bufferIndex + 9];
        this.flags2 = ServerMessageBlock.readInt2(buffer, bufferIndex + 9 + 1);
        this.tid = ServerMessageBlock.readInt2(buffer, bufferIndex + 24);
        this.pid = ServerMessageBlock.readInt2(buffer, bufferIndex + 24 + 2);
        this.uid = ServerMessageBlock.readInt2(buffer, bufferIndex + 24 + 4);
        this.mid = ServerMessageBlock.readInt2(buffer, bufferIndex + 24 + 6);
        return 32;
    }

    boolean isResponse() {
        return (this.flags & 0x80) == 128;
    }

    abstract int writeParameterWordsWireFormat(byte[] var1, int var2);

    abstract int writeBytesWireFormat(byte[] var1, int var2);

    abstract int readParameterWordsWireFormat(byte[] var1, int var2) throws IOException;

    abstract int readBytesWireFormat(byte[] var1, int var2) throws IOException;

    public String toString() {
        String c;
        switch (this.command) {
            case 114: {
                c = "SMB_COM_NEGOTIATE";
                break;
            }
            case 115: {
                c = "SMB_COM_SESSION_SETUP_ANDX";
                break;
            }
            case 117: {
                c = "SMB_COM_TREE_CONNECT_ANDX";
                break;
            }
            case 8: {
                c = "SMB_COM_QUERY_INFORMATION";
                break;
            }
            case 16: {
                c = "SMB_COM_CHECK_DIRECTORY";
                break;
            }
            case 37: {
                c = "SMB_COM_TRANSACTION";
                break;
            }
            case 50: {
                c = "SMB_COM_TRANSACTION2";
                break;
            }
            case 38: {
                c = "SMB_COM_TRANSACTION_SECONDARY";
                break;
            }
            case 52: {
                c = "SMB_COM_FIND_CLOSE2";
                break;
            }
            case 113: {
                c = "SMB_COM_TREE_DISCONNECT";
                break;
            }
            case 116: {
                c = "SMB_COM_LOGOFF_ANDX";
                break;
            }
            case 43: {
                c = "SMB_COM_ECHO";
                break;
            }
            case 42: {
                c = "SMB_COM_MOVE";
                break;
            }
            case 7: {
                c = "SMB_COM_RENAME";
                break;
            }
            case 6: {
                c = "SMB_COM_DELETE";
                break;
            }
            case 1: {
                c = "SMB_COM_DELETE_DIRECTORY";
                break;
            }
            case -94: {
                c = "SMB_COM_NT_CREATE_ANDX";
                break;
            }
            case 45: {
                c = "SMB_COM_OPEN_ANDX";
                break;
            }
            case 46: {
                c = "SMB_COM_READ_ANDX";
                break;
            }
            case 4: {
                c = "SMB_COM_CLOSE";
                break;
            }
            case 47: {
                c = "SMB_COM_WRITE_ANDX";
                break;
            }
            case 0: {
                c = "SMB_COM_CREATE_DIRECTORY";
                break;
            }
            default: {
                c = "UNKNOWN";
            }
        }
        return new String("command=" + c + ",received=" + this.received + ",errorCode=" + SmbException.getErrorString(this.errorCode) + ",flags=0x" + Log.getHexString(this.flags & 0xFF, 4) + ",flags2=0x" + Log.getHexString(this.flags2, 4) + ",tid=" + this.tid + ",pid=" + this.pid + ",uid=" + this.uid + ",mid=" + this.mid + ",wordCount=" + this.wordCount + ",byteCount=" + this.byteCount);
    }
}

