/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.io.InputStream;
import jcifs.Config;
import jcifs.smb.AndXServerMessageBlock;
import jcifs.smb.ServerMessageBlock;

class SmbComReadAndX
extends AndXServerMessageBlock {
    static final int BATCH_LIMIT = Config.getInt("jcifs.smb.client.ReadAndX.Close", 1);
    long offset;
    int fid;
    int maxCount;
    int minCount;
    int openTimeout;
    int remaining;

    SmbComReadAndX() {
        super(null);
        this.command = (byte)46;
        this.openTimeout = -1;
    }

    SmbComReadAndX(int fid, long offset, int maxCount, ServerMessageBlock andx) {
        super(andx);
        this.fid = fid;
        this.offset = offset;
        this.maxCount = this.minCount = maxCount;
        this.command = (byte)46;
        this.openTimeout = -1;
    }

    void setParam(int fid, long offset, int maxCount) {
        this.fid = fid;
        this.offset = offset;
        this.maxCount = this.minCount = maxCount;
    }

    int getBatchLimit(byte command) {
        return command == 4 ? BATCH_LIMIT : 0;
    }

    int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        ServerMessageBlock.writeInt2(this.fid, dst, dstIndex);
        ServerMessageBlock.writeInt4(this.offset, dst, dstIndex += 2);
        ServerMessageBlock.writeInt2(this.maxCount, dst, dstIndex += 4);
        ServerMessageBlock.writeInt2(this.minCount, dst, dstIndex += 2);
        ServerMessageBlock.writeInt4(this.openTimeout, dst, dstIndex += 2);
        ServerMessageBlock.writeInt2(this.remaining, dst, dstIndex += 4);
        ServerMessageBlock.writeInt4(this.offset >> 32, dst, dstIndex += 2);
        return (dstIndex += 4) - start;
    }

    int writeBytesWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    int readBytesDirectWireFormat(InputStream in, int byteCount) throws IOException {
        return 0;
    }

    public String toString() {
        return new String("SmbComReadAndX[" + super.toString() + ",fid=" + this.fid + ",offset=" + this.offset + ",maxCount=" + this.maxCount + ",minCount=" + this.minCount + ",openTimeout=" + this.openTimeout + ",remaining=" + this.remaining + ",offset=" + this.maxCount + "]");
    }
}

