/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;
import jcifs.Config;
import jcifs.UniAddress;
import jcifs.netbios.NbtAddress;
import jcifs.netbios.NbtException;
import jcifs.netbios.NbtSocket;
import jcifs.smb.AndXServerMessageBlock;
import jcifs.smb.BufferCache;
import jcifs.smb.DfsReferral;
import jcifs.smb.Log;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.ServerMessageBlock;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbComBlankResponse;
import jcifs.smb.SmbComNegotiate;
import jcifs.smb.SmbComNegotiateResponse;
import jcifs.smb.SmbComReadAndXResponse;
import jcifs.smb.SmbComTransaction;
import jcifs.smb.SmbComTransactionResponse;
import jcifs.smb.SmbException;
import jcifs.smb.SmbSession;
import jcifs.smb.SmbTree;
import jcifs.smb.Trans2GetDfsReferral;
import jcifs.smb.Trans2GetDfsReferralResponse;

class SmbTransport
implements Runnable {
    private static final byte[] LMV2_CROSSDOMAIN_KEY = new byte[16];
    private static final int DEFAULT_MAX_MPX_COUNT = 10;
    private static final int DEFAULT_RESPONSE_TIMEOUT = 10000;
    private static final int DEFAULT_SO_TIMEOUT = 15000;
    private static final int PUSHBACK_BUF_SIZE = 64;
    private static final int DEFAULT_RCV_BUF_SIZE = 60416;
    private static final int DEFAULT_SND_BUF_SIZE = 5000;
    private static final int DEFAULT_SSN_LIMIT = 250;
    private static final int LM_COMPATIBILITY = Config.getInt("jcifs.smb.lmCompatibility", 0);
    static final int MID_OFFSET = 30;
    static final int HEADER_LENGTH = 32;
    static final int FLAGS_OFFSET = 9;
    static final int FLAGS_RESPONSE = 128;
    static final int ST_GROUND = 0;
    static final int ST_NEGOTIATING = 1;
    private NbtSocket socket;
    private InputStream in;
    private OutputStream out;
    private int localPort;
    private int soTimeout;
    private int responseTimeout;
    private long closeTime;
    private InetAddress localAddr;
    private Hashtable responseTable;
    private Thread thread;
    private Object outLock;
    private MessageDigest signingDigest;
    private static Vector connections = new Vector();
    private static MpxControl mpxCtrl = new MpxControl();
    private static byte[] snd_buf = new byte[65535];
    private static byte[] rcv_buf = new byte[65535];
    LinkedList sessions;
    boolean negotiated;
    boolean useUnicode;
    boolean useSigning;
    UniAddress address;
    byte[] macSigningKey;
    int signSequence;
    int port;
    int rcv_buf_size;
    int snd_buf_size;
    int negotiatedDialectIndex;
    int negotiatedMaxMpxCount;
    int negotiatedMaxBufferSize;
    int negotiatedCapabilities;
    int ssnLimit = Config.getInt("jcifs.smb.client.ssnLimit", 250);
    int state;
    ClientProperties client = new ClientProperties();
    ServerProperties server = new ServerProperties();
    LinkedList referrals = new LinkedList();

    static synchronized SmbTransport getSmbTransport(UniAddress address, int port) {
        return SmbTransport.getSmbTransport(address, port, Config.getInetAddress("jcifs.smb.client.laddr", null), Config.getInt("jcifs.smb.client.lport", 0));
    }

    static synchronized SmbTransport getSmbTransport(UniAddress address, int port, InetAddress localAddr, int localPort) {
        SmbTransport conn;
        Enumeration e = connections.elements();
        while (e.hasMoreElements()) {
            conn = (SmbTransport)e.nextElement();
            if (!conn.matches(address, port, localAddr, localPort)) continue;
            return conn;
        }
        conn = new SmbTransport(address, port, localAddr, localPort);
        connections.addElement(conn);
        return conn;
    }

    SmbTransport(UniAddress address, int port, InetAddress localAddr, int localPort) {
        this.address = address;
        this.port = port;
        this.localAddr = localAddr;
        this.localPort = localPort;
        this.useUnicode = Config.getBoolean("jcifs.smb.client.useUnicode", true);
        if (!this.useUnicode) {
            this.client.flags2 &= Short.MAX_VALUE;
            this.client.capabilities &= 0xFFFB;
        }
        if (!Config.getBoolean("jcifs.smb.client.useNTSmbs", true)) {
            this.client.capabilities &= 0xFFFFFFEF;
        }
        this.useSigning = Config.getBoolean("jcifs.smb.client.signingPreferred", false);
        if (this.useSigning) {
            this.client.flags2 |= 4;
        }
        this.soTimeout = Config.getInt("jcifs.smb.client.soTimeout", 15000);
        this.responseTimeout = Config.getInt("jcifs.smb.client.responseTimeout", 10000);
        this.rcv_buf_size = Config.getInt("jcifs.smb.client.rcv_buf_size", 60416);
        this.snd_buf_size = this.client.maxBufferSize;
        this.sessions = new LinkedList();
        this.responseTable = new Hashtable();
        this.outLock = new Object();
        this.state = 0;
    }

    synchronized SmbSession getSmbSession() {
        return this.getSmbSession(new NtlmPasswordAuthentication(null, null, null));
    }

    synchronized SmbSession getSmbSession(NtlmPasswordAuthentication auth) {
        SmbSession ssn;
        ListIterator iter = this.sessions.listIterator();
        while (iter.hasNext()) {
            ssn = (SmbSession)iter.next();
            if (!ssn.matches(auth)) continue;
            ssn.auth = auth;
            return ssn;
        }
        ssn = new SmbSession(this, auth);
        this.sessions.add(ssn);
        if (this.sessions.size() > this.ssnLimit) {
            int nclose = this.sessions.size() / 10;
            while (nclose-- > 0) {
                SmbSession s = (SmbSession)this.sessions.removeFirst();
                s.logoff(false);
            }
        }
        return ssn;
    }

    boolean matches(UniAddress address, int port, InetAddress localAddr, int localPort) {
        InetAddress defaultLocal = null;
        try {
            defaultLocal = InetAddress.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        int p1 = port == 0 || port == 139 ? 0 : port;
        int p2 = this.port == 0 || this.port == 139 ? 0 : this.port;
        InetAddress la1 = localAddr == null ? defaultLocal : localAddr;
        InetAddress la2 = this.localAddr == null ? defaultLocal : this.localAddr;
        return address.equals(this.address) && p1 == p2 && la1.equals(la2) && localPort == this.localPort;
    }

    boolean hasCapability(int cap) throws SmbException {
        if (this.state == 0) {
            this.negotiate();
        }
        return (this.negotiatedCapabilities & cap) == cap;
    }

    void ensureOpen() throws IOException {
        if (this.socket == null) {
            NbtAddress naddr;
            Object obj = this.address.getAddress();
            if (obj instanceof NbtAddress) {
                naddr = (NbtAddress)obj;
            } else {
                try {
                    naddr = NbtAddress.getByName(((InetAddress)obj).getHostAddress());
                }
                catch (UnknownHostException uhe) {
                    naddr = null;
                }
            }
            String calledName = this.address.firstCalledName();
            while (true) {
                try {
                    this.socket = new NbtSocket(naddr, calledName, this.port, this.localAddr, this.localPort);
                }
                catch (NbtException ne) {
                    if (ne.errorClass != 2 || ne.errorCode != 130 && ne.errorCode != 128) {
                        throw ne;
                    }
                    Log.println(2, "smb warning", ne.getMessage());
                    if ((calledName = this.address.nextCalledName()) != null) continue;
                }
                break;
            }
            if (calledName == null) {
                throw new IOException("Failed to establish session with " + this.address);
            }
            this.server.tconHostName = calledName == "*SMBSERVER     " ? this.address.getHostAddress() : calledName;
            if (Config.getBoolean("jcifs.smb.client.tcpNoDelay", false)) {
                this.socket.setTcpNoDelay(true);
            }
            this.in = new PushbackInputStream(this.socket.getInputStream(), 64);
            this.out = this.socket.getOutputStream();
            this.thread = new Thread((Runnable)this, "JCIFS-SmbTransport");
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    void tryClose(boolean inError) {
        if (this.socket == null) {
            inError = true;
        }
        ListIterator iter = this.sessions.listIterator();
        while (iter.hasNext()) {
            SmbSession ssn = (SmbSession)iter.next();
            ssn.logoff(inError);
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        this.in = null;
        this.out = null;
        this.socket = null;
        this.thread = null;
        this.responseTable.clear();
        this.state = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        magic = new int[]{255, 83, 77, 66};
        while (this.thread == Thread.currentThread()) {
            try {
                block25: {
                    block24: {
                        block26: {
                            block28: {
                                block27: {
                                    this.socket.setSoTimeout(this.soTimeout);
                                    m = 0;
                                    while (true) {
                                        if (m >= 4) {
                                            var8_6 = SmbTransport.rcv_buf;
                                            // MONITORENTER : jcifs.smb.SmbTransport.rcv_buf
                                            SmbTransport.rcv_buf[0] = -1;
                                            SmbTransport.rcv_buf[1] = 83;
                                            SmbTransport.rcv_buf[2] = 77;
                                            SmbTransport.rcv_buf[3] = 66;
                                            if (this.in.read(SmbTransport.rcv_buf, 4, 28) == 28) break;
                                            // MONITOREXIT : var8_6
                                            return;
                                        }
                                        i = this.in.read();
                                        if (i < 0) {
                                            return;
                                        }
                                        if ((i & 255) == magic[m]) {
                                            ++m;
                                            continue;
                                        }
                                        if ((i & 255) == 255) {
                                            m = 1;
                                            continue;
                                        }
                                        m = 0;
                                    }
                                    ((PushbackInputStream)this.in).unread(SmbTransport.rcv_buf, 0, 32);
                                    if (SmbTransport.rcv_buf[0] != -1 || SmbTransport.rcv_buf[1] != 83 || SmbTransport.rcv_buf[2] != 77 || SmbTransport.rcv_buf[3] != 66) {
                                        Log.println(2, "smb warning", "bad smb header, purging session message");
                                        this.in.skip(this.in.available());
                                        // MONITOREXIT : var8_6
                                        continue;
                                    }
                                    if ((SmbTransport.rcv_buf[9] & 128) != 128) break block25;
                                    mid = ServerMessageBlock.readInt2(SmbTransport.rcv_buf, 30);
                                    response = (ServerMessageBlock)this.responseTable.get(new Integer(mid));
                                    if (response == null) {
                                        Log.println(2, "smb warning", " no handler for mid=" + mid + ", purging session message");
                                        this.in.skip(this.in.available());
                                        // MONITOREXIT : var8_6
                                        continue;
                                    }
                                    var9_8 = response;
                                    // MONITORENTER : var9_8
                                    response.useUnicode = this.useUnicode;
                                    Log.println(4, "smb transport warning", " new data read from socket");
                                    if (!(response instanceof SmbComTransactionResponse)) break block26;
                                    e = (Enumeration)response;
                                    if (!e.hasMoreElements()) break block27;
                                    e.nextElement();
                                    response.readWireFormat(this.in, SmbTransport.rcv_buf, 0);
                                    response.received = true;
                                    Log.printMessageData("smb received", response);
                                    if (response.errorCode != 0) ** GOTO lbl-1000
                                    break block28;
                                }
                                Log.println(2, "smb warning", "more responses to transaction than expected");
                                // MONITOREXIT : var9_8
                                // MONITOREXIT : var8_6
                                continue;
                            }
                            if (!e.hasMoreElements()) lbl-1000:
                            // 2 sources

                            {
                                ((SmbComTransactionResponse)response).hasMore = false;
                                if (this.useSigning) {
                                    response.verifyFailed = this.verify(SmbTransport.rcv_buf, 0, response);
                                }
                                response.notify();
                                break block24;
                            } else {
                                this.ensureOpen();
                            }
                            break block24;
                        }
                        response.readWireFormat(this.in, SmbTransport.rcv_buf, 0);
                        response.received = true;
                        Log.printMessageData("smb received", response);
                        smb = response;
                        while (true) {
                            if (!(smb instanceof AndXServerMessageBlock) || (smb = ((AndXServerMessageBlock)smb).andx) == null) {
                                Log.printHexDump("smb received", SmbTransport.rcv_buf, 0, response.length);
                                if (this.useSigning) {
                                    response.verifyFailed = this.verify(SmbTransport.rcv_buf, 0, response);
                                }
                                response.notify();
                                break;
                            }
                            Log.printMessageData("smb andx data", smb);
                        }
                    }
                    // MONITOREXIT : var9_8
                }
                // MONITOREXIT : var8_6
            }
            catch (InterruptedIOException iioe) {
                if (this.responseTable.size() == 0) {
                    this.tryClose(false);
                    continue;
                }
                Log.println(2, "smb warning", " soTimeout has occured but there are " + this.responseTable.size() + " pending requests");
            }
            catch (IOException ioe) {
                var10_10 = this;
                // MONITORENTER : var10_10
                this.tryClose(true);
                // MONITOREXIT : var10_10
                if (ioe.getMessage().startsWith("Connection reset")) continue;
                Log.printStackTrace("exception reading from socket input: " + this.address, ioe);
            }
        }
    }

    void initSigning(NtlmPasswordAuthentication auth) throws SmbException {
        if (auth.hashesExternal) {
            this.useSigning = false;
            return;
        }
        this.signSequence = 0;
        switch (LM_COMPATIBILITY) {
            case 0: 
            case 1: 
            case 2: {
                this.macSigningKey = new byte[40];
                try {
                    auth.getUserSessionKey(this.server.encryptionKey, this.macSigningKey, 0);
                    System.arraycopy(auth.getUnicodeHash(this.server.encryptionKey), 0, this.macSigningKey, 16, 24);
                }
                catch (Exception ex) {
                    Log.printStackTrace("Unable to calculate MAC signing key.", ex);
                    this.macSigningKey = null;
                }
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                this.macSigningKey = new byte[16];
                try {
                    auth.getUserSessionKey(this.server.encryptionKey, this.macSigningKey, 0);
                }
                catch (Exception ex) {
                    Log.printStackTrace("Unable to calculate MAC signing key.", ex);
                    this.macSigningKey = null;
                }
                break;
            }
            default: {
                this.macSigningKey = new byte[40];
                try {
                    auth.getUserSessionKey(this.server.encryptionKey, this.macSigningKey, 0);
                    System.arraycopy(auth.getUnicodeHash(this.server.encryptionKey), 0, this.macSigningKey, 16, 24);
                }
                catch (Exception ex) {
                    Log.printStackTrace("Unable to calculate MAC signing key.", ex);
                    this.macSigningKey = null;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sign(byte[] data, int offset, int length) {
        if (this.macSigningKey == null) {
            return;
        }
        try {
            try {
                this.signingDigest.update(this.macSigningKey);
                int index = offset + 14;
                int i = 0;
                while (i < 8) {
                    data[index + i] = 0;
                    ++i;
                }
                ServerMessageBlock.writeInt4(this.signSequence, data, index);
                this.signingDigest.update(data, offset, length);
                System.arraycopy(this.signingDigest.digest(), 0, data, index, 8);
            }
            catch (Exception ex) {
                Log.printStackTrace("Error signing SMB.", ex);
                Object var7_8 = null;
                this.signSequence += 2;
            }
            Object var7_7 = null;
            this.signSequence += 2;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.signSequence += 2;
            throw throwable;
        }
    }

    private boolean verify(byte[] data, int offset, ServerMessageBlock response) throws IOException {
        if (this.macSigningKey == null) {
            return false;
        }
        this.signingDigest.update(this.macSigningKey);
        int index = offset;
        this.signingDigest.update(data, index, 14);
        index += 14;
        byte[] sequence = new byte[8];
        ServerMessageBlock.writeInt4(response.verifySequence, sequence, 0);
        this.signingDigest.update(sequence);
        index += 8;
        if (response.command == 46) {
            SmbComReadAndXResponse raxr = (SmbComReadAndXResponse)response;
            int length = response.length - raxr.dataLength;
            this.signingDigest.update(data, index, length - 14 - 8);
            this.signingDigest.update(raxr.b, raxr.off, raxr.dataLength);
        } else {
            this.signingDigest.update(data, index, response.length - 14 - 8);
        }
        byte[] signature = this.signingDigest.digest();
        int i = 0;
        while (i < 8) {
            if (signature[i] != data[offset + 14 + i]) {
                if (Arrays.equals(LMV2_CROSSDOMAIN_KEY, this.macSigningKey)) {
                    return true;
                }
                this.signingDigest.update(LMV2_CROSSDOMAIN_KEY);
                index = offset;
                this.signingDigest.update(data, index, 14);
                index += 14;
                ServerMessageBlock.writeInt4(response.verifySequence, sequence, 0);
                this.signingDigest.update(sequence);
                this.signingDigest.update(data, index += 8, response.length - 14 - 8);
                signature = this.signingDigest.digest();
                i = 0;
                while (i < 8) {
                    if (signature[i] != data[offset + 14 + i]) {
                        return true;
                    }
                    ++i;
                }
                this.macSigningKey = LMV2_CROSSDOMAIN_KEY;
                break;
            }
            ++i;
        }
        return false;
    }

    synchronized DfsReferral getDfsReferral(NtlmPasswordAuthentication auth, String path) throws SmbException {
        int s;
        int p;
        int i;
        DfsReferral dr = new DfsReferral();
        SmbTree ipc = this.getSmbSession(auth).getSmbTree("IPC$", null);
        Trans2GetDfsReferralResponse resp = new Trans2GetDfsReferralResponse();
        ipc.sendTransaction(new Trans2GetDfsReferral(path), resp);
        String subpath = path.substring(0, resp.pathConsumed);
        String node = resp.referral.node;
        if (subpath.charAt(0) != '\\' || (i = subpath.indexOf(92, 1)) < 2 || (p = subpath.indexOf(92, i + 1)) < i + 2 || node.charAt(0) != '\\' || (s = node.indexOf(92, 1)) < 2) {
            throw new SmbException(32, 5007, "Invalid DFS path: " + path);
        }
        int n = node.indexOf(92, s + 1);
        if (n == -1) {
            n = node.length();
        }
        dr.path = subpath.substring(p);
        dr.node = node.substring(0, n);
        dr.nodepath = node.substring(n);
        dr.server = node.substring(1, s);
        dr.share = node.substring(s, n);
        dr.resolveHashes = auth.hashesExternal;
        return dr;
    }

    synchronized DfsReferral lookupReferral(String unc) {
        ListIterator iter = this.referrals.listIterator();
        while (iter.hasNext()) {
            DfsReferral dr = (DfsReferral)iter.next();
            int len = dr.path.length();
            int i = 0;
            while (i < len && i < unc.length()) {
                if (dr.path.charAt(i) != unc.charAt(i)) break;
                ++i;
            }
            if (i != len) continue;
            return dr;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void send(ServerMessageBlock request, ServerMessageBlock response) throws SmbException {
        block42: {
            mid = null;
            if (this.state == 0) {
                this.negotiate();
            }
            request.flags2 |= this.client.flags2;
            request.mid = SmbTransport.aquireMid();
            request.useUnicode = this.useUnicode;
            if (response == null) {
                try {
                    try {
                        var4_4 = this.outLock;
                        // MONITORENTER : var4_4
                        this.ensureOpen();
                        var5_8 = SmbTransport.snd_buf;
                        // MONITORENTER : jcifs.smb.SmbTransport.snd_buf
                        length = request.writeWireFormat(SmbTransport.snd_buf, 0);
                        if (this.useSigning) {
                            this.sign(SmbTransport.snd_buf, 0, length);
                        }
                        this.out.write(SmbTransport.snd_buf, 0, length);
                        this.out.flush();
                        Log.printMessageData("smb sent", request);
                        smb = request;
                        while (true) {
                            if (!(smb instanceof AndXServerMessageBlock) || (smb = ((AndXServerMessageBlock)smb).andx) == null) {
                                Log.printHexDump("smb sent", SmbTransport.snd_buf, 0, request.length);
                                // MONITOREXIT : var5_8
                                // MONITOREXIT : var4_4
                                ** break;
                            }
                            Log.printMessageData("smb andx data", smb);
                        }
                    }
                    catch (IOException ioe) {
                        this.tryClose(true);
                        throw new SmbException(32, 5002, ioe.getMessage());
                    }
lbl33:
                    // 1 sources

                    var11_15 = null;
                    SmbTransport.releaseMid(request.mid);
                    return;
                }
                catch (Throwable var10_17) {
                    var11_16 = null;
                    SmbTransport.releaseMid(request.mid);
                    throw var10_17;
                }
            }
            try {
                try {
                    ioe = response;
                    // MONITORENTER : ioe
                    response.received = false;
                    mid = new Integer(request.mid);
                    this.responseTable.put(mid, response);
                    var5_9 = this.outLock;
                    // MONITORENTER : var5_9
                    this.ensureOpen();
                    var6_12 = SmbTransport.snd_buf;
                    // MONITORENTER : jcifs.smb.SmbTransport.snd_buf
                    length = request.writeWireFormat(SmbTransport.snd_buf, 0);
                    if (this.useSigning) {
                        response.verifySequence = this.signSequence + 1;
                        this.sign(SmbTransport.snd_buf, 0, length);
                    }
                    this.out.write(SmbTransport.snd_buf, 0, length);
                    this.out.flush();
                    Log.printMessageData("smb sent", request);
                    smb = request;
                    while (true) {
                        if (!(smb instanceof AndXServerMessageBlock) || (smb = ((AndXServerMessageBlock)smb).andx) == null) {
                            Log.printHexDump("smb sent", SmbTransport.snd_buf, 0, request.length);
                            // MONITOREXIT : var6_12
                            // MONITOREXIT : var5_9
                        }
                        Log.printMessageData("smb andx data", smb);
                    }
                    response.wait(response.responseTimeout == 1L ? (long)this.responseTimeout : response.responseTimeout);
                    // MONITOREXIT : ioe
                }
                catch (InterruptedException ie) {
                    this.tryClose(true);
                    var16_20 = null;
                    this.responseTable.remove(mid);
                    SmbTransport.releaseMid(request.mid);
                    break block42;
                }
                catch (IOException ioe) {
                    this.tryClose(true);
                    throw new SmbException(32, 5002, ioe.getMessage());
                }
                var16_19 = null;
                this.responseTable.remove(mid);
                SmbTransport.releaseMid(request.mid);
            }
            catch (Throwable var15_22) {
                var16_21 = null;
                this.responseTable.remove(mid);
                SmbTransport.releaseMid(request.mid);
                throw var15_22;
            }
        }
        if (!response.received) {
            this.tryClose(true);
            throw new SmbException(32, 5000, this.address);
        }
        if (response.verifyFailed) {
            this.tryClose(true);
            throw new SmbException(32, 5002, "Unverifiable signature.");
        }
        switch (response.errorCode & 255) {
            case 0: {
                return;
            }
            case 1: {
                switch (response.errorCode >> 16 & 65535) {
                    case 5: {
                        throw new SmbAuthException(response.errorCode);
                    }
                }
                throw new SmbException(response.errorCode);
            }
            case 2: {
                switch (response.errorCode >> 16 & 65535) {
                    case 3: {
                        if (request.auth == null) {
                            throw new SmbException(response.errorCode);
                        }
                        dr = this.getDfsReferral(request.auth, request.path);
                        this.referrals.add(dr);
                        throw dr;
                    }
                    case 2: 
                    case 4: 
                    case 2239: 
                    case 2240: 
                    case 2241: 
                    case 2242: {
                        throw new SmbAuthException(response.errorCode);
                    }
                }
            }
        }
        throw new SmbException(response.errorCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void sendTransaction(SmbComTransaction request, SmbComTransactionResponse response) throws SmbException {
        Integer mid = null;
        this.negotiate();
        request.flags2 |= this.client.flags2;
        request.mid = SmbTransport.aquireMid();
        mid = new Integer(request.mid);
        request.useUnicode = this.useUnicode;
        request.maxBufferSize = this.negotiatedMaxBufferSize;
        response.received = false;
        response.hasMore = true;
        response.isPrimary = true;
        try {
            Object object;
            Object object2;
            ServerMessageBlock interimResponse;
            request.txn_buf = BufferCache.getBuffer();
            response.txn_buf = BufferCache.getBuffer();
            request.nextElement();
            if (request.hasMoreElements()) {
                interimResponse = new SmbComBlankResponse();
                object2 = interimResponse;
                // MONITORENTER : object2
                this.responseTable.put(mid, interimResponse);
                object = this.outLock;
                // MONITORENTER : object
                this.ensureOpen();
                byte[] byArray = snd_buf;
                // MONITORENTER : snd_buf
                int length = request.writeWireFormat(snd_buf, 0);
                if (this.useSigning) {
                    response.verifySequence = this.signSequence + 1;
                    this.sign(snd_buf, 0, length);
                }
                this.out.write(snd_buf, 0, length);
                this.out.flush();
                Log.printMessageData("smb sent", request);
                Log.printHexDump("smb sent", snd_buf, 0, request.length);
                // MONITOREXIT : byArray
                // MONITOREXIT : object
                interimResponse.wait(this.responseTimeout);
                if (!((SmbComBlankResponse)interimResponse).received) {
                    throw new SmbException(5000);
                }
                switch (((SmbComBlankResponse)interimResponse).errorCode & 0xFF) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        switch (response.errorCode >> 16 & 0xFFFF) {
                            case 5: {
                                throw new SmbAuthException(response.errorCode);
                            }
                        }
                        throw new SmbException(response.errorCode);
                    }
                    case 2: {
                        switch (((SmbComBlankResponse)interimResponse).errorCode >> 16 & 0xFFFF) {
                            case 3: {
                                if (request.auth == null) {
                                    throw new SmbException(response.errorCode);
                                }
                                DfsReferral dr = this.getDfsReferral(request.auth, request.path);
                                this.referrals.add(dr);
                                throw dr;
                            }
                            case 2: 
                            case 4: 
                            case 2239: 
                            case 2240: 
                            case 2241: 
                            case 2242: {
                                throw new SmbAuthException(((SmbComBlankResponse)interimResponse).errorCode);
                            }
                        }
                    }
                    default: {
                        throw new SmbException(((SmbComBlankResponse)interimResponse).errorCode);
                    }
                }
                // MONITOREXIT : object2
                request.nextElement();
            }
            interimResponse = response;
            // MONITORENTER : interimResponse
            this.responseTable.put(mid, response);
            do {
                object2 = this.outLock;
                // MONITORENTER : object2
                this.ensureOpen();
                object = snd_buf;
                // MONITORENTER : snd_buf
                int length = request.writeWireFormat(snd_buf, 0);
                if (this.useSigning) {
                    response.verifySequence = this.signSequence + 1;
                    this.sign(snd_buf, 0, length);
                }
                this.out.write(snd_buf, 0, length);
                this.out.flush();
                Log.printMessageData("smb sent", request);
                Log.printHexDump("smb sent", snd_buf, 0, request.length);
                // MONITOREXIT : object
                // MONITOREXIT : object2
            } while (request.hasMoreElements() && request.nextElement() != null);
            do {
                response.received = false;
                response.wait(response.responseTimeout == 1L ? (long)this.responseTimeout : response.responseTimeout);
            } while (response.received && response.hasMoreElements());
            // MONITOREXIT : interimResponse
        }
        catch (InterruptedException ie) {
            this.tryClose(true);
        }
        catch (IOException ioe) {
            this.tryClose(true);
            throw new SmbException(32, 5002, ioe.getMessage());
        }
        finally {
            this.responseTable.remove(mid);
            SmbTransport.releaseMid(request.mid);
            BufferCache.releaseBuffer(request.txn_buf);
            BufferCache.releaseBuffer(response.txn_buf);
        }
        if (!response.received) {
            this.tryClose(true);
            throw new SmbException(32, 5000, this.address);
        }
        if (response.verifyFailed) {
            this.tryClose(true);
            throw new SmbException(32, 5002, "Unverifiable signature.");
        }
        switch (response.errorCode & 0xFF) {
            case 0: {
                return;
            }
            case 1: {
                switch (response.errorCode >> 16 & 0xFFFF) {
                    case 5: {
                        throw new SmbAuthException(response.errorCode);
                    }
                }
                throw new SmbException(response.errorCode);
            }
            case 2: {
                switch (response.errorCode >> 16 & 0xFFFF) {
                    case 3: {
                        if (request.auth == null) {
                            throw new SmbException(response.errorCode);
                        }
                        DfsReferral dr = this.getDfsReferral(request.auth, request.path);
                        this.referrals.add(dr);
                        throw dr;
                    }
                    case 2: 
                    case 4: 
                    case 2239: 
                    case 2240: 
                    case 2241: 
                    case 2242: {
                        throw new SmbAuthException(response.errorCode);
                    }
                }
            }
        }
        throw new SmbException(response.errorCode);
    }

    synchronized void negotiate() throws SmbException {
        if (this.state >= 1) {
            return;
        }
        this.state = 1;
        Log.println(2, "smb negotiation warning", " requesting negotiation with " + this.address);
        this.macSigningKey = null;
        SmbComNegotiateResponse response = new SmbComNegotiateResponse();
        this.send(new SmbComNegotiate(), response);
        if (response.dialectIndex > 10) {
            this.tryClose(true);
            throw new SmbException(32, 5001);
        }
        this.server.securityMode = response.securityMode;
        this.server.security = response.security;
        this.server.encryptedPasswords = response.encryptedPasswords;
        this.server.signaturesEnabled = response.signaturesEnabled;
        this.server.signaturesRequired = response.signaturesRequired;
        if (this.server.signaturesRequired || this.server.signaturesEnabled && this.useSigning) {
            this.useSigning = true;
            this.client.flags2 |= 4;
            if (this.signingDigest == null) {
                try {
                    this.signingDigest = MessageDigest.getInstance("MD5");
                }
                catch (Exception ex) {
                    Log.printStackTrace("Unable to obtain MD5 digest.", ex);
                    return;
                }
            }
        } else {
            this.useSigning = false;
            this.client.flags2 &= 0xFFFB;
        }
        this.negotiatedDialectIndex = response.dialectIndex;
        this.server.maxMpxCount = response.maxMpxCount;
        this.negotiatedMaxMpxCount = this.client.maxMpxCount < this.server.maxMpxCount ? this.client.maxMpxCount : this.server.maxMpxCount;
        SmbTransport.mpxCtrl.maxMpxCount = this.negotiatedMaxMpxCount < 1 ? 1 : this.negotiatedMaxMpxCount;
        this.server.maxNumberVcs = response.maxNumberVcs;
        this.server.maxBufferSize = response.maxBufferSize;
        this.negotiatedMaxBufferSize = this.client.maxBufferSize < this.server.maxBufferSize ? this.client.maxBufferSize : this.server.maxBufferSize;
        this.server.maxRawSize = response.maxRawSize;
        this.server.sessionKey = response.sessionKey;
        this.server.capabilities = response.capabilities;
        this.negotiatedCapabilities = this.client.capabilities & this.server.capabilities;
        if ((this.negotiatedCapabilities & 4) == 0) {
            if (Config.getBoolean("jcifs.smb.client.useUnicode", false)) {
                this.negotiatedCapabilities |= 4;
            } else {
                this.useUnicode = false;
                this.client.flags2 &= Short.MAX_VALUE;
            }
        }
        this.server.serverTime = response.serverTime;
        this.server.serverTimeZone = response.serverTimeZone;
        this.server.encryptionKeyLength = response.encryptionKeyLength;
        this.server.encryptionKey = response.encryptionKey;
        this.server.oemDomainName = response.oemDomainName;
    }

    public String toString() {
        String ret = "SmbTransport[address=" + this.address;
        ret = this.socket == null ? ret + ",port=,localAddr=,localPort=]" : ret + ",port=" + this.socket.getPort() + ",localAddr=" + this.socket.getLocalAddress() + ",localPort=" + this.socket.getLocalPort() + "]";
        return ret;
    }

    static int aquireMid() throws SmbException {
        try {
            return mpxCtrl.aquireMid();
        }
        catch (InterruptedException ie) {
            throw new SmbException(32, 5002, ie.getMessage());
        }
    }

    static void releaseMid(int mid) {
        mpxCtrl.releaseMid(mid);
    }

    static class MpxControl {
        MpxListNode first = null;
        MpxListNode last = null;
        int nextMid = 0;
        int mpxCount = 0;
        int maxMpxCount = 1;

        MpxControl() {
        }

        synchronized void clear() {
            this.nextMid = 0;
            this.mpxCount = 0;
            this.maxMpxCount = 1;
            this.last = null;
            this.first = null;
        }

        synchronized int aquireMid() throws InterruptedException {
            while (this.mpxCount >= this.maxMpxCount) {
                this.wait();
            }
            if (++this.nextMid % 65535 == 0) {
                this.nextMid = 1;
            }
            this.add(this.nextMid);
            ++this.mpxCount;
            return this.nextMid;
        }

        synchronized void releaseMid(int i) {
            this.remove(i);
            --this.mpxCount;
            this.notify();
        }

        synchronized boolean contains(int i) {
            MpxListNode tmp = this.first;
            while (tmp != null) {
                if (tmp.i == i) {
                    return true;
                }
                tmp = tmp.next;
            }
            return false;
        }

        synchronized void add(int i) {
            if (this.contains(i)) {
                return;
            }
            if (this.first == null) {
                this.first = this.last = new MpxListNode(i);
            } else {
                this.last = this.last.next = new MpxListNode(i);
            }
        }

        synchronized void remove(int i) {
            MpxListNode prev;
            if (this.first == null) {
                return;
            }
            if (this.first == this.last && this.first.i == i) {
                this.last = null;
                this.first = null;
                return;
            }
            MpxListNode tmp = prev = this.first;
            while (tmp != null) {
                if (tmp.i == i) {
                    if (tmp == this.first) {
                        this.first = this.first.next;
                    } else if (tmp == this.last) {
                        this.last = prev;
                        this.last.next = null;
                    } else {
                        prev.next = tmp.next;
                    }
                    return;
                }
                prev = tmp;
                tmp = tmp.next;
            }
        }

        class MpxListNode {
            int i;
            MpxListNode next;

            MpxListNode(int id) {
                this.i = id;
                this.next = null;
            }
        }
    }

    class ServerProperties {
        String tconHostName;
        byte flags;
        int flags2;
        int maxMpxCount;
        int maxBufferSize;
        int sessionKey;
        int capabilities;
        String oemDomainName;
        String primaryDomain;
        String nativeOs;
        String nativeLanMan;
        int securityMode;
        int security;
        boolean encryptedPasswords;
        boolean signaturesEnabled;
        boolean signaturesRequired;
        int maxNumberVcs;
        int maxRawSize;
        long serverTime;
        int serverTimeZone;
        int encryptionKeyLength;
        byte[] encryptionKey;

        ServerProperties() {
        }
    }

    class ClientProperties {
        int maxMpxCount = Config.getInt("jcifs.smb.client.maxMpxCount", 10);
        int maxBufferSize = Config.getInt("jcifs.smb.client.snd_buf_size", 5000);
        int sessionKey = 0;
        int flags2 = Config.getInt("jcifs.smb.client.flags2", 32771);
        int capabilities = Config.getInt("jcifs.smb.client.capabilities", 20);
        String nativeOs = Config.getProperty("jcifs.smb.client.nativeOs", System.getProperty("os.name"));
        String nativeLanMan = Config.getProperty("jcifs.smb.client.nativeLanMan", "jCIFS");
        int vcNumber = 1;

        ClientProperties() {
        }
    }
}

