/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import jcifs.smb.ServerMessageBlock;
import jcifs.smb.SmbComTransaction;

class Trans2SetFileInformation
extends SmbComTransaction {
    static final int SMB_FILE_BASIC_INFO = 257;
    int fid;
    int attributes;
    long createTime;
    long lastWriteTime;

    Trans2SetFileInformation(int fid, int attributes, long createTime, long lastWriteTime) {
        this.fid = fid;
        this.attributes = attributes;
        this.createTime = createTime;
        this.lastWriteTime = lastWriteTime;
        this.command = (byte)50;
        this.subCommand = (byte)8;
        this.maxParameterCount = 6;
        this.maxDataCount = 0;
        this.maxSetupCount = 0;
    }

    int writeSetupWireFormat(byte[] dst, int dstIndex) {
        dst[dstIndex++] = this.subCommand;
        dst[dstIndex++] = 0;
        return 2;
    }

    int writeParametersWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        ServerMessageBlock.writeInt2(this.fid, dst, dstIndex);
        ServerMessageBlock.writeInt2(257L, dst, dstIndex += 2);
        ServerMessageBlock.writeInt2(0L, dst, dstIndex += 2);
        return (dstIndex += 2) - start;
    }

    int writeDataWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        ServerMessageBlock.writeTime(this.createTime, dst, dstIndex);
        ServerMessageBlock.writeInt8(0L, dst, dstIndex += 8);
        ServerMessageBlock.writeTime(this.lastWriteTime, dst, dstIndex += 8);
        ServerMessageBlock.writeInt8(0L, dst, dstIndex += 8);
        ServerMessageBlock.writeInt2(0x80 | this.attributes, dst, dstIndex += 8);
        ServerMessageBlock.writeInt8(0L, dst, dstIndex += 2);
        return (dstIndex += 6) - start;
    }

    int readSetupWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    int readParametersWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    int readDataWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    public String toString() {
        return new String("Trans2SetFileInformation[" + super.toString() + ",fid=" + this.fid + "]");
    }
}

