/*
 * Decompiled with CFR 0.152.
 */
package jcifs.util;

import java.security.MessageDigest;

public class HMACT64
extends MessageDigest
implements Cloneable {
    private static final int BLOCK_LENGTH = 64;
    private static final byte IPAD = 54;
    private static final byte OPAD = 92;
    private MessageDigest md5;
    private byte[] ipad = new byte[64];
    private byte[] opad = new byte[64];

    public HMACT64(byte[] key) {
        super("HMACT64");
        int length = Math.min(key.length, 64);
        int i = 0;
        while (i < length) {
            this.ipad[i] = (byte)(key[i] ^ 0x36);
            this.opad[i] = (byte)(key[i] ^ 0x5C);
            ++i;
        }
        int i2 = length;
        while (i2 < 64) {
            this.ipad[i2] = 54;
            this.opad[i2] = 92;
            ++i2;
        }
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex.getMessage());
        }
        this.engineReset();
    }

    private HMACT64(HMACT64 hmac) throws CloneNotSupportedException {
        super("HMACT64");
        this.ipad = hmac.ipad;
        this.opad = hmac.opad;
        this.md5 = (MessageDigest)hmac.md5.clone();
    }

    public Object clone() {
        try {
            return new HMACT64(this);
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
    }

    protected byte[] engineDigest() {
        byte[] digest = this.md5.digest();
        this.md5.update(this.opad);
        return this.md5.digest(digest);
    }

    protected int engineDigest(byte[] buf, int offset, int len) {
        byte[] digest = this.md5.digest();
        this.md5.update(this.opad);
        this.md5.update(digest);
        try {
            return this.md5.digest(buf, offset, len);
        }
        catch (Exception ex) {
            throw new IllegalStateException();
        }
    }

    protected int engineGetDigestLength() {
        return this.md5.getDigestLength();
    }

    protected void engineReset() {
        this.md5.reset();
        this.md5.update(this.ipad);
    }

    protected void engineUpdate(byte b) {
        this.md5.update(b);
    }

    protected void engineUpdate(byte[] input, int offset, int len) {
        this.md5.update(input, offset, len);
    }
}

