/*
 * Decompiled with CFR 0.152.
 */
package jcifs.util;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Properties;
import jcifs.util.LogWriter;

public class Log {
    private static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] spaceChars = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
    public static final String NL = System.getProperty("line.separator");
    public static final int NL_LENGTH = NL.length();
    public static final int NONE = 0;
    public static final int ALL = -1;
    public static final int EXCEPTIONS = 0x10000001;
    public static final int CRITICAL_EXCEPTIONS = 1;
    public static final int NON_CRITICAL_EXCEPTIONS = 0x10000000;
    public static final int WARNINGS = 2;
    public static final int DEBUGGING = 4;
    public static final int HEX_DUMPS = 8;
    protected static LogWriter out = new LogWriter(System.err);
    protected static int mask = 0x10000001;

    protected Log() {
    }

    public static void setPrintWriter(OutputStream out) {
        Log.out = new LogWriter(out);
    }

    public static void setDateFormat(String format) {
        LogWriter.setDateFormat(format);
    }

    public static void setMask(int mask) {
        Log.mask = mask;
    }

    public static boolean isSet(int mask) {
        return (Log.mask & mask) == mask;
    }

    public static void addMask(int mask) {
        Log.mask |= mask;
    }

    public static void subtractMask(int mask) {
        Log.mask &= ~mask;
    }

    public static void printStackTrace(String desc, Throwable t) {
        if ((1 & mask) != 0) {
            out.printStackTrace(desc, t);
        }
    }

    public static void printStackTrace(int type, String desc, Throwable t) {
        if ((type & mask) != 0) {
            out.printStackTrace(desc, t);
        }
    }

    public static void printHexDump(String desc, byte[] src) {
        Log.printHexDump(desc, src, 0, src.length);
    }

    public static void printHexDump(PrintStream ps, String desc, byte[] src, int srcIndex, int length) {
        ps.println(desc);
        Log.printHexDump(ps, src, srcIndex, length);
    }

    public static void printHexDump(PrintStream ps, byte[] src, int srcIndex, int length) {
        int s = length % 16;
        int r = s == 0 ? length / 16 : length / 16 + 1;
        char[] c = new char[r * (74 + NL_LENGTH)];
        char[] d = new char[16];
        int si = 0;
        int ci = 0;
        do {
            Log.toHexChars(si, c, ci, 5);
            ci += 5;
            c[ci++] = 58;
            do {
                if (si == length) {
                    int n = 16 - s;
                    System.arraycopy(spaceChars, 0, c, ci, n * 3);
                    ci += n * 3;
                    System.arraycopy(spaceChars, 0, d, s, n);
                    break;
                }
                c[ci++] = 32;
                int i = src[srcIndex + si] & 0xFF;
                Log.toHexChars(i, c, ci, 2);
                ci += 2;
                d[si % 16] = i < 0 || Character.isISOControl((char)i) ? 46 : (char)i;
            } while (++si % 16 != 0);
            c[ci++] = 32;
            c[ci++] = 32;
            c[ci++] = 124;
            System.arraycopy(d, 0, c, ci, 16);
            ci += 16;
            c[ci++] = 124;
            NL.getChars(0, NL_LENGTH, c, ci);
            ci += NL_LENGTH;
        } while (si < length);
        ps.println(c);
    }

    public static void printHexDump(String desc, byte[] src, int srcIndex, int length) {
        if ((8 & mask) == 0 || length == 0) {
            return;
        }
        int s = length % 16;
        int r = s == 0 ? length / 16 : length / 16 + 1;
        char[] c = new char[r * (74 + NL_LENGTH)];
        char[] d = new char[16];
        int si = 0;
        int ci = 0;
        do {
            Log.toHexChars(si, c, ci, 5);
            ci += 5;
            c[ci++] = 58;
            do {
                if (si == length) {
                    int n = 16 - s;
                    System.arraycopy(spaceChars, 0, c, ci, n * 3);
                    ci += n * 3;
                    System.arraycopy(spaceChars, 0, d, s, n);
                    break;
                }
                c[ci++] = 32;
                int i = src[srcIndex + si] & 0xFF;
                Log.toHexChars(i, c, ci, 2);
                ci += 2;
                d[si % 16] = i < 0 || Character.isISOControl((char)i) ? 46 : (char)i;
            } while (++si % 16 != 0);
            c[ci++] = 32;
            c[ci++] = 32;
            c[ci++] = 124;
            System.arraycopy(d, 0, c, ci, 16);
            ci += 16;
            c[ci++] = 124;
            NL.getChars(0, NL_LENGTH, c, ci);
            ci += NL_LENGTH;
        } while (si < length);
        out.println(desc, c);
    }

    public static String getHexString(int val, int size) {
        char[] c = new char[size];
        Log.toHexChars(val, c, 0, size);
        return new String(c);
    }

    public static String getHexString(long val, int size) {
        char[] c = new char[size];
        Log.toHexChars(val, c, 0, size);
        return new String(c);
    }

    public static String getHexString(byte[] src, int srcIndex, int size) {
        char[] c = new char[size];
        size = size % 2 == 0 ? size / 2 : size / 2 + 1;
        int i = 0;
        int j = 0;
        while (i < size) {
            c[j++] = hexChars[src[i] >> 4 & 0xF];
            if (j == c.length) break;
            c[j++] = hexChars[src[i] & 0xF];
            ++i;
        }
        return new String(c);
    }

    public static void toHexChars(int val, char[] dst, int dstIndex, int size) {
        while (size > 0) {
            dst[dstIndex + size - 1] = hexChars[val & 0xF];
            if (val != 0) {
                val >>>= 4;
            }
            --size;
        }
    }

    public static void toHexChars(long val, char[] dst, int dstIndex, int size) {
        while (size > 0) {
            dst[dstIndex + size - 1] = hexChars[(int)(val & 0xFL)];
            if (val != 0L) {
                val >>>= 4;
            }
            --size;
        }
    }

    public static void println(int type, String desc, int x) {
        if ((type & mask) != 0) {
            out.println(desc, x);
        }
    }

    public static void println(int type, String desc, char[] x) {
        if ((type & mask) != 0) {
            out.println(desc, x);
        }
    }

    public static void println(int type, String desc, String x) {
        if ((type & mask) != 0) {
            out.println(desc, x);
        }
    }

    public static void println(int type, String desc, Object x) {
        if ((type & mask) != 0) {
            out.println(desc, x);
        }
    }

    public static void printProperties(int type, String desc, Properties p) {
        if ((type & mask) != 0) {
            out.printProperties(desc, p);
        }
    }
}

