/*
 * Decompiled with CFR 0.152.
 */
package jcifs.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;

public class LogWriter {
    private Writer out;
    private OutputStream raw;
    private PrintWriter eout;
    private boolean trouble = false;
    private String lineSeparator;
    public Object lock;
    static String dateString;
    static GregorianCalendar cal;
    static SimpleDateFormat sdf;

    public LogWriter(OutputStream out) {
        this.out = new OutputStreamWriter(out);
        this.raw = out;
        this.lock = this;
        this.eout = new PrintWriter(out);
        this.lineSeparator = System.getProperty("line.separator");
    }

    public static void setDateFormat(String format) {
        sdf = new SimpleDateFormat(format);
        sdf.setCalendar(cal);
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.out == null) {
                    return;
                }
                this.out.close();
                this.out = null;
            }
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkError() {
        block5: {
            if (this.out == null) break block5;
            try {
                Object object = this.lock;
                synchronized (object) {
                    this.ensureOpen();
                    this.out.flush();
                }
            }
            catch (IOException x) {
                this.trouble = true;
            }
        }
        return this.trouble;
    }

    public void setError() {
        this.trouble = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(String desc, Throwable t) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                this.out.write(sdf.format(new Date()));
                this.out.write(" - ");
                this.out.write(desc);
                this.out.write(this.lineSeparator);
                this.eout.flush();
                this.out.flush();
                t.printStackTrace(this.eout);
                this.eout.flush();
                this.out.flush();
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException ioe) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String desc, int i) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                this.out.write(sdf.format(new Date()));
                this.out.write(" - ");
                this.out.write(desc);
                this.out.write(this.lineSeparator);
                this.out.write(Integer.toString(i));
                this.out.write(this.lineSeparator);
                this.out.flush();
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException ioe) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String desc, char[] c) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                this.out.write(sdf.format(new Date()));
                this.out.write(" - ");
                this.out.write(desc);
                this.out.write(this.lineSeparator);
                this.out.write(c);
                this.out.write(this.lineSeparator);
                this.out.flush();
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException ioe) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String desc, String s) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                this.out.write(sdf.format(new Date()));
                this.out.write(" - ");
                this.out.write(desc);
                this.out.write(this.lineSeparator);
                if (s != null) {
                    this.out.write(s);
                    this.out.write(this.lineSeparator);
                }
                this.out.flush();
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException ioe) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String desc, Object o) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                this.out.write(sdf.format(new Date()));
                this.out.write(" - ");
                this.out.write(desc);
                this.out.write(this.lineSeparator);
                if (o != null) {
                    this.out.write(String.valueOf(o));
                    this.out.write(this.lineSeparator);
                }
                this.out.flush();
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException ioe) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printProperties(String desc, Properties p) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                p.save(this.raw, desc);
                this.out.write(this.lineSeparator);
                this.out.flush();
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException ioe) {
            this.trouble = true;
        }
    }

    static {
        cal = new GregorianCalendar();
        LogWriter.setDateFormat("MMM d HH:mm:ss.SSS");
    }
}

