/*
 * Decompiled with CFR 0.152.
 */
package com.marevol.utils.faces.model;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.faces.FacesException;
import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.type.Type;

public class HibernateDataModel
extends DataModel {
    private static final Log log = LogFactory.getLog((Class)HibernateDataModel.class);
    private int _currentIndex = -1;
    private int _rowCount = -1;
    private Session session;
    private ScrollableResults _scrollableResults = null;
    static /* synthetic */ Class class$com$marevol$utils$faces$model$HibernateDataModel$WrapScrollableResultsMap;

    public HibernateDataModel() {
    }

    public HibernateDataModel(Session session, String hSql, Object[] params) {
        this.session = session;
        if (hSql == null) {
            throw new IllegalArgumentException("HSQL statement is null.");
        }
        Query query = session.createQuery(hSql);
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                query.setParameter(i, params[i]);
            }
        }
        this._scrollableResults = query.scroll();
        this.setWrappedData(this._scrollableResults);
        this.guessRowCount(hSql, params);
    }

    private void guessRowCount(String hSql, Object[] params) {
        int index = hSql.toLowerCase().indexOf("from");
        if (index >= 0) {
            Query q = this.session.createQuery(this.createHsqlForCount(hSql));
            for (int i = 0; i < params.length; ++i) {
                q.setParameter(i, params[i]);
            }
            Integer count = (Integer)q.uniqueResult();
            if (count != null) {
                this.setRowCount(count);
            } else {
                this.setRowCount(0);
            }
        } else {
            this.setRowCount(0);
        }
    }

    public HibernateDataModel(Session session, String hSql, Object[] params, Type[] types) {
        this.session = session;
        if (hSql == null) {
            throw new IllegalArgumentException("HSQL statement is null.");
        }
        Query query = session.createQuery(hSql);
        if (params == null && types != null || params != null && types == null) {
            throw new IllegalArgumentException("Wrong parameters or types.");
        }
        if (params != null && types != null) {
            if (params.length != types.length) {
                throw new IllegalArgumentException("The number of parameter is not equal to the number of type.");
            }
            for (int i = 0; i < params.length; ++i) {
                query.setParameter(i, params[i], types[i]);
            }
        }
        this._scrollableResults = query.scroll();
        this.setWrappedData(this._scrollableResults);
        this.guessRowCount(hSql, params, types);
    }

    private void guessRowCount(String hSql, Object[] params, Type[] types) {
        int index = hSql.toLowerCase().indexOf("from");
        if (index >= 0) {
            Query q = this.session.createQuery(this.createHsqlForCount(hSql));
            for (int i = 0; i < params.length; ++i) {
                q.setParameter(i, params[i], types[i]);
            }
            Integer count = (Integer)q.uniqueResult();
            if (count != null) {
                this.setRowCount(count);
            } else {
                this.setRowCount(0);
            }
        } else {
            this.setRowCount(0);
        }
    }

    private String createHsqlForCount(String hSql) {
        String sql = "select count(*) " + hSql.substring(hSql.toLowerCase().indexOf("from"));
        if (log.isDebugEnabled()) {
            log.debug((Object)("createHsqlForCount(" + hSql + ")=" + sql.replaceAll("order by(\\s+[^ ]*(\\s+(asc)|(desc))?,?)+", "")));
        }
        return sql.replaceAll("order by(\\s*[^ ]+(\\s+(asc)|(desc))?,?)+", "");
    }

    public void setRowCount(int count) {
        this._rowCount = count;
    }

    public int getRowCount() {
        return this._rowCount;
    }

    public Object getRowData() {
        if (this._scrollableResults == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"getRowData() - _query is null.");
            }
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new IllegalArgumentException("the requested row is not available in the ScrollableResults - you have scrolled beyond the end.");
        }
        try {
            return new WrapScrollableResultsMap(String.CASE_INSENSITIVE_ORDER);
        }
        catch (HibernateException e) {
            log.error((Object)"getRowData()", (Throwable)e);
            throw new FacesException((Throwable)e);
        }
    }

    public int getRowIndex() {
        return this._currentIndex;
    }

    public Object getWrappedData() {
        return this._scrollableResults;
    }

    public boolean isRowAvailable() {
        if (this._scrollableResults == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"isRowAvailable() - _query is null.");
            }
            return false;
        }
        if (this._currentIndex < 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"isRowAvailable() - _currentIndex < 0");
            }
            return false;
        }
        try {
            return this._scrollableResults.setRowNumber(this._currentIndex);
        }
        catch (HibernateException e) {
            log.error((Object)"isRowAvailable()", (Throwable)e);
            throw new FacesException((Throwable)e);
        }
    }

    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException("you cannot set the rowIndex to anything less than 0");
        }
        int old = this._currentIndex;
        this._currentIndex = rowIndex;
        if (this._scrollableResults == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"setRowIndex(int) - _query is null.");
            }
            return;
        }
        DataModelListener[] listeners = this.getDataModelListeners();
        if (old != this._currentIndex && listeners != null) {
            Object rowData = null;
            if (this.isRowAvailable()) {
                rowData = this.getRowData();
            }
            DataModelEvent event = new DataModelEvent((DataModel)this, this._currentIndex, rowData);
            int n = listeners.length;
            for (int i = 0; i < n; ++i) {
                if (listeners[i] == null) continue;
                listeners[i].rowSelected(event);
            }
        }
    }

    public void setWrappedData(Object data) {
        if (data == null) {
            this._scrollableResults = null;
            this.setRowIndex(-1);
        } else {
            this._scrollableResults = (ScrollableResults)data;
            this._currentIndex = -1;
            this.setRowIndex(0);
        }
    }

    private static class WrapScrollableResultsValuesIterator
    implements Iterator {
        private WrapScrollableResultsMap _wrapMap;
        private Iterator _keyIterator;

        public WrapScrollableResultsValuesIterator(WrapScrollableResultsMap wrapMap) {
            this._wrapMap = wrapMap;
            this._keyIterator = this._wrapMap.keySet().iterator();
        }

        public boolean hasNext() {
            return this._keyIterator.hasNext();
        }

        public Object next() {
            return this._wrapMap.get(this._keyIterator.next());
        }

        public void remove() {
            throw new UnsupportedOperationException("it is not allowed to remove from this map");
        }
    }

    private static class WrapScrollableResultsValues
    extends AbstractCollection {
        private WrapScrollableResultsMap _wrapMap;

        public WrapScrollableResultsValues(WrapScrollableResultsMap wrapMap) {
            this._wrapMap = wrapMap;
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException("it is not allowed to add to this collection");
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException("it is not allowed to add to this collection");
        }

        public void clear() {
            throw new UnsupportedOperationException("it is not allowed to remove from this collection");
        }

        public boolean contains(Object value) {
            return this._wrapMap.containsValue(value);
        }

        public Iterator iterator() {
            return new WrapScrollableResultsValuesIterator(this._wrapMap);
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException("it is not allowed to remove from this collection");
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException("it is not allowed to remove from this collection");
        }

        public int size() {
            return this._wrapMap.size();
        }
    }

    private static class WrapScrollableResultsKeysIterator
    implements Iterator {
        private Iterator _keyIterator = null;

        public WrapScrollableResultsKeysIterator(WrapScrollableResultsMap map) {
            this._keyIterator = map.getUnderlyingKeys();
        }

        public boolean hasNext() {
            return this._keyIterator.hasNext();
        }

        public Object next() {
            return this._keyIterator.next();
        }

        public void remove() {
            throw new UnsupportedOperationException("it is not allowed to remove from this iterator");
        }
    }

    private static class WrapScrollableResultsKeys
    extends AbstractSet {
        private WrapScrollableResultsMap _wrapMap;

        public WrapScrollableResultsKeys(WrapScrollableResultsMap wrapMap) {
            this._wrapMap = wrapMap;
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException("It is not allowed to add to this set");
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException("It is not allowed to add to this set");
        }

        public void clear() {
            throw new UnsupportedOperationException("It is not allowed to remove from this set");
        }

        public boolean contains(Object obj) {
            return this._wrapMap.containsKey(obj);
        }

        public boolean isEmpty() {
            return this._wrapMap.isEmpty();
        }

        public Iterator iterator() {
            return new WrapScrollableResultsKeysIterator(this._wrapMap);
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException("It is not allowed to remove from this set");
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException("It is not allowed to remove from this set");
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException("It is not allowed to remove from this set");
        }

        public int size() {
            return this._wrapMap.size();
        }
    }

    private static class WrapScrollableResultsEntry
    implements Map.Entry {
        private WrapScrollableResultsMap _wrapMap;
        private Object _entryKey;

        public WrapScrollableResultsEntry(WrapScrollableResultsMap wrapMap, Object entryKey) {
            this._wrapMap = wrapMap;
            this._entryKey = entryKey;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry cmpEntry = (Map.Entry)o;
            if (this._entryKey == null ? cmpEntry.getKey() != null : !this._entryKey.equals(cmpEntry.getKey())) {
                return false;
            }
            Object value = this._wrapMap.get(this._entryKey);
            Object cmpValue = cmpEntry.getValue();
            return value == null ? cmpValue != null : value.equals(cmpValue);
        }

        public Object getKey() {
            return this._entryKey;
        }

        public Object getValue() {
            return this._wrapMap.get(this._entryKey);
        }

        public int hashCode() {
            int result = this._entryKey != null ? this._entryKey.hashCode() : 0;
            result = 29 * result + (this._wrapMap.get(this._entryKey) != null ? this._wrapMap.get(this._entryKey).hashCode() : 0);
            return result;
        }

        public Object setValue(Object value) {
            Object oldValue = this._wrapMap.get(this._entryKey);
            this._wrapMap.put(this._entryKey, value);
            return oldValue;
        }
    }

    private static class WrapScrollableResultsEntriesIterator
    implements Iterator {
        private WrapScrollableResultsMap _wrapMap = null;
        private Iterator _keyIterator = null;

        public WrapScrollableResultsEntriesIterator(WrapScrollableResultsMap wrapMap) {
            this._wrapMap = wrapMap;
            this._keyIterator = this._wrapMap.keySet().iterator();
        }

        public boolean hasNext() {
            return this._keyIterator.hasNext();
        }

        public Object next() {
            return new WrapScrollableResultsEntry(this._wrapMap, this._keyIterator.next());
        }

        public void remove() {
            throw new UnsupportedOperationException("It is not allowed to remove from this iterator");
        }
    }

    private static class WrapScrollableResultsEntries
    extends AbstractSet {
        private WrapScrollableResultsMap _wrapMap;

        public WrapScrollableResultsEntries(WrapScrollableResultsMap wrapMap) {
            this._wrapMap = wrapMap;
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException("it is not allowed to add to this set");
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException("it is not allowed to add to this set");
        }

        public void clear() {
            throw new UnsupportedOperationException("it is not allowed to remove from this set");
        }

        public boolean contains(Object o) {
            if (o == null) {
                throw new NullPointerException();
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (!this._wrapMap.containsKey(key)) {
                return false;
            }
            Object value = e.getValue();
            Object cmpValue = this._wrapMap.get(key);
            return value == null ? cmpValue == null : value.equals(cmpValue);
        }

        public boolean isEmpty() {
            return this._wrapMap.isEmpty();
        }

        public Iterator iterator() {
            return new WrapScrollableResultsEntriesIterator(this._wrapMap);
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException("it is not allowed to remove from this set");
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException("it is not allowed to remove from this set");
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException("it is not allowed to remove from this set");
        }

        public int size() {
            return this._wrapMap.size();
        }
    }

    private class WrapScrollableResultsMap
    extends TreeMap {
        private static final long serialVersionUID = 2774501371528418953L;
        private final Log log;
        private int _currentIndex;

        public WrapScrollableResultsMap(Comparator comparator) {
            super(comparator);
            this.log = LogFactory.getLog((Class)(class$com$marevol$utils$faces$model$HibernateDataModel$WrapScrollableResultsMap == null ? (class$com$marevol$utils$faces$model$HibernateDataModel$WrapScrollableResultsMap = HibernateDataModel.class$("com.marevol.utils.faces.model.HibernateDataModel$WrapScrollableResultsMap")) : class$com$marevol$utils$faces$model$HibernateDataModel$WrapScrollableResultsMap));
            this._currentIndex = HibernateDataModel.this._currentIndex;
            if (HibernateDataModel.this._scrollableResults.setRowNumber(this._currentIndex)) {
                Object[] objects = HibernateDataModel.this._scrollableResults.get();
                for (int i = 0; i < objects.length; ++i) {
                    super.put(Integer.toString(i), Integer.toString(i));
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"WrapScrollableResultsMap(Comparator) -  : The current row is not available.");
            }
        }

        public void clear() {
            throw new UnsupportedOperationException("It is not allowed to remove from this map");
        }

        public boolean containsValue(Object value) {
            Set keys = this.keySet();
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                Object object = this.get(iterator.next());
                if (object == null) {
                    return value == null;
                }
                if (!object.equals(value)) continue;
                return true;
            }
            return false;
        }

        public Set entrySet() {
            return new WrapScrollableResultsEntries(this);
        }

        public Object get(Object key) {
            if (!this.containsKey(key)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("get(Object) - get(" + key + ") is null."));
                }
                return null;
            }
            return this.basicGet(key);
        }

        private Object basicGet(Object key) {
            HibernateDataModel.this._scrollableResults.setRowNumber(this._currentIndex);
            Integer i = new Integer((String)this.getUnderlyingKey(key));
            if (i != null) {
                return HibernateDataModel.this._scrollableResults.get(i.intValue());
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("basicGet(Object) - Cannot find the target column : i=" + i));
            }
            return null;
        }

        public Set keySet() {
            return new WrapScrollableResultsKeys(this);
        }

        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException("It is not allowed to update entries from this set.");
        }

        public void putAll(Map map) {
            Iterator i = map.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                this.put(entry.getKey(), entry.getValue());
            }
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException("It is not allowed to remove entries from this set.");
        }

        public Collection values() {
            return new WrapScrollableResultsValues(this);
        }

        Object getUnderlyingKey(Object key) {
            return super.get(key);
        }

        Iterator getUnderlyingKeys() {
            return super.keySet().iterator();
        }
    }
}

