/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.internal.FacesMessageUtil;
import javax.faces.internal.UIComponentUtil;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.seasar.framework.util.AssertionUtil;

public class DoubleRangeValidator
implements Validator,
StateHolder {
    public static final String VALIDATOR_ID = "javax.faces.DoubleRange";
    public static final String MAXIMUM_MESSAGE_ID = "javax.faces.validator.DoubleRangeValidator.MAXIMUM";
    public static final String MINIMUM_MESSAGE_ID = "javax.faces.validator.DoubleRangeValidator.MINIMUM";
    public static final String TYPE_MESSAGE_ID = "javax.faces.validator.DoubleRangeValidator.TYPE";
    private Double maximum = null;
    private Double minimum = null;
    private boolean transientValue = false;

    public DoubleRangeValidator() {
    }

    public DoubleRangeValidator(double maximum) {
        this.maximum = new Double(maximum);
    }

    public DoubleRangeValidator(double maximum, double minimum) {
        this.maximum = new Double(maximum);
        this.minimum = new Double(minimum);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DoubleRangeValidator)) {
            return false;
        }
        DoubleRangeValidator v = (DoubleRangeValidator)obj;
        if (this.maximum != null && v.maximum == null && this.maximum == null && v.maximum != null) {
            return false;
        }
        if (this.minimum != null && v.minimum == null && this.minimum == null && v.minimum != null) {
            return false;
        }
        return this.getMaximum() == v.getMaximum() && this.getMinimum() == v.getMinimum();
    }

    public int hashCode() {
        Double max = this.maximum != null ? this.maximum : new Double(1.0);
        Double min = this.minimum != null ? this.minimum : new Double(1.0);
        return max.hashCode() * min.hashCode() * 17;
    }

    public double getMaximum() {
        return this.maximum != null ? this.maximum : Double.MAX_VALUE;
    }

    public double getMinimum() {
        return this.minimum != null ? this.minimum : Double.MIN_VALUE;
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] obj = (Object[])state;
        this.maximum = (Double)obj[0];
        this.minimum = (Double)obj[1];
    }

    public Object saveState(FacesContext context) {
        Object[] obj = new Object[]{this.maximum, this.minimum};
        return obj;
    }

    public void setMaximum(double maximum) {
        this.maximum = new Double(maximum);
    }

    public void setMinimum(double minimum) {
        this.minimum = new Double(minimum);
    }

    public void setTransient(boolean transientValue) {
        this.transientValue = transientValue;
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"component", (Object)component);
        if (value == null) {
            return;
        }
        try {
            double maxValue;
            double doubleValue = DoubleRangeValidator.parseDoubleValue(value);
            if (this.maximum != null && this.minimum != null) {
                double minValue = this.minimum;
                double maxValue2 = this.maximum;
                if (doubleValue < minValue || doubleValue > maxValue2) {
                    Object[] args = new Object[]{this.minimum, this.maximum, UIComponentUtil.getLabel(component)};
                    throw new ValidatorException(FacesMessageUtil.getMessage(context, this.getNotInRangeMessageId(), args));
                }
            } else if (this.minimum != null) {
                double minValue = this.minimum;
                if (doubleValue < minValue) {
                    Object[] args = new Object[]{this.minimum, UIComponentUtil.getLabel(component)};
                    throw new ValidatorException(FacesMessageUtil.getMessage(context, this.getMinimumMessageId(), args));
                }
            } else if (this.maximum != null && doubleValue > (maxValue = this.maximum.doubleValue())) {
                Object[] args = new Object[]{this.maximum, UIComponentUtil.getLabel(component)};
                throw new ValidatorException(FacesMessageUtil.getMessage(context, this.getMaximumMessageId(), args));
            }
        }
        catch (NumberFormatException e) {
            Object[] args = new Object[]{UIComponentUtil.getLabel(component)};
            throw new ValidatorException(FacesMessageUtil.getMessage(context, this.getTypeMessageId(), args));
        }
    }

    protected String getMaximumMessageId() {
        return MAXIMUM_MESSAGE_ID;
    }

    protected String getMinimumMessageId() {
        return MINIMUM_MESSAGE_ID;
    }

    protected String getNotInRangeMessageId() {
        return "javax.faces.validator.NOT_IN_RANGE";
    }

    protected String getTypeMessageId() {
        return TYPE_MESSAGE_ID;
    }

    private static double parseDoubleValue(Object obj) throws NumberFormatException {
        double value = obj instanceof Number ? ((Number)obj).doubleValue() : Double.parseDouble(obj.toString());
        return value;
    }
}

