/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.application;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.jstl.core.Config;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.config.webapp.element.ServletMappingElement;
import org.seasar.teeda.core.config.webapp.element.WebappConfig;
import org.seasar.teeda.core.portlet.FacesPortlet;
import org.seasar.teeda.core.util.PortletUtil;
import org.seasar.teeda.core.util.ServletExternalContextUtil;
import org.seasar.teeda.core.util.StateManagerUtil;
import org.seasar.teeda.core.util.WebappConfigUtil;

public class ViewHandlerImpl
extends ViewHandler {
    public Locale calculateLocale(FacesContext context) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        Locale supportedLocale = this.getLocaleFromSupportedLocales(context);
        if (supportedLocale != null) {
            return supportedLocale;
        }
        Locale defaultLocale = this.getLocaleFromDefaultLocale(context);
        if (defaultLocale != null) {
            return defaultLocale;
        }
        return Locale.getDefault();
    }

    protected Locale getLocaleFromSupportedLocales(FacesContext context) {
        Application app = context.getApplication();
        Iterator locales = context.getExternalContext().getRequestLocales();
        while (locales.hasNext()) {
            Locale locale = (Locale)locales.next();
            Iterator supportedLocales = app.getSupportedLocales();
            while (supportedLocales.hasNext()) {
                Locale supportedLocale = (Locale)supportedLocales.next();
                if (!this.isMatchLocale(locale, supportedLocale)) continue;
                return supportedLocale;
            }
        }
        return null;
    }

    protected Locale getLocaleFromDefaultLocale(FacesContext context) {
        Locale defaultLocale = context.getApplication().getDefaultLocale();
        Iterator locales = context.getExternalContext().getRequestLocales();
        while (locales.hasNext()) {
            Locale reqLocale = (Locale)locales.next();
            if (!this.isMatchLocale(reqLocale, defaultLocale)) continue;
            return defaultLocale;
        }
        return null;
    }

    protected boolean isMatchLocale(Locale reqLocale, Locale jsfLocale) {
        if (reqLocale == null && jsfLocale == null) {
            return true;
        }
        if (reqLocale == null || jsfLocale == null) {
            return false;
        }
        if (reqLocale.equals(jsfLocale)) {
            return true;
        }
        return reqLocale.getLanguage().equals(jsfLocale.getLanguage()) && StringUtil.isEmpty((String)jsfLocale.getCountry());
    }

    public String calculateRenderKitId(FacesContext context) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        String renderKitId = context.getApplication().getDefaultRenderKitId();
        if (renderKitId == null) {
            renderKitId = "HTML_BASIC";
        }
        return renderKitId;
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        Locale locale = null;
        String renderKitId = null;
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot != null) {
            locale = viewRoot.getLocale();
            renderKitId = viewRoot.getRenderKitId();
        } else {
            locale = this.calculateLocale(context);
            renderKitId = this.calculateRenderKitId(context);
        }
        viewRoot = (UIViewRoot)context.getApplication().createComponent("javax.faces.ViewRoot");
        viewRoot.setViewId(viewId);
        viewRoot.setLocale(locale);
        viewRoot.setRenderKitId(renderKitId);
        return viewRoot;
    }

    public String getActionURL(FacesContext context, String viewId) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"viewId", (Object)viewId);
        if (PortletUtil.isRender(context)) {
            RenderResponse response = (RenderResponse)context.getExternalContext().getResponse();
            PortletURL url = response.createActionURL();
            url.setParameter(FacesPortlet.VIEW_ID, viewId);
            return url.toString();
        }
        String path = this.getViewIdPath(context, viewId);
        if (path != null && path.startsWith("/")) {
            return context.getExternalContext().getRequestContextPath() + path;
        }
        return path;
    }

    public String getResourceURL(FacesContext context, String path) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"path", (Object)path);
        if (path.startsWith("/")) {
            return context.getExternalContext().getRequestContextPath() + path;
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderView(FacesContext context, UIViewRoot viewRoot) throws IOException, FacesException {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"viewRoot", (Object)viewRoot);
        ExternalContext externalContext = context.getExternalContext();
        this.ensureResponseLocaleSet(externalContext, viewRoot);
        this.ensureRequestLocaleSet(externalContext, viewRoot);
        try {
            String viewId = this.convertViewIdIfNeed(context);
            context.getViewRoot().setViewId(viewId);
            externalContext.dispatch(viewId);
        }
        finally {
            this.storeResponseCharacterEncoding(externalContext);
        }
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        Application app = context.getApplication();
        String renderKitId = this.calculateRenderKitId(context);
        StateManager stateManager = app.getStateManager();
        return stateManager.restoreView(context, viewId, renderKitId);
    }

    public void writeState(FacesContext context) throws IOException {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        if (StateManagerUtil.isSavingStateInClient(context)) {
            context.getResponseWriter().writeText("org.seasar.teeda.core.STATE_MARKER", null);
        }
    }

    protected String getViewIdPath(FacesContext context, String viewId) {
        if (!viewId.startsWith("/")) {
            throw new IllegalArgumentException();
        }
        if (PortletUtil.isPortlet(context)) {
            return viewId;
        }
        WebappConfig webappConfig = this.getWebappConfig(context);
        String urlPattern = this.getUrlPattern(webappConfig, context);
        if (urlPattern != null) {
            if (urlPattern.startsWith("*.")) {
                if (viewId.endsWith(urlPattern = urlPattern.substring(1, urlPattern.length()))) {
                    return viewId;
                }
                int index = viewId.lastIndexOf(".");
                if (index >= 0) {
                    return viewId.substring(0, index) + urlPattern;
                }
                return viewId + urlPattern;
            }
            if (urlPattern.endsWith("/*")) {
                urlPattern = urlPattern.substring(0, urlPattern.length() - 2);
            }
            return urlPattern + viewId;
        }
        return viewId;
    }

    protected String getUrlPattern(WebappConfig webappConfig, FacesContext context) {
        String servletPath = context.getExternalContext().getRequestServletPath();
        String pathInfo = context.getExternalContext().getRequestPathInfo();
        List servletMappings = webappConfig.getServletMappingElement();
        Iterator itr = servletMappings.iterator();
        while (itr.hasNext()) {
            String extension;
            ServletMappingElement servletMapping = (ServletMappingElement)itr.next();
            String urlPattern = servletMapping.getUrlPattern();
            if ((!ViewHandlerImpl.isExtensionMapping(urlPattern) || pathInfo != null) && (ViewHandlerImpl.isExtensionMapping(urlPattern) || pathInfo == null) || !(ViewHandlerImpl.isExtensionMapping(urlPattern) ? servletPath.endsWith(extension = urlPattern.substring(1, urlPattern.length())) || servletPath.equals(urlPattern) : servletPath.equals(urlPattern = urlPattern.substring(0, urlPattern.length() - 2)))) continue;
            return urlPattern;
        }
        return null;
    }

    protected String convertViewIdIfNeed(FacesContext context) {
        WebappConfig webappConfig = this.getWebappConfig(context);
        ExternalContext externalContext = context.getExternalContext();
        String urlPattern = this.getUrlPattern(webappConfig, context);
        String viewId = context.getViewRoot().getViewId();
        if (PortletUtil.isPortlet(context)) {
            return viewId;
        }
        if (urlPattern != null && ViewHandlerImpl.isExtensionMapping(urlPattern)) {
            String suffix;
            String defaultSuffix = externalContext.getInitParameter("javax.faces.DEFAULT_SUFFIX");
            String string = suffix = defaultSuffix != null ? defaultSuffix : ".jsp";
            if (!viewId.endsWith(suffix)) {
                int dot = viewId.lastIndexOf(46);
                viewId = dot == -1 ? viewId + suffix : viewId.substring(0, dot) + suffix;
            }
        }
        return viewId;
    }

    protected WebappConfig getWebappConfig(FacesContext context) {
        return WebappConfigUtil.getWebappConfig(context);
    }

    protected void ensureResponseLocaleSet(ExternalContext externalContext, UIViewRoot viewRoot) {
        if (externalContext.getResponse() instanceof ServletResponse) {
            ServletResponse res = (ServletResponse)externalContext.getResponse();
            res.setLocale(viewRoot.getLocale());
        }
    }

    protected void ensureRequestLocaleSet(ExternalContext externalContext, UIViewRoot viewRoot) {
        if (externalContext.getRequest() instanceof ServletRequest) {
            Config.set((ServletRequest)((ServletRequest)externalContext.getRequest()), (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)viewRoot.getLocale());
        }
    }

    protected void storeResponseCharacterEncoding(ExternalContext externalContext) {
        ServletResponse res;
        if (externalContext.getResponse() instanceof ServletResponse && ServletExternalContextUtil.isHttpServletResponse(res = (ServletResponse)externalContext.getResponse())) {
            HttpServletResponse httpRes = ServletExternalContextUtil.getResponse(externalContext);
            HttpSession session = (HttpSession)externalContext.getSession(false);
            if (session != null) {
                session.setAttribute("javax.faces.request.charset", (Object)httpRes.getCharacterEncoding());
            }
        }
    }

    private static boolean isExtensionMapping(String urlPattern) {
        return urlPattern != null && urlPattern.startsWith("*.");
    }
}

