/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.application.impl;

import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.application.ComponentLookupStrategy;
import org.seasar.teeda.core.util.DIContainerUtil;

public class DefaultComponentLookupStrategy
implements ComponentLookupStrategy {
    private String namespace = "teeda";

    public Object getComponentByName(String componentName) {
        if (StringUtil.isEmpty((String)componentName)) {
            throw new IllegalArgumentException();
        }
        Object component = DIContainerUtil.getComponentNoException(componentName);
        if (component != null) {
            return component;
        }
        return this.getComponentByDefaultNamespace(componentName);
    }

    public Object getComponentByClass(Class componentClazz) {
        if (componentClazz == null) {
            throw new IllegalArgumentException();
        }
        return DIContainerUtil.getComponentNoException(componentClazz);
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    private Object getComponentByDefaultNamespace(String componentName) {
        return DIContainerUtil.getComponentNoException(this.getNamespace() + "." + componentName);
    }
}

