/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.config.faces.assembler.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.log.Logger;
import org.seasar.teeda.core.JsfConstants;
import org.seasar.teeda.core.config.faces.assembler.RenderKitAssembler;
import org.seasar.teeda.core.config.faces.element.RenderKitElement;
import org.seasar.teeda.core.config.faces.element.RendererElement;
import org.seasar.teeda.core.util.ClassUtil;
import org.seasar.teeda.core.util.DIContainerUtil;
import org.seasar.teeda.core.util.FactoryFinderUtil;
import org.seasar.teeda.core.util.IteratorUtil;

public class DefaultRenderKitAssembler
extends RenderKitAssembler {
    private static Logger logger_ = Logger.getLogger((Class)DefaultRenderKitAssembler.class);
    private List renderLists_;
    static /* synthetic */ Class class$org$seasar$teeda$core$config$faces$element$RendererElement;

    public DefaultRenderKitAssembler(Map renderKits) {
        super(renderKits);
    }

    protected void setupBeforeAssemble() {
        this.renderLists_ = new ArrayList();
        Iterator itr = IteratorUtil.getEntryIterator(this.getRenderKits());
        while (itr.hasNext()) {
            Map.Entry entry = (Map.Entry)itr.next();
            RenderKitElement renderKitElement = (RenderKitElement)entry.getValue();
            String renderKitId = this.getRenderKitId(renderKitElement);
            String className = this.getRenderKitClassName(renderKitElement);
            List renderers = renderKitElement.getRendererElements();
            this.isAllSuitableJsfElement(renderers, class$org$seasar$teeda$core$config$faces$element$RendererElement == null ? DefaultRenderKitAssembler.class$("org.seasar.teeda.core.config.faces.element.RendererElement") : class$org$seasar$teeda$core$config$faces$element$RendererElement);
            RenderKitBean bean = new RenderKitBean(renderKitId, className, renderers);
            this.renderLists_.add(bean);
        }
    }

    private String getRenderKitId(RenderKitElement renderKitElement) {
        String renderKitId = renderKitElement.getRenderKitId();
        if (renderKitId != null) {
            return renderKitId;
        }
        return "HTML_BASIC";
    }

    public void assemble() {
        RenderKitFactory renderKitFactory = FactoryFinderUtil.getRenderKitFactory();
        Iterator itr = IteratorUtil.getIterator(this.renderLists_);
        while (itr.hasNext()) {
            RenderKitBean bean = (RenderKitBean)itr.next();
            String renderKitId = bean.getRenderKitId();
            RenderKit renderKit = this.createRenderKit(bean.getClassName());
            RendererElement rendererElement = null;
            while ((rendererElement = bean.getRendererElement()) != null) {
                String rendererClass = rendererElement.getRendererClass();
                Renderer renderer = this.createRenderer(rendererClass);
                renderKit.addRenderer(rendererElement.getComponentFamily(), rendererElement.getRendererType(), renderer);
            }
            renderKitFactory.addRenderKit(renderKitId, renderKit);
        }
    }

    protected String getRenderKitClassName(RenderKitElement renderKitElement) {
        String className = renderKitElement.getRenderKitClass();
        if (className == null) {
            className = JsfConstants.DEFAULT_RENDERKIT_CLASS;
        }
        return className;
    }

    protected RenderKit createRenderKit(String className) {
        Class clazz = ClassUtil.forName(className);
        RenderKit renderKit = (RenderKit)DIContainerUtil.getComponentNoException(clazz);
        if (renderKit == null) {
            renderKit = (RenderKit)this.newInstance(className);
            S2Container container = SingletonS2ContainerFactory.getContainer();
            BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)clazz);
            if (beanDesc.hasPropertyDesc("container")) {
                beanDesc.getPropertyDesc("container").setValue((Object)renderKit, (Object)container);
            }
        }
        return renderKit;
    }

    protected Renderer createRenderer(String className) {
        Renderer renderer = null;
        try {
            renderer = (Renderer)this.newInstance(className);
        }
        catch (Exception e) {
            logger_.warn((Object)("Exception " + e + "occured when trying to create Renderer."));
        }
        return renderer;
    }

    List getRenderList() {
        return this.renderLists_;
    }

    static class RenderKitBean {
        private String renderKitId_;
        private String className_;
        private Iterator renderers_;

        public RenderKitBean(String renderKitId, String className, List rendererElements) {
            this.renderKitId_ = renderKitId;
            this.className_ = className;
            this.renderers_ = rendererElements.iterator();
        }

        public String getClassName() {
            return this.className_;
        }

        public String getRenderKitId() {
            return this.renderKitId_;
        }

        public boolean hasNext() {
            return this.renderers_.hasNext();
        }

        public RendererElement getRendererElement() {
            RendererElement element = null;
            if (this.hasNext()) {
                element = (RendererElement)this.renderers_.next();
            }
            return element;
        }
    }
}

