/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.el.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.MethodNotFoundException;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.ReferenceSyntaxException;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.teeda.core.el.ELParser;
import org.seasar.teeda.core.el.ValueBindingBase;
import org.seasar.teeda.core.el.impl.ValueBindingImpl;
import org.seasar.teeda.core.exception.ExtendEvaluationException;
import org.seasar.teeda.core.exception.ExtendMethodNotFoundExceptin;
import org.seasar.teeda.core.exception.MethodNotAccessibleException;
import org.seasar.teeda.core.util.DIContainerUtil;

public class MethodBindingImpl
extends MethodBinding
implements StateHolder {
    private ValueBindingBase vb_;
    private Class[] classes_;
    private ELParser parser_;
    private boolean transientValue_ = false;

    public MethodBindingImpl(ValueBindingBase vb, Class[] classes, ELParser parser) {
        this.classes_ = classes;
        this.vb_ = vb;
        this.parser_ = parser;
    }

    public MethodBindingImpl() {
        this.classes_ = null;
        this.vb_ = null;
        this.parser_ = null;
    }

    public Object invoke(FacesContext context, Object[] params) throws EvaluationException, MethodNotFoundException {
        AssertionUtil.assertNotNull((String)"context is null.", (Object)context);
        Object[] obj = this.getBaseAndProperty(context);
        Object base = obj[0];
        Object property = obj[1];
        try {
            Method m = base.getClass().getMethod(property.toString(), this.classes_);
            return m.invoke(base, params);
        }
        catch (SecurityException e) {
            throw new MethodNotAccessibleException(e, base.getClass().getName(), this.getExpressionString());
        }
        catch (NoSuchMethodException e) {
            throw new ExtendMethodNotFoundExceptin(e, base.getClass().getName(), this.getExpressionString());
        }
        catch (IndexOutOfBoundsException e) {
            throw new PropertyNotFoundException("Expression:" + this.getExpressionString(), e);
        }
        catch (InvocationTargetException e) {
            throw new ExtendEvaluationException(e.getCause(), base.getClass().getName(), this.getExpressionString());
        }
        catch (Exception e) {
            throw new ExtendEvaluationException(e, base.getClass().getName(), this.getExpressionString());
        }
    }

    public Class getType(FacesContext context) throws MethodNotFoundException {
        AssertionUtil.assertNotNull((String)"context is null.", (Object)context);
        Object[] obj = this.getBaseAndProperty(context);
        Object base = obj[0];
        Object property = obj[1];
        try {
            Class<?> returnType = base.getClass().getMethod(property.toString(), this.classes_).getReturnType();
            if (returnType.getName().equals("void")) {
                return Void.class;
            }
            return returnType;
        }
        catch (SecurityException e) {
            throw new MethodNotAccessibleException(e, base.getClass().getName(), this.getExpressionString());
        }
        catch (NoSuchMethodException e) {
            throw new ExtendMethodNotFoundExceptin(e, base.getClass().getName(), this.getExpressionString());
        }
        catch (IndexOutOfBoundsException e) {
            throw new PropertyNotFoundException("Expression:" + this.getExpressionString(), e);
        }
    }

    public String getExpressionString() {
        return this.vb_.getExpressionString();
    }

    public boolean isTransient() {
        return this.transientValue_;
    }

    public void setTransient(boolean transientValue) {
        this.transientValue_ = transientValue;
    }

    public Object saveState(FacesContext context) {
        return new Object[]{this.vb_.saveState(context), this.classes_};
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] obj = (Object[])state;
        this.vb_ = new ValueBindingImpl();
        this.vb_.restoreState(context, obj[0]);
        this.classes_ = (Class[])obj[1];
        this.parser_ = (ELParser)DIContainerUtil.getComponentNoException(ELParser.class);
    }

    private Object[] getBaseAndProperty(FacesContext context) throws ReferenceSyntaxException {
        Object expression = this.vb_.getExpression();
        Object o = this.parser_.getExpressionProcessor().resolveBase(context, expression);
        if (!(o instanceof Object[])) {
            throw new ReferenceSyntaxException();
        }
        Object[] obj = (Object[])o;
        return obj;
    }
}

