/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.faces.internal.UIComponentUtil;
import javax.faces.render.Renderer;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.FieldUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.render.ComponentIdLookupStrategy;
import org.seasar.teeda.core.render.DefaultComponentIdLookupStrategy;
import org.seasar.teeda.core.render.html.RenderAttributes;
import org.seasar.teeda.core.util.LoopIterator;
import org.seasar.teeda.core.util.RenderedComponentIterator;
import org.seasar.teeda.core.util.RendererUtil;

public abstract class AbstractHtmlRenderer
extends Renderer {
    private ComponentIdLookupStrategy idLookupStartegy;
    private RenderAttributes renderAttributes;
    private RendererMetaDataFactory rendererMetaDataFactory = new RendererMetaDataFactory();
    static /* synthetic */ Class class$java$lang$Object;

    public AbstractHtmlRenderer() {
        this.idLookupStartegy = new DefaultComponentIdLookupStrategy();
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        this.assertNotNull(context, component);
        return RendererUtil.getConvertedUIOutputValue(context, (UIOutput)component, submittedValue);
    }

    protected String getIdForRender(FacesContext context, UIComponent component) {
        return this.idLookupStartegy.getId(context, component);
    }

    protected UIComponent toNullIfNotRendered(UIComponent component) {
        if (component != null && !component.isRendered()) {
            return null;
        }
        return component;
    }

    protected void encodeComponent(FacesContext context, UIComponent component) throws IOException {
        component.encodeBegin(context);
        if (component.getRendersChildren()) {
            component.encodeChildren(context);
        } else {
            this.encodeDescendantComponent(context, component);
        }
        component.encodeEnd(context);
    }

    protected void encodeDescendantComponent(FacesContext context, UIComponent component) throws IOException {
        Iterator it = this.getRenderedChildrenIterator(component);
        while (it.hasNext()) {
            UIComponent child = (UIComponent)it.next();
            this.encodeComponent(context, child);
        }
    }

    protected void assertNotNull(FacesContext context, UIComponent component) {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"component", (Object)component);
    }

    protected String[] splitByComma(String s) {
        String[] split = StringUtil.split((String)s, (String)",");
        for (int i = 0; i < split.length; ++i) {
            split[i] = split[i].trim();
        }
        return split;
    }

    protected LoopIterator toStyleLoopIterator(String s) {
        return new LoopIterator(this.splitByComma(s));
    }

    protected Iterator getRenderedChildrenIterator(UIComponent component) {
        return new RenderedComponentIterator(component.getChildren());
    }

    protected String getLabelStyleClass(UIComponent component, boolean disabled) {
        if (disabled) {
            return UIComponentUtil.getStringAttribute(component, "disabledClass");
        }
        return UIComponentUtil.getStringAttribute(component, "enabledClass");
    }

    protected void renderAttributes(UIComponent component, ResponseWriter writer) throws IOException {
        String[] names = this.getRenderAttributeNames(this.getClass());
        RendererUtil.renderAttributes(writer, component, names);
        this.renderAttributes(component.getAttributes(), writer);
    }

    private String[] getRenderAttributeNames(Class rendererClass) {
        RendererMetaData rendererMetaData = this.rendererMetaDataFactory.getRendererMetaData(rendererClass);
        String[] names = this.renderAttributes.getAttributeNames(rendererMetaData.getComponentFamily(), rendererMetaData.getRendererType());
        if (names != null) {
            return names;
        }
        return new String[0];
    }

    protected void renderAttributes(Map attributes, ResponseWriter writer) throws IOException {
        Iterator it = attributes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            if (!this.isRenderAttributeName(key)) continue;
            RendererUtil.renderAttribute(writer, key, entry.getValue());
        }
    }

    private boolean isRenderAttributeName(String key) {
        return -1 == key.indexOf(46);
    }

    public void setComponentIdLookupStrategy(ComponentIdLookupStrategy idLookupStartegy) {
        this.idLookupStartegy = idLookupStartegy;
    }

    public ComponentIdLookupStrategy getComponentIdLookupStrategy() {
        return this.idLookupStartegy;
    }

    protected boolean containsAttributeForRender(UIComponent component) {
        if (RendererUtil.shouldRenderIdAttribute(component)) {
            return true;
        }
        String[] names = this.getRenderAttributeNames(this.getClass());
        if (RendererUtil.containsAttributesForRender(component, names)) {
            return true;
        }
        return this.containsAttributeForRender(component.getAttributes());
    }

    protected boolean containsAttributeForRender(Map attributes) {
        Iterator it = attributes.entrySet().iterator();
        while (it.hasNext()) {
            Object value;
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            if (!this.isRenderAttributeName(key) || !RendererUtil.shouldRenderAttribute(key, value = entry.getValue())) continue;
            return true;
        }
        return false;
    }

    protected void renderCheckedAttribute(ResponseWriter writer) throws IOException {
        RendererUtil.renderAttribute(writer, "checked", (Object)"checked");
    }

    protected void renderDisabledAttribute(ResponseWriter writer) throws IOException {
        RendererUtil.renderAttribute(writer, "disabled", (Object)"disabled");
    }

    protected void renderSelectedAttribute(ResponseWriter writer) throws IOException {
        RendererUtil.renderAttribute(writer, "selected", (Object)"selected");
    }

    public void setRenderAttributes(RenderAttributes renderAttributes) {
        this.renderAttributes = renderAttributes;
    }

    private static class RendererMetaDataFactory {
        private Map rendererMetaDataCache = new HashMap();

        private RendererMetaDataFactory() {
        }

        public RendererMetaData getRendererMetaData(Class rendererClass) {
            RendererMetaData rmd = (RendererMetaData)this.rendererMetaDataCache.get(rendererClass.getName());
            if (rmd != null) {
                return rmd;
            }
            rmd = new RendererMetaData();
            Class clazz = rendererClass;
            while (!clazz.equals(class$java$lang$Object == null ? AbstractHtmlRenderer.class$("java.lang.Object") : class$java$lang$Object)) {
                String componentFamily = this.getComponentFamily(rendererClass);
                if (componentFamily != null) {
                    rmd.setComponentFamily(componentFamily);
                }
                clazz = clazz.getSuperclass();
            }
            clazz = rendererClass;
            while (!clazz.equals(class$java$lang$Object == null ? AbstractHtmlRenderer.class$("java.lang.Object") : class$java$lang$Object)) {
                String rendererType = this.getRendererType(rendererClass);
                if (rendererType != null) {
                    rmd.setRendererType(rendererType);
                }
                clazz = clazz.getSuperclass();
            }
            this.rendererMetaDataCache.put(rendererClass.getName(), rmd);
            return rmd;
        }

        private String getComponentFamily(Class rendererClass) {
            BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)rendererClass);
            if (!beanDesc.hasField("COMPONENT_FAMILY")) {
                return null;
            }
            Field family = beanDesc.getField("COMPONENT_FAMILY");
            String componentFamily = (String)FieldUtil.get((Field)family, null);
            return componentFamily;
        }

        private String getRendererType(Class rendererClass) {
            BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)rendererClass);
            if (!beanDesc.hasField("RENDERER_TYPE")) {
                return null;
            }
            Field type = beanDesc.getField("RENDERER_TYPE");
            String rendererType = (String)FieldUtil.get((Field)type, null);
            return rendererType;
        }
    }

    private static class RendererMetaData {
        private String componentFamily;
        private String rendererType;

        private RendererMetaData() {
        }

        public String getComponentFamily() {
            return this.componentFamily;
        }

        public void setComponentFamily(String componentFamily) {
            this.componentFamily = componentFamily;
        }

        public String getRendererType() {
            return this.rendererType;
        }

        public void setRendererType(String rendererType) {
            this.rendererType = rendererType;
        }
    }
}

