/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.seasar.teeda.core.render.html.AbstractHtmlRenderer;
import org.seasar.teeda.core.util.DecodeUtil;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.core.util.ValueHolderUtil;

public class HtmlInputTextRenderer
extends AbstractHtmlRenderer {
    public static final String COMPONENT_FAMILY = "javax.faces.Input";
    public static final String RENDERER_TYPE = "javax.faces.Text";

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlInputTextEnd(context, (HtmlInputText)component);
    }

    protected void encodeHtmlInputTextEnd(FacesContext context, HtmlInputText htmlInputText) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", htmlInputText);
        RendererUtil.renderAttribute(writer, "type", (Object)"text");
        RendererUtil.renderIdAttributeIfNecessary(writer, htmlInputText, this.getIdForRender(context, htmlInputText));
        RendererUtil.renderAttribute(writer, "name", (Object)htmlInputText.getClientId(context));
        String value = ValueHolderUtil.getValueForRender(context, htmlInputText);
        RendererUtil.renderAttribute(writer, "value", (Object)value);
        this.renderAttributes(htmlInputText, writer);
        writer.endElement("input");
    }

    public void decode(FacesContext context, UIComponent component) {
        this.assertNotNull(context, component);
        this.decodeHtmlInputText(context, (HtmlInputText)component);
    }

    protected void decodeHtmlInputText(FacesContext context, HtmlInputText htmlInputText) {
        DecodeUtil.decode(context, htmlInputText);
    }
}

