/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.seasar.framework.container.ExternalContext;
import org.seasar.framework.container.S2Container;

public class BindingUtil {
    private BindingUtil() {
    }

    public static String getExpression(String componentName) {
        return "#{" + componentName + "}";
    }

    public static String getExpression(String componentName, String propertyName) {
        return "#{" + componentName + "." + propertyName + "}";
    }

    public static boolean isValueReference(String value) {
        if (value == null) {
            return false;
        }
        int start = value.indexOf("#{");
        if (start < 0) {
            return false;
        }
        int end = value.lastIndexOf(125);
        return end >= 0 && start < end;
    }

    public static Object getValue(S2Container container, String name) {
        Object var = BindingUtil.getValue(container.getExternalContext(), name);
        if (var != null) {
            return var;
        }
        if (container.hasComponentDef((Object)name)) {
            return container.getComponent((Object)name);
        }
        return null;
    }

    public static Object getValue(ExternalContext externalContext, String name) {
        Object var = externalContext.getRequestMap().get(name);
        if (var != null) {
            return var;
        }
        var = externalContext.getRequestParameterMap().get(name);
        if (var != null && !"null".equals(var)) {
            return var;
        }
        var = externalContext.getSessionMap().get(name);
        if (var != null) {
            return var;
        }
        return null;
    }

    public static Object resolveBinding(String value) {
        FacesContext context = FacesContext.getCurrentInstance();
        Application app = context.getApplication();
        ValueBinding vb = app.createValueBinding(value);
        return vb.getValue(context);
    }

    public static Object getBindingValue(UIComponent component, String propertyName) {
        ValueBinding binding = component.getValueBinding(propertyName);
        if (binding != null) {
            FacesContext ctx = FacesContext.getCurrentInstance();
            return binding.getValue(ctx);
        }
        return null;
    }

    public static void setValueBinding(UIComponent component, String name, String value) {
        FacesContext ctx = FacesContext.getCurrentInstance();
        Application app = ctx.getApplication();
        ValueBinding binding = app.createValueBinding(value);
        component.setValueBinding(name, binding);
    }
}

