/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.sftp;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.GenericFileName;
import org.apache.commons.vfs.provider.sftp.SftpClientFactory;
import org.apache.commons.vfs.provider.sftp.SftpFileObject;
import org.apache.commons.vfs.provider.sftp.SftpFileProvider;
import org.apache.commons.vfs.provider.sftp.SftpFileSystemConfigBuilder;

public class SftpFileSystem
extends AbstractFileSystem
implements FileSystem {
    private Session session;
    private ChannelSftp idleChannel;

    protected SftpFileSystem(GenericFileName rootName, Session session, FileSystemOptions fileSystemOptions) {
        super(rootName, null, fileSystemOptions);
        this.session = session;
    }

    protected void doCloseCommunicationLink() {
        if (this.idleChannel != null) {
            this.idleChannel.disconnect();
            this.idleChannel = null;
        }
        if (this.session != null) {
            this.session.disconnect();
            this.session = null;
        }
    }

    protected ChannelSftp getChannel() throws IOException {
        if (this.session == null) {
            Session session;
            try {
                GenericFileName rootName = (GenericFileName)this.getRootName();
                session = SftpClientFactory.createConnection(rootName.getHostName(), rootName.getPort(), rootName.getUserName(), rootName.getPassword(), this.getFileSystemOptions());
            }
            catch (Exception e) {
                throw new FileSystemException("vfs.provider.sftp/connect.error", this.getRootName(), (Throwable)e);
            }
            this.session = session;
        }
        try {
            ChannelSftp channel;
            if (this.idleChannel != null) {
                channel = this.idleChannel;
                this.idleChannel = null;
            } else {
                channel = (ChannelSftp)this.session.openChannel("sftp");
                channel.connect();
                Boolean userDirIsRoot = SftpFileSystemConfigBuilder.getInstance().getUserDirIsRoot(this.getFileSystemOptions());
                String workingDirectory = this.getRootName().getPath();
                if (!(workingDirectory == null || userDirIsRoot != null && userDirIsRoot.booleanValue())) {
                    try {
                        channel.cd(workingDirectory);
                    }
                    catch (SftpException e) {
                        throw new FileSystemException("vfs.provider.sftp/change-work-directory.error", workingDirectory);
                    }
                }
            }
            return channel;
        }
        catch (JSchException e) {
            throw new FileSystemException("vfs.provider.sftp/connect.error", this.getRootName(), (Throwable)e);
        }
    }

    protected void putChannel(ChannelSftp channel) {
        if (this.idleChannel == null) {
            this.idleChannel = channel;
        } else {
            channel.disconnect();
        }
    }

    protected void addCapabilities(Collection caps) {
        caps.addAll(SftpFileProvider.capabilities);
    }

    protected FileObject createFile(FileName name) throws FileSystemException {
        return new SftpFileObject(name, this);
    }

    public double getLastModTimeAccuracy() {
        return 1000.0;
    }
}

