/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.autodetector.impl;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import org.seasar.framework.traverser.Traverser;
import org.seasar.framework.util.JarFileUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.URLUtil;

public abstract class AbstractAutoDetector {
    private Map strategies = new HashMap();
    private List directoryNames = new ArrayList();

    public AbstractAutoDetector() {
        this.strategies.put("file", new FileSystemStrategy());
        this.strategies.put("jar", new JarFileStrategy());
        this.strategies.put("zip", new ZipFileStrategy());
    }

    public void addDirectoryName(String directoryName) {
        this.directoryNames.add(directoryName);
    }

    public void addStrategy(String protocol, Strategy strategy) {
        this.strategies.put(protocol, strategy);
    }

    public String getDirectoryName(int index) {
        return (String)this.directoryNames.get(index);
    }

    public int getDirectoryNameSize() {
        return this.directoryNames.size();
    }

    public Strategy getStrategy(String protocol) {
        return (Strategy)this.strategies.get(protocol);
    }

    protected class ZipFileStrategy
    implements Strategy {
        protected ZipFileStrategy() {
        }

        public void detect(String path, URL url, Traverser traverser) {
            JarFile jarFile = this.createJarFile(url);
            traverser.forEach(jarFile);
        }

        protected JarFile createJarFile(URL url) {
            String urlString = ResourceUtil.toExternalForm(url);
            int pos = urlString.lastIndexOf(33);
            String jarFileName = urlString.substring("zip:".length(), pos);
            return JarFileUtil.create(new File(jarFileName));
        }
    }

    protected class JarFileStrategy
    implements Strategy {
        protected JarFileStrategy() {
        }

        public void detect(String path, URL url, Traverser traverser) {
            JarFile jarFile = this.createJarFile(url);
            traverser.forEach(jarFile);
        }

        protected JarFile createJarFile(URL url) {
            URL nestedUrl = URLUtil.create(url.getPath());
            String path = nestedUrl.getPath();
            int pos = path.lastIndexOf(33);
            String jarFileName = path.substring(0, pos);
            return JarFileUtil.create(new File(jarFileName));
        }
    }

    protected class FileSystemStrategy
    implements Strategy {
        protected FileSystemStrategy() {
        }

        public void detect(String path, URL url, Traverser traverser) {
            File rootDir = this.getRootDir(path, url);
            for (int i = 0; i < AbstractAutoDetector.this.getDirectoryNameSize(); ++i) {
                String directoryName = AbstractAutoDetector.this.getDirectoryName(i);
                traverser.forEach(rootDir, directoryName);
            }
        }

        protected File getRootDir(String path, URL url) {
            File file = ResourceUtil.getResourceAsFile(path);
            String[] names = StringUtil.split(path, "/");
            for (int i = 0; i < names.length; ++i) {
                file = file.getParentFile();
            }
            return file;
        }
    }

    protected static interface Strategy {
        public void detect(String var1, URL var2, Traverser var3);
    }
}

