/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.factory;

import java.io.InputStream;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.ClassPathResourceResolver;
import org.seasar.framework.container.factory.ResourceResolver;
import org.seasar.framework.container.factory.S2ContainerBuilder;
import org.seasar.framework.exception.ResourceNotFoundRuntimeException;

public abstract class AbstractS2ContainerBuilder
implements S2ContainerBuilder {
    protected ResourceResolver resourceResolver = new ClassPathResourceResolver();

    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public void setResourceResolver(ResourceResolver resolver) {
        this.resourceResolver = resolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S2Container build(String path, ClassLoader classLoader) {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (classLoader != null) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            S2Container s2Container = this.build(path);
            return s2Container;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    protected InputStream getInputStream(String path) {
        InputStream is = this.resourceResolver.getInputStream(path);
        if (is == null) {
            throw new ResourceNotFoundRuntimeException(path);
        }
        return is;
    }
}

