/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.hotdeploy;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.seasar.framework.container.hotdeploy.HotdeployListener;
import org.seasar.framework.container.hotdeploy.OndemandProject;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.FileUtil;
import org.seasar.framework.util.ResourceUtil;

public class HotdeployClassLoader
extends ClassLoader {
    private OndemandProject[] projects;
    private List listeners = new ArrayList();

    public HotdeployClassLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    public void setProjects(OndemandProject[] projects) {
        this.projects = projects;
    }

    public void addHotdeployListener(HotdeployListener listener) {
        this.listeners.add(listener);
    }

    public HotdeployListener getHotdeployListener(int index) {
        return (HotdeployListener)this.listeners.get(index);
    }

    public int getHotdeployListenerSize() {
        return this.listeners.size();
    }

    public void removeHotdeployListener(HotdeployListener listener) {
        this.listeners.remove(listener);
    }

    public Class loadClass(String className, boolean resolve) throws ClassNotFoundException {
        if (this.isTargetClass(className)) {
            Class clazz = this.findLoadedClass(className);
            if (clazz != null) {
                return clazz;
            }
            String path = ClassUtil.getResourcePath(className);
            File file = ResourceUtil.getResourceAsFileNoException(path);
            if (file != null) {
                clazz = this.defineClass(className, file);
                this.definedClass(clazz);
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        return super.loadClass(className, resolve);
    }

    protected Class defineClass(String className, File classFile) {
        return this.defineClass(className, FileUtil.getBytes(classFile));
    }

    protected Class defineClass(String className, byte[] bytes) {
        return this.defineClass(className, bytes, 0, bytes.length);
    }

    protected boolean isTargetClass(String className) {
        if (this.projects == null) {
            return true;
        }
        for (int i = 0; i < this.projects.length; ++i) {
            OndemandProject project = this.projects[i];
            int m = project.matchClassName(className);
            if (m == 0) {
                return true;
            }
            if (m != 2) continue;
            return false;
        }
        return false;
    }

    protected void definedClass(Class clazz) {
        for (int i = 0; i < this.getHotdeployListenerSize(); ++i) {
            HotdeployListener listener = this.getHotdeployListener(i);
            listener.definedClass(clazz);
        }
    }
}

