<%--
	Copyright 2005-2006 The Portal Application Laboratory Team.
	
	Licensed under the Apache License, Version 2.0 (the "License");
	you may not use this file except in compliance with the License.
	You may obtain a copy of the License at
    	http://www.apache.org/licenses/LICENSE-2.0
	Unless required by applicable law or agreed to in writing, software
	distributed under the License is distributed on an "AS IS" BASIS,
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	See the License for the specific language governing permissions and
	limitations under the License.
--%>

<%@ taglib uri='http://java.sun.com/portlet' prefix='portlet'%>
<%@ taglib uri="http://java.sun.com/jstl/fmt" prefix="fmt" %>
<%@ page import="java.util.*"%>

<jsp:useBean id="todayweather" class="jp.sf.pal.weather.Weather" scope="request" />
<jsp:useBean id="tomorrowweather" class="jp.sf.pal.weather.Weather" scope="request" />
<fmt:setBundle basename="jp.sf.pal.weather.resources.WeatherResources" />
<portlet:defineObjects/>

<form action="<portlet:actionURL />" method="POST">

<table width="100%">

	<!-- Display Pref. and City -->
	<tr>
		<td colspan="2" align="center" style="font-size: x-small">
			<a href="<jsp:getProperty name="todayweather" property="link" />" style="font-size: x-small">
			<jsp:getProperty name="todayweather" property="pref" />&nbsp;
			<jsp:getProperty name="todayweather" property="city" />
			<fmt:message key="weather.label.OfWeather" />
			</a>
		</td>
	</tr>
	
	<!-- Display Forecast Day -->
	<tr>
		<td align="center" style="font-size: x-small">
			<fmt:message key="weather.label.Today"/>
		</td>
		<td align="center" style="font-size: x-small">
			<fmt:message key="weather.label.Tomorrow"/>
		</td>
	</tr>
	
	<!-- Display Forecast Image -->
	<tr>
		<!-- Today -->
		<td align="center">
			<img src="<jsp:getProperty name="todayweather" property="imgUrl" />"
		     alt="<jsp:getProperty name="todayweather" property="imgTitle" />"
		     width="<jsp:getProperty name="todayweather" property="imgWidth" />"
		     height="<jsp:getProperty name="todayweather" property="imgHeight" />"
		     border="0" />
		</td>
		<!-- Tomorrow -->
		<td align="center">
			<img src="<jsp:getProperty name="tomorrowweather" property="imgUrl" />"
		     alt="<jsp:getProperty name="tomorrowweather" property="imgTitle" />"
		     width="<jsp:getProperty name="tomorrowweather" property="imgWidth" />"
		     height="<jsp:getProperty name="tomorrowweather" property="imgHeight" />"
		     border="0" />
		</td>
	</tr>
	
	<!--  Display Forecast -->
	<tr>
		<!-- Today -->
		<td align="center" style="font-size: x-small">
			<jsp:getProperty name="todayweather" property="telop" />
		</td>
		<!-- Tomorrow -->
		<td align="center" style="font-size: x-small">
			<jsp:getProperty name="tomorrowweather" property="telop" />
		</td>
	</tr>
	
	<!--  Temperature -->
	<tr>
		<td align="center" style="font-size: x-small;">
			<span style="color: red;">
			<fmt:message key="weather.label.High" />:
			<jsp:getProperty name="todayweather" property="tempMaxOutput"/>
			</span><br>
			<span style="color: blue;">
			<fmt:message key="weather.label.Low" />:
			<jsp:getProperty name="todayweather" property="tempMinOutput"/>
			</span>
		</td>
		<td align="center" style="font-size: x-small;">
			<span style="color: red;">
			<fmt:message key="weather.label.High" />:
			<jsp:getProperty name="tomorrowweather" property="tempMaxOutput"/>
			</span><br>
			<span style="color: blue;">
			<fmt:message key="weather.label.Low" />:
			<jsp:getProperty name="tomorrowweather" property="tempMinOutput"/>
			</span>
		</td>
	</tr>
	
	<!-- Copyright -->
	<tr>
		<td align="center" colspan="2">
		<a href="<jsp:getProperty name="todayweather" property="copyrightLink" />" style="font-size:x-small">
		<jsp:getProperty name="todayweather" property="copyrightTitle" />
		</a>
		</td>
	</tr>

	<!-- Select Menu -->	
	<tr>
		<td align="center" width="10%" style="font-size: x-small;" colspan="2">
		<fmt:message key="weather.label.Area"/>:
		<select name="city">
			<option value="default"><fmt:message key="weather.label.SelectArea"/>	</option>
<%
	Map			cityMap = (Map)renderRequest.getAttribute("city") ;
	String		reqId = (String)renderRequest.getAttribute("id") ;
	Iterator	it = cityMap.keySet().iterator() ;
	while (it.hasNext()) {
		Integer id = (Integer)it.next() ;
		String cityId = id.toString() ;
		String cityName = (String)cityMap.get(id) ;
		String selected = "" ;
		if (reqId.equals(cityId)) {
			selected = "selected" ;
		}
%>
			<option value="<%= cityId %>" <%= selected %>><%= cityName %></option>
<%
	}
%>
		</select>
		</td>
	</tr>
	
	<!-- Submit -->
	<tr class="portlet-section-body">
		<td colspan="2" align="center">
		<input type="submit" value="<fmt:message key="weather.label.Submit"/>">
		</td>
	</tr>
</table>

</form>
