package jp.sf.pal.searchselector.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.sf.pal.searchselector.engine.SearchEngine;
import jp.sf.pal.searchselector.engine.SearchEngineFactory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

public class UrlGeneratorServlet extends HttpServlet
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory
            .getLog(UrlGeneratorServlet.class);

    private static final String ENCODING_UTF8 = "UTF-8";

    private static final String SEARCH_WORD = "SEARCH_WORD";

    private static final String ID = "ID";

    /* (non-Javadoc)
     * @see javax.servlet.http.HttpServlet#doPost(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
    @Override
    protected void doPost(HttpServletRequest request,
            HttpServletResponse response) throws ServletException, IOException
    {
        request.setCharacterEncoding(ENCODING_UTF8);
        response.setContentType("text/plain; charset=UTF-8");

        String searchWord = request.getParameter(SEARCH_WORD);
        String id = request.getParameter(ID);

        if (log.isDebugEnabled())
        {
            log
                    .debug("doGet(HttpServletRequest, HttpServletResponse) - searchWord="
                            + searchWord + ", id=" + id);
        }

        SearchEngineFactory searchEngineFactory = (SearchEngineFactory) SingletonS2ContainerFactory
                .getContainer().getComponent("SearchEngineFactory");
        List<SearchEngine> engines = searchEngineFactory.getSearchEngines();
        for (SearchEngine engine : engines)
        {
            if (engine.getId().equals(id))
            {
                if (log.isDebugEnabled())
                {
                    log
                            .debug("doGet(HttpServletRequest, HttpServletResponse) url="
                                    + engine.getActionUrl().replaceAll(
                                            SEARCH_WORD,
                                            URLEncoder.encode(searchWord,
                                                    engine.getEncoding())));
                }

                PrintWriter writer = response.getWriter();
                writer.write(engine.getActionUrl().replaceAll(SEARCH_WORD,
                        URLEncoder.encode(searchWord, engine.getEncoding())));
                writer.flush();
                return;
            }
        }

        response.sendError(HttpServletResponse.SC_NOT_FOUND,
                "Cannot find a search engine.");
    }

}
