package jp.sf.pal.vfs.beans;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.PortletSession;

import jp.sf.pal.vfs.VFSConstants;
import jp.sf.pal.vfs.util.VFSConfigUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.Selectors;
import org.apache.commons.vfs.VFS;
import org.seasar.portlet.util.PortletRequestUtil;

import com.marevol.utils.faces.application.FacesMessageUtil;

public class ListViewPageBean
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(ListViewPageBean.class);

    private HeaderMenuSessionBean headerMenuSession;

    public List getObjects()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getObjects()");
        }

        String uri = headerMenuSession.getUri();
        // Get File System
        ArrayList objects = new ArrayList();
        if (log.isDebugEnabled())
        {
            log.debug("getObjects() - uri=" + uri);
        }
        if (VFSConfigUtil.checkPath(uri))
        {
            try
            {
                FileSystemManager fsManager = VFS.getManager();
                FileObject currentDirectory = fsManager.resolveFile(uri);

                FileObject[] children = currentDirectory.getChildren();
                ArrayList folders = new ArrayList();
                ArrayList files = new ArrayList();
                for (int i = 0; i < children.length; i++)
                {
                    try
                    {
                        if (children[i].getType() == FileType.FOLDER)
                        {
                            folders.add(new FileParameterBean(children[i]));
                        }
                        else
                        {
                            files.add(new FileParameterBean(children[i]));
                        }
                    }
                    catch (FileSystemException e)
                    {
                        files.add(new FileParameterBean(children[i]));
                    }
                }
                objects.addAll(folders);
                objects.addAll(files);
            }
            catch (FileSystemException e)
            {
                // TODO i18n
                FacesMessageUtil.addErrorMessage(
                        "The file system error occurs.", e.toString());
                log.error("The file system error occurs.", e);
            }
        }
        else
        {
            // TODO i18n
            FacesMessageUtil.addErrorMessage("access denied.");
        }
        return (List) objects;

    }

    public String select()
    {
        if (log.isDebugEnabled())
        {
            log.debug("select()");
        }

        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext exContext = context.getExternalContext();
        Map map = exContext.getRequestMap();
        FileParameterBean fileParam = (FileParameterBean) map.get("item");
        if (fileParam != null)
        {
            if (fileParam.isFolder())
            {
                headerMenuSession.setUri(fileParam.getURI());
            }
            else if (fileParam.isFile())
            {
                PortletRequestUtil.getPortletSession().setAttribute(
                        VFSConstants.DOWNLOAD_OBJECT, fileParam,
                        PortletSession.APPLICATION_SCOPE);
                // TODO I18N
                headerMenuSession
                        .setOutputHtml("<script language=\"javascript\">\n<!--\nlocation.href=\""
                                + exContext.getRequestContextPath()
                                + "/FileServlet\";\n//--></script>");
            }
            else
            {
                // TODO I18N
                FacesMessageUtil
                        .addWarnMessage("The selected object is not FOLDER or FILE.");
            }
        }
        else
        {
            // TODO I18N
            FacesMessageUtil
                    .addWarnMessage("The selected object is not found.");
        }
        return null;
    }

    public String delete()
    {
        if (log.isDebugEnabled())
        {
            log.debug("delete()");
        }

        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext exContext = context.getExternalContext();
        Map map = exContext.getRequestMap();
        FileParameterBean fileParam = (FileParameterBean) map.get("item");
        if (fileParam != null)
        {
            if (fileParam.isFolder())
            {
                try
                {
                    FileSystemManager fsManager = VFS.getManager();
                    FileObject fileObject = fsManager.resolveFile(fileParam
                            .getURI());

                    // TODO select FileSelector
                    int num = fileObject.delete(Selectors.SELECT_ALL);
                    if (num > 0)
                    {
                        //TODO i18n
                        FacesMessageUtil.addInfoMessage("Deleted " + num
                                + " objects.");
                    }
                    else
                    {
                        //TODO i18n
                        FacesMessageUtil
                                .addErrorMessage("Failed delete action.");
                    }
                }
                catch (FileSystemException e)
                {
                    //TODO i18n
                    FacesMessageUtil.addErrorMessage("Failed delete action.");
                    log.error("Failed delete action.", e);
                }
            }
            else if (fileParam.isFile())
            {
                try
                {
                    FileSystemManager fsManager = VFS.getManager();
                    FileObject fileObject = fsManager.resolveFile(fileParam
                            .getURI());

                    if (fileObject.delete())
                    {
                        //TODO i18n
                        FacesMessageUtil.addInfoMessage("Deleted the file: "
                                + fileParam.getURI());
                    }
                    else
                    {
                        //TODO i18n
                        FacesMessageUtil
                                .addWarnMessage("Failed delete action.");
                    }
                }
                catch (FileSystemException e)
                {
                    //TODO i18n
                    FacesMessageUtil.addErrorMessage("Failed delete action.", e
                            .toString());
                    log.error("Failed delete action.", e);
                }
            }
            else
            {
                // TODO I18N
                FacesMessageUtil
                        .addWarnMessage("The selected object is not FOLDER or FILE.");
            }
        }
        else
        {
            // TODO I18N
            FacesMessageUtil
                    .addWarnMessage("The selected object is not found.");
        }
        return headerMenuSession.goToListViewPage();
    }

    /**
     * @return the headerMenuSession
     */
    public HeaderMenuSessionBean getHeaderMenuSession()
    {
        return headerMenuSession;
    }

    /**
     * @param headerMenuSession the headerMenuSession to set
     */
    public void setHeaderMenuSession(HeaderMenuSessionBean headerMenuSession)
    {
        this.headerMenuSession = headerMenuSession;
    }
}
