/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.hotdeploy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.container.hotdeploy.HotdeployClassLoader;
import org.seasar.framework.container.hotdeploy.HotdeployListener;
import org.seasar.framework.container.hotdeploy.OndemandProject;
import org.seasar.framework.container.hotdeploy.OndemandS2Container;
import org.seasar.framework.container.impl.S2ContainerBehavior;
import org.seasar.framework.container.impl.S2ContainerImpl;
import org.seasar.framework.container.util.S2ContainerUtil;
import org.seasar.framework.exception.ClassNotFoundRuntimeException;
import org.seasar.framework.util.DisposableUtil;

public class OndemandBehavior
extends S2ContainerBehavior.DefaultProvider
implements HotdeployListener,
OndemandS2Container {
    private ClassLoader originalClassLoader;
    private HotdeployClassLoader hotdeployClassLoader;
    private List projects = new ArrayList();
    private Map componentDefCache = new HashMap();

    public OndemandProject getProject(int index) {
        return (OndemandProject)this.projects.get(index);
    }

    public OndemandProject[] getProjects() {
        return this.projects.toArray(new OndemandProject[this.projects.size()]);
    }

    public int getProjectSize() {
        return this.projects.size();
    }

    public void addProject(OndemandProject project) {
        this.projects.add(project);
    }

    public void start() {
        this.originalClassLoader = Thread.currentThread().getContextClassLoader();
        this.hotdeployClassLoader = new HotdeployClassLoader(this.originalClassLoader);
        this.hotdeployClassLoader.setProjects(this.getProjects());
        this.hotdeployClassLoader.addHotdeployListener(this);
        Thread.currentThread().setContextClassLoader(this.hotdeployClassLoader);
        S2ContainerImpl container = (S2ContainerImpl)SingletonS2ContainerFactory.getContainer();
        container.setClassLoader(this.hotdeployClassLoader);
    }

    public void stop() {
        DisposableUtil.dispose();
        Thread.currentThread().setContextClassLoader(this.originalClassLoader);
        this.hotdeployClassLoader = null;
        this.originalClassLoader = null;
        this.componentDefCache.clear();
    }

    public void definedClass(Class clazz) {
        this.loadComponentDef(SingletonS2ContainerFactory.getContainer(), clazz);
    }

    public ComponentDef getComponentDef(Class targetClass) {
        return (ComponentDef)this.componentDefCache.get(targetClass);
    }

    protected ComponentDef getComponentDef(S2Container container, Object key) {
        ComponentDef cd = this.getComponentDefFromCache(key);
        if (cd != null) {
            return cd;
        }
        cd = super.getComponentDef(container, key);
        if (cd != null) {
            return cd;
        }
        if (key instanceof Class) {
            return this.getComponentDef(container, (Class)key);
        }
        if (key instanceof String) {
            return this.getComponentDef(container, (String)key);
        }
        throw new IllegalArgumentException("key");
    }

    protected ComponentDef getComponentDefFromCache(Object key) {
        return (ComponentDef)this.componentDefCache.get(key);
    }

    protected void loadComponentDef(S2Container container, Class clazz) {
        OndemandProject project;
        for (int i = 0; i < this.getProjectSize() && !(project = this.getProject(i)).loadComponentDef(this, clazz); ++i) {
        }
    }

    protected ComponentDef getComponentDef(S2Container container, Class clazz) {
        for (int i = 0; i < this.getProjectSize(); ++i) {
            OndemandProject project = this.getProject(i);
            ComponentDef cd = project.getComponentDef((OndemandS2Container)this, clazz);
            if (cd == null) continue;
            return cd;
        }
        return null;
    }

    protected ComponentDef getComponentDef(S2Container container, String componentName) {
        for (int i = 0; i < this.getProjectSize(); ++i) {
            OndemandProject project = this.getProject(i);
            try {
                ComponentDef cd = project.getComponentDef((OndemandS2Container)this, componentName);
                if (cd == null) continue;
                return cd;
            }
            catch (ClassNotFoundRuntimeException ignore) {
                // empty catch block
            }
        }
        return null;
    }

    public void register(ComponentDef componentDef) {
        componentDef.setContainer(SingletonS2ContainerFactory.getContainer());
        this.registerByClass(componentDef);
        this.registerByName(componentDef);
    }

    protected void registerByClass(ComponentDef componentDef) {
        Class[] classes = S2ContainerUtil.getAssignableClasses(componentDef.getComponentClass());
        for (int i = 0; i < classes.length; ++i) {
            this.registerMap(classes[i], componentDef);
        }
    }

    protected void registerByName(ComponentDef componentDef) {
        String componentName = componentDef.getComponentName();
        if (componentName != null) {
            this.registerMap(componentName, componentDef);
        }
    }

    protected void registerMap(Object key, ComponentDef componentDef) {
        ComponentDef previousCd = (ComponentDef)this.componentDefCache.get(key);
        if (previousCd == null) {
            this.componentDefCache.put(key, componentDef);
        } else {
            ComponentDef tmrcd = S2ContainerImpl.createTooManyRegistration(key, previousCd, componentDef);
            this.componentDefCache.put(key, tmrcd);
        }
    }
}

