/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import org.seasar.framework.message.MessageFormatter;

public class ClassLoaderUtil {
    public static ClassLoader getClassLoader(Class targetClass) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            return contextClassLoader;
        }
        ClassLoader targetClassLoader = targetClass.getClassLoader();
        ClassLoader thisClassLoader = ClassLoaderUtil.class.getClassLoader();
        if (targetClassLoader != null && thisClassLoader != null) {
            if (ClassLoaderUtil.isAncestor(thisClassLoader, targetClassLoader)) {
                return thisClassLoader;
            }
            return targetClassLoader;
        }
        if (targetClassLoader != null) {
            return targetClassLoader;
        }
        if (thisClassLoader != null) {
            return thisClassLoader;
        }
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        if (systemClassLoader != null) {
            return systemClassLoader;
        }
        throw new IllegalStateException(MessageFormatter.getMessage("ESSR0001", new Object[]{"ClassLoader"}));
    }

    protected static boolean isAncestor(ClassLoader cl, ClassLoader other) {
        while (cl != null) {
            if (cl == other) {
                return true;
            }
            cl = cl.getParent();
        }
        return false;
    }
}

