/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.io.Serializable;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.internal.ClassLoaderUtil;

public class AttachedObjectStateWrapper
implements Serializable {
    private static final long serialVersionUID = 3256726169255885111L;
    private Object savedState = null;
    private String className = null;
    private boolean isSavedStateHolder = false;

    public AttachedObjectStateWrapper(FacesContext context, Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        this.className = obj.getClass().getName();
        if (obj instanceof StateHolder) {
            StateHolder stateHolder = (StateHolder)obj;
            if (!stateHolder.isTransient()) {
                this.savedState = stateHolder.saveState(context);
                this.isSavedStateHolder = true;
            }
        } else if (obj instanceof Serializable) {
            this.savedState = obj;
        }
    }

    public Object restore(FacesContext context) throws IllegalStateException {
        Object result = null;
        if (this.savedState == null) {
            return null;
        }
        if (!this.isSavedStateHolder) {
            result = this.savedState;
        } else if (this.isSavedStateHolder) {
            try {
                ClassLoader loader = ClassLoaderUtil.getClassLoader(context);
                Class clazz = ClassLoaderUtil.loadClass(loader, this.className);
                result = clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e.getMessage());
            }
            catch (InstantiationException e) {
                throw new IllegalStateException(e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e.getMessage());
            }
            if (result instanceof StateHolder) {
                ((StateHolder)result).restoreState(context, this.savedState);
            }
        }
        return result;
    }
}

