/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItem;
import javax.faces.component.UISelectItems;
import javax.faces.model.SelectItem;

public class SelectItemsIterator
implements Iterator {
    private Iterator children = null;
    private Iterator items = null;
    private SelectItem nextValue;

    public SelectItemsIterator(UIComponent component) {
        this.children = component.getChildren().iterator();
    }

    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public boolean hasNext() {
        if (this.nextValue != null) {
            return true;
        }
        this.nextValue = this.getNextSelectItem();
        return this.nextValue != null;
    }

    protected SelectItem getNextSelectItem() {
        if (this.items != null) {
            if (this.items.hasNext()) {
                return (SelectItem)this.items.next();
            }
            this.items = null;
        }
        if (!this.children.hasNext()) {
            return null;
        }
        UIComponent child = (UIComponent)this.children.next();
        if (child instanceof UISelectItem) {
            return this.createSelectItem((UISelectItem)child);
        }
        if (child instanceof UISelectItems) {
            UISelectItems items = (UISelectItems)child;
            return this.getNextFromUISelectItems(items);
        }
        return this.getNextSelectItem();
    }

    protected SelectItem getNextFromUISelectItems(UISelectItems items) {
        Object value = items.getValue();
        if (value instanceof SelectItem) {
            return (SelectItem)value;
        }
        if (value instanceof SelectItem[]) {
            this.items = Arrays.asList((SelectItem[])value).iterator();
            return this.getNextSelectItem();
        }
        if (value instanceof Collection) {
            Collection c = (Collection)value;
            this.items = c.iterator();
            return this.getNextSelectItem();
        }
        if (value instanceof Map) {
            this.items = new SelectItemsMapIterator((Map)value);
            return this.getNextSelectItem();
        }
        return this.getNextSelectItem();
    }

    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.nextValue != null) {
            SelectItem o = this.nextValue;
            this.nextValue = null;
            return o;
        }
        throw new NoSuchElementException();
    }

    protected SelectItem createSelectItem(UISelectItem ui) {
        SelectItem item = (SelectItem)ui.getValue();
        if (item != null) {
            return item;
        }
        return new SelectItem(ui.getItemValue(), ui.getItemLabel(), ui.getItemDescription(), ui.isItemDisabled());
    }

    protected static class SelectItemsMapIterator
    implements Iterator {
        private Map map;
        private Iterator keys;

        public SelectItemsMapIterator(Map map) {
            this.map = map;
            this.keys = map.keySet().iterator();
        }

        public boolean hasNext() {
            return this.keys.hasNext();
        }

        public Object next() {
            Object key = this.keys.next();
            Object value = this.map.get(key);
            return new SelectItem(value.toString(), key.toString());
        }

        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

