/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import javax.faces.FacesException;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.internal.FacesMessageUtil;
import javax.faces.internal.UIComponentUtil;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.seasar.framework.util.AssertionUtil;

public class LongRangeValidator
implements Validator,
StateHolder {
    public static final String VALIDATOR_ID = "javax.faces.LongRange";
    public static final String TYPE_MESSAGE_ID = "javax.faces.validator.LongRangeValidator.TYPE";
    public static final String MAXIMUM_MESSAGE_ID = "javax.faces.validator.LongRangeValidator.MAXIMUM";
    public static final String MINIMUM_MESSAGE_ID = "javax.faces.validator.LongRangeValidator.MINIMUM";
    private Long maximum = null;
    private Long minimum = null;
    private boolean transientValue = false;

    public LongRangeValidator() {
    }

    public LongRangeValidator(long maximum) {
        this.maximum = new Long(maximum);
    }

    public LongRangeValidator(long maximum, long minimum) {
        this.maximum = new Long(maximum);
        this.minimum = new Long(minimum);
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws FacesException {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"component", (Object)component);
        if (value == null) {
            return;
        }
        try {
            double maxValue;
            long longValue = LongRangeValidator.parseLongValue(value);
            if (this.maximum != null && this.minimum != null) {
                double minValue = this.minimum.longValue();
                double maxValue2 = this.maximum.longValue();
                if ((double)longValue < minValue || (double)longValue > maxValue2) {
                    Object[] args = new Object[]{this.minimum, this.maximum, UIComponentUtil.getLabel(component)};
                    throw new ValidatorException(FacesMessageUtil.getMessage(context, this.getNotInRangeMessageId(), args));
                }
            } else if (this.minimum != null) {
                double minValue = this.minimum.longValue();
                if ((double)longValue < minValue) {
                    Object[] args = new Object[]{this.minimum, UIComponentUtil.getLabel(component)};
                    throw new ValidatorException(FacesMessageUtil.getMessage(context, this.getMinimumMessageId(), args));
                }
            } else if (this.maximum != null && (double)longValue > (maxValue = (double)this.maximum.longValue())) {
                Object[] args = new Object[]{this.maximum, UIComponentUtil.getLabel(component)};
                throw new ValidatorException(FacesMessageUtil.getMessage(context, this.getMaximumMessageId(), args));
            }
        }
        catch (NumberFormatException e) {
            throw new ValidatorException(FacesMessageUtil.getMessage(context, this.getTypeMessageId(), new Object[]{UIComponentUtil.getLabel(component)}));
        }
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean transientValue) {
        this.transientValue = transientValue;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.maximum, this.minimum};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.maximum = (Long)values[0];
        this.minimum = (Long)values[1];
    }

    public long getMaximum() {
        return this.maximum != null ? this.maximum : Long.MAX_VALUE;
    }

    public long getMinimum() {
        return this.minimum != null ? this.minimum : Long.MIN_VALUE;
    }

    public void setMaximum(long maximum) {
        this.maximum = new Long(maximum);
    }

    public void setMinimum(long minimum) {
        this.minimum = new Long(minimum);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LongRangeValidator)) {
            return false;
        }
        LongRangeValidator v = (LongRangeValidator)obj;
        if (this.maximum != null && v.maximum == null && this.maximum == null && v.maximum != null) {
            return false;
        }
        if (this.minimum != null && v.minimum == null && this.minimum == null && v.minimum != null) {
            return false;
        }
        return this.getMaximum() == v.getMaximum() && this.getMinimum() == v.getMinimum();
    }

    public int hashCode() {
        Long max = this.maximum != null ? this.maximum : new Long(1L);
        Long min = this.minimum != null ? this.minimum : new Long(1L);
        return max.hashCode() * min.hashCode() * 17;
    }

    private static long parseLongValue(Object obj) throws NumberFormatException {
        long value = obj instanceof Number ? ((Number)obj).longValue() : Long.parseLong(obj.toString());
        return value;
    }

    protected String getMaximumMessageId() {
        return MAXIMUM_MESSAGE_ID;
    }

    protected String getMinimumMessageId() {
        return MINIMUM_MESSAGE_ID;
    }

    protected String getNotInRangeMessageId() {
        return "javax.faces.validator.NOT_IN_RANGE";
    }

    protected String getTypeMessageId() {
        return TYPE_MESSAGE_ID;
    }
}

