/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.exception;

import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import org.seasar.teeda.core.util.MessageFormatterUtil;

public class ExtendEvaluationException
extends EvaluationException {
    private static final long serialVersionUID = 3258407322669101874L;
    private static final String EVALUATION_EXCEPTION_ID = "ETDA0003";
    private String messageCode_;
    private Object[] args_;
    private String simpleMessage_;
    private String message_;
    private MethodBinding methodBinding_;

    public ExtendEvaluationException(EvaluationException cause, MethodBinding mb) {
        this(cause, mb.getClass().getName(), mb.getExpressionString());
        this.methodBinding_ = mb;
    }

    public ExtendEvaluationException(Throwable cause, String className, String expressionString) {
        this(cause, className, expressionString, EVALUATION_EXCEPTION_ID);
    }

    protected ExtendEvaluationException(Throwable cause, String className, String expressionString, String messageCode) {
        super(cause);
        this.args_ = new Object[]{className, expressionString};
        this.messageCode_ = messageCode;
        this.simpleMessage_ = MessageFormatterUtil.getSimpleMessage(this.messageCode_, this.args_);
        this.message_ = MessageFormatterUtil.getFormattedMessage(this.messageCode_, this.simpleMessage_);
    }

    public MethodBinding getMethodBinding() {
        return this.methodBinding_;
    }

    public final String getMessageCode() {
        return this.messageCode_;
    }

    public final Object[] getArgs() {
        return this.args_;
    }

    public final String getMessage() {
        return this.message_;
    }

    public final String getSimpleMessage() {
        return this.simpleMessage_;
    }
}

