/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.lifecycle.impl;

import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.portlet.PortletRequest;
import org.seasar.teeda.core.lifecycle.AbstractPhase;
import org.seasar.teeda.core.lifecycle.Postback;
import org.seasar.teeda.core.portlet.FacesPortlet;
import org.seasar.teeda.core.util.ExternalContextUtil;
import org.seasar.teeda.core.util.FacesContextUtil;
import org.seasar.teeda.core.util.PortletUtil;

public class RestoreViewPhase
extends AbstractPhase
implements Postback {
    private static final String VIEW_ID_ATTR = RestoreViewPhase.class.getName() + ".VIEW_ID";
    private static final String POSTBACK_ATTR = RestoreViewPhase.class.getName() + ".POSTBACK";

    protected void executePhase(FacesContext context) throws FacesException {
        ExternalContext externalContext = context.getExternalContext();
        String viewId = null;
        if (PortletUtil.isPortlet(context)) {
            PortletRequest request = (PortletRequest)externalContext.getRequest();
            viewId = request.getParameter(FacesPortlet.VIEW_ID);
        } else {
            viewId = ExternalContextUtil.getViewId(externalContext);
        }
        ViewHandler viewHandler = FacesContextUtil.getViewHandler(context);
        UIViewRoot viewRoot = viewHandler.restoreView(context, viewId);
        if (viewRoot == null) {
            viewRoot = viewHandler.createView(context, viewId);
        }
        String previousViewId = this.getViewIdFromSession(externalContext);
        context.setViewRoot(viewRoot);
        this.saveViewIdToSession(externalContext, viewId);
        this.initializeChildren(context, viewRoot);
        if (externalContext.getRequestParameterMap().isEmpty()) {
            context.renderResponse();
        }
        this.setPostback(externalContext, viewId.equals(previousViewId));
    }

    protected String getViewIdFromSession(ExternalContext externalContext) {
        return (String)externalContext.getSessionMap().get(VIEW_ID_ATTR);
    }

    protected void saveViewIdToSession(ExternalContext externalContext, String viewId) {
        externalContext.getSessionMap().put(VIEW_ID_ATTR, viewId);
    }

    protected PhaseId getCurrentPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }

    protected void setPostback(ExternalContext externalContext, boolean postback) {
        externalContext.getRequestMap().put(POSTBACK_ATTR, new Boolean(postback));
    }

    public boolean isPostBack() {
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext externalContext = context.getExternalContext();
        Boolean postBack = (Boolean)externalContext.getRequestMap().get(POSTBACK_ATTR);
        return postBack;
    }
}

