/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlDataTable;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.seasar.teeda.core.render.html.AbstractHtmlRenderer;
import org.seasar.teeda.core.util.LoopIterator;
import org.seasar.teeda.core.util.RendererUtil;

public class HtmlDataTableRenderer
extends AbstractHtmlRenderer {
    public static final String COMPONENT_FAMILY = "javax.faces.Data";
    public static final String RENDERER_TYPE = "javax.faces.Table";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlDataTableBegin(context, (HtmlDataTable)component);
    }

    protected void encodeHtmlDataTableBegin(FacesContext context, HtmlDataTable htmlDataTable) throws IOException {
        UIComponent tableFooter;
        Iterator it;
        UIComponent columnFooter;
        UIComponent columnHeader;
        UIColumn column;
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("table", htmlDataTable);
        RendererUtil.renderIdAttributeIfNecessary(writer, htmlDataTable, this.getIdForRender(context, htmlDataTable));
        this.renderAttributes(htmlDataTable, writer);
        ArrayList<UIColumn> columns = new ArrayList<UIColumn>();
        boolean isColumnHeaderExist = false;
        boolean isColumnFooterExist = false;
        Iterator it2 = this.getRenderedChildrenIterator(htmlDataTable);
        while (it2.hasNext()) {
            UIComponent child = (UIComponent)it2.next();
            if (!(child instanceof UIColumn)) continue;
            column = (UIColumn)child;
            columns.add(column);
            if (!isColumnHeaderExist && (columnHeader = column.getHeader()) != null && columnHeader.isRendered()) {
                isColumnHeaderExist = true;
            }
            if (isColumnFooterExist || (columnFooter = column.getFooter()) == null || !columnFooter.isRendered()) continue;
            isColumnFooterExist = true;
        }
        UIComponent tableHeader = this.toNullIfNotRendered(htmlDataTable.getHeader());
        if (tableHeader != null || isColumnHeaderExist) {
            writer.startElement("thead", tableHeader);
            if (tableHeader != null) {
                writer.startElement("tr", tableHeader);
                writer.startElement("th", tableHeader);
                RendererUtil.renderAttribute(writer, "colspan", new Integer(columns.size()));
                writer.writeAttribute("scope", "colgroup", null);
                RendererUtil.renderAttribute(writer, "class", htmlDataTable.getHeaderClass(), "headerClass");
                this.encodeComponent(context, tableHeader);
                writer.endElement("th");
                writer.endElement("tr");
            }
            if (isColumnHeaderExist) {
                writer.startElement("tr", tableHeader);
                it = columns.iterator();
                while (it.hasNext()) {
                    writer.startElement("th", tableHeader);
                    writer.writeAttribute("colgroup", "col", null);
                    RendererUtil.renderAttribute(writer, "class", htmlDataTable.getHeaderClass(), "headerClass");
                    column = (UIColumn)it.next();
                    columnHeader = column.getHeader();
                    if (columnHeader != null) {
                        this.encodeComponent(context, columnHeader);
                    }
                    writer.endElement("th");
                }
                writer.endElement("tr");
            }
            writer.endElement("thead");
        }
        if ((tableFooter = this.toNullIfNotRendered(htmlDataTable.getFooter())) != null || isColumnFooterExist) {
            writer.startElement("tfoot", tableFooter);
            if (tableFooter != null) {
                writer.startElement("tr", tableFooter);
                writer.startElement("td", tableFooter);
                RendererUtil.renderAttribute(writer, "colspan", new Integer(columns.size()));
                RendererUtil.renderAttribute(writer, "class", htmlDataTable.getFooterClass(), "footerClass");
                this.encodeComponent(context, tableFooter);
                writer.endElement("td");
                writer.endElement("tr");
            }
            if (isColumnFooterExist) {
                writer.startElement("tr", tableFooter);
                it = columns.iterator();
                while (it.hasNext()) {
                    writer.startElement("td", tableFooter);
                    RendererUtil.renderAttribute(writer, "class", htmlDataTable.getFooterClass(), "footerClass");
                    column = (UIColumn)it.next();
                    columnFooter = column.getFooter();
                    if (columnFooter != null) {
                        this.encodeComponent(context, columnFooter);
                    }
                    writer.endElement("td");
                }
                writer.endElement("tr");
            }
            writer.endElement("tfoot");
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlDataTableChildren(context, (HtmlDataTable)component);
    }

    protected void encodeHtmlDataTableChildren(FacesContext context, HtmlDataTable htmlDataTable) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("tbody", htmlDataTable);
        LoopIterator rowClasses = this.toStyleLoopIterator(htmlDataTable.getRowClasses());
        LoopIterator columnClasses = this.toStyleLoopIterator(htmlDataTable.getColumnClasses());
        int start = htmlDataTable.getFirst();
        int rows = htmlDataTable.getRows();
        boolean allRow = true;
        if (0 < rows) {
            allRow = false;
        }
        htmlDataTable.setRowIndex(start);
        int rowIndex = start;
        while ((allRow || 0 < rows) && htmlDataTable.isRowAvailable()) {
            this.encodeBodyRow(context, htmlDataTable, writer, rowClasses, columnClasses);
            --rows;
            htmlDataTable.setRowIndex(++rowIndex);
        }
        writer.endElement("tbody");
    }

    private void encodeBodyRow(FacesContext context, HtmlDataTable htmlDataTable, ResponseWriter writer, Iterator rowClasses, LoopIterator columnClasses) throws IOException {
        writer.startElement("tr", htmlDataTable);
        if (rowClasses.hasNext()) {
            RendererUtil.renderAttribute(writer, "class", rowClasses.next(), "rowClasses");
        }
        columnClasses.reset();
        Iterator itColumn = this.getRenderedChildrenIterator(htmlDataTable);
        while (itColumn.hasNext()) {
            UIComponent col = (UIComponent)itColumn.next();
            if (!(col instanceof UIColumn)) continue;
            UIColumn column = (UIColumn)col;
            this.encodeBodyRowColumn(context, column, writer, columnClasses);
        }
        writer.endElement("tr");
    }

    private void encodeBodyRowColumn(FacesContext context, UIColumn column, ResponseWriter writer, Iterator columnClasses) throws IOException {
        writer.startElement("td", column);
        if (columnClasses.hasNext()) {
            RendererUtil.renderAttribute(writer, "class", columnClasses.next(), "columnClasses");
        }
        this.encodeDescendantComponent(context, column);
        writer.endElement("td");
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlDataTableEnd(context, (HtmlDataTable)component);
    }

    protected void encodeHtmlDataTableEnd(FacesContext context, HtmlDataTable htmlDataTable) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("table");
    }

    public boolean getRendersChildren() {
        return true;
    }
}

