/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import java.io.IOException;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlMessages;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.seasar.teeda.core.render.html.AbstractHtmlMessagesRenderer;
import org.seasar.teeda.core.util.RendererUtil;

public class HtmlMessagesRenderer
extends AbstractHtmlMessagesRenderer {
    public static final String COMPONENT_FAMILY = "javax.faces.Messages";
    public static final String RENDERER_TYPE = "javax.faces.Messages";

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlMessagesEnd(context, (HtmlMessages)component);
    }

    protected void encodeHtmlMessagesEnd(FacesContext context, HtmlMessages htmlMessages) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Iterator it = htmlMessages.isGlobalOnly() ? context.getMessages(null) : context.getMessages();
        if (!it.hasNext()) {
            return;
        }
        boolean tableLayout = this.isTableLayout(htmlMessages);
        if (tableLayout) {
            writer.startElement("table", htmlMessages);
        } else {
            writer.startElement("ul", htmlMessages);
        }
        RendererUtil.renderIdAttributeIfNecessary(writer, htmlMessages, this.getIdForRender(context, htmlMessages));
        while (it.hasNext()) {
            if (tableLayout) {
                writer.startElement("tr", htmlMessages);
                writer.startElement("td", htmlMessages);
            } else {
                writer.startElement("li", htmlMessages);
            }
            FacesMessage facesMassage = (FacesMessage)it.next();
            this.renderOneMessage(context, htmlMessages, facesMassage, null, htmlMessages.getAttributes());
            if (tableLayout) {
                writer.endElement("td");
                writer.endElement("tr");
                continue;
            }
            writer.endElement("li");
        }
        if (tableLayout) {
            writer.endElement("table");
        } else {
            writer.endElement("ul");
        }
    }

    private boolean isTableLayout(HtmlMessages htmlMessages) {
        return "table".equals(htmlMessages.getLayout());
    }
}

