/*
 * Decompiled with CFR 0.152.
 */
package jcifs.netbios;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import jcifs.Config;
import jcifs.netbios.Lmhosts;
import jcifs.netbios.Log;
import jcifs.netbios.Name;
import jcifs.netbios.NameQueryRequest;
import jcifs.netbios.NameQueryResponse;
import jcifs.netbios.NameServicePacket;
import jcifs.netbios.NbtAddress;
import jcifs.netbios.NodeStatusRequest;
import jcifs.netbios.NodeStatusResponse;

class NameServiceClient
implements Runnable {
    static final int DEFAULT_SO_TIMEOUT = 5000;
    static final int DEFAULT_RCV_BUF_SIZE = 576;
    static final int DEFAULT_SND_BUF_SIZE = 576;
    static final int NAME_SERVICE_UDP_PORT = 137;
    static final int DEFAULT_RETRY_COUNT = 2;
    static final int DEFAULT_RETRY_TIMEOUT = 3000;
    static final int RESOLVER_LMHOSTS = 1;
    static final int RESOLVER_BCAST = 2;
    static final int RESOLVER_WINS = 3;
    InetAddress laddr;
    InetAddress baddr;
    InetAddress nbns;
    int port;
    int soTimeout;
    int retryCount;
    int retryTimeout;
    int closeTimeout;
    int snd_buf_size;
    int rcv_buf_size;
    byte[] snd_buf;
    byte[] rcv_buf;
    DatagramSocket socket;
    DatagramPacket in;
    DatagramPacket out;
    Hashtable responseTable;
    Thread thread;
    int nextNameTrnId;
    Object socketLock;
    int[] resolveOrder;

    NameServiceClient() {
        this(Config.getInt("jcifs.netbios.lport", 0), Config.getInetAddress("jcifs.netbios.laddr", null));
    }

    NameServiceClient(int port, InetAddress laddr) {
        this.port = port;
        this.laddr = laddr;
        try {
            this.baddr = Config.getInetAddress("jcifs.netbios.baddr", InetAddress.getByName("255.255.255.255"));
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        this.nbns = Config.getInetAddress("jcifs.netbios.wins", null);
        this.soTimeout = Config.getInt("jcifs.netbios.soTimeout", 5000);
        this.retryCount = Config.getInt("jcifs.netbios.retryCount", 2);
        this.retryTimeout = Config.getInt("jcifs.netbios.retryTimeout", 3000);
        this.rcv_buf_size = Config.getInt("jcifs.netbios.rcv_buf_size", 576);
        this.snd_buf_size = Config.getInt("jcifs.netbios.snd_buf_size", 576);
        this.rcv_buf = new byte[this.rcv_buf_size];
        this.snd_buf = new byte[this.snd_buf_size];
        this.in = new DatagramPacket(this.rcv_buf, this.rcv_buf_size);
        this.out = new DatagramPacket(this.snd_buf, this.snd_buf_size, this.baddr, 137);
        this.responseTable = new Hashtable();
        this.nextNameTrnId = 0;
        this.socketLock = new Object();
        String ro = Config.getProperty("jcifs.resolveOrder");
        if (ro == null || ro.length() == 0) {
            if (this.nbns == null) {
                this.resolveOrder = new int[2];
                this.resolveOrder[0] = 1;
                this.resolveOrder[1] = 2;
            } else {
                this.resolveOrder = new int[3];
                this.resolveOrder[0] = 1;
                this.resolveOrder[1] = 3;
                this.resolveOrder[2] = 2;
            }
        } else {
            int[] tmp = new int[3];
            StringTokenizer st = new StringTokenizer(ro, ",");
            int i = 0;
            while (st.hasMoreTokens()) {
                String s = st.nextToken().trim();
                if (s.equalsIgnoreCase("LMHOSTS")) {
                    tmp[i++] = 1;
                    continue;
                }
                if (s.equalsIgnoreCase("WINS")) {
                    if (this.nbns == null) {
                        Log.println(2, "netbios name service warning", " resolveOrder specifies WINS however the jcifs.netbios.wins property has not been set");
                        continue;
                    }
                    tmp[i++] = 3;
                    continue;
                }
                if (s.equalsIgnoreCase("BCAST")) {
                    tmp[i++] = 2;
                    continue;
                }
                if (s.equalsIgnoreCase("DNS")) continue;
                Log.println(2, "netbios name service warning", "unknown resolver method: " + s);
            }
            this.resolveOrder = new int[i];
            System.arraycopy(tmp, 0, this.resolveOrder, 0, i);
        }
    }

    int getNextNameTrnId() {
        if ((++this.nextNameTrnId & 0xFFFF) == 0) {
            this.nextNameTrnId = 1;
        }
        return this.nextNameTrnId;
    }

    void ensureOpen(int timeout) throws IOException {
        this.closeTimeout = 0;
        if (this.soTimeout != 0) {
            this.closeTimeout = Math.max(this.soTimeout, timeout);
        }
        if (this.socket == null) {
            this.socket = new DatagramSocket(this.port, this.laddr);
            this.thread = new Thread((Runnable)this, "JCIFS-NameServiceClient");
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tryClose() {
        Object object = this.socketLock;
        synchronized (object) {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
            this.thread = null;
            this.responseTable.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.thread == Thread.currentThread()) {
            this.in.setLength(this.rcv_buf_size);
            try {
                this.socket.setSoTimeout(this.closeTimeout);
                this.socket.receive(this.in);
            }
            catch (IOException ioe) {
                this.tryClose();
                break;
            }
            Log.println(4, "nbt name service debugging", " new data read from socket");
            int nameTrnId = NameServicePacket.readNameTrnId(this.rcv_buf, 0);
            NameServicePacket response = (NameServicePacket)this.responseTable.get(new Integer(nameTrnId));
            if (response == null || response.received) continue;
            NameServicePacket nameServicePacket = response;
            synchronized (nameServicePacket) {
                response.readWireFormat(this.rcv_buf, 0);
                response.received = true;
                Log.printPacketData("nbt name service packet receviced", response);
                Log.printHexDump("datagram packet received from: " + this.in.getAddress().getHostAddress(), this.rcv_buf, 0, this.in.getLength());
                response.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void send(NameServicePacket request, NameServicePacket response, int timeout) throws IOException {
        Integer nid = null;
        NameServicePacket nameServicePacket = response;
        synchronized (nameServicePacket) {
            block8: {
                try {
                    try {
                        Object object = this.socketLock;
                        synchronized (object) {
                            request.nameTrnId = this.getNextNameTrnId();
                            nid = new Integer(request.nameTrnId);
                            this.out.setAddress(request.addr);
                            this.out.setLength(request.writeWireFormat(this.snd_buf, 0));
                            response.received = false;
                            this.responseTable.put(nid, response);
                            this.ensureOpen(timeout + 1000);
                            this.socket.send(this.out);
                            Log.printPacketData("nbt name service packet sent", request);
                            Log.printHexDump("datagram packet sent to: " + this.out.getAddress().getHostAddress(), this.snd_buf, 0, this.out.getLength());
                        }
                        response.wait(timeout);
                    }
                    catch (InterruptedException ie) {
                        Object var9_9 = null;
                        this.responseTable.remove(nid);
                        break block8;
                    }
                    Object var9_8 = null;
                    this.responseTable.remove(nid);
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    this.responseTable.remove(nid);
                    throw throwable;
                }
            }
            return;
        }
    }

    NbtAddress getByName(Name name, InetAddress addr) throws UnknownHostException {
        NameQueryRequest request = new NameQueryRequest(name);
        NameQueryResponse response = new NameQueryResponse();
        if (addr != null) {
            request.addr = addr;
            request.isBroadcast = addr.getAddress()[3] == -1;
            int n = this.retryCount;
            do {
                try {
                    this.send(request, response, this.retryTimeout);
                }
                catch (IOException ioe) {
                    Log.printStackTrace("nbt name service send:", ioe);
                    throw new UnknownHostException(ioe.getMessage());
                }
                if (!response.received || response.resultCode != 0) continue;
                response.addrEntry.hostName.srcHashCode = addr.hashCode();
                return response.addrEntry;
            } while (--n > 0 && request.isBroadcast);
            throw new UnknownHostException(name.toString());
        }
        int i = 0;
        while (i < this.resolveOrder.length) {
            block18: {
                try {
                    switch (this.resolveOrder[i]) {
                        case 1: {
                            NbtAddress ans = Lmhosts.getByName(name);
                            if (ans == null) break;
                            ans.hostName.srcHashCode = 0;
                            return ans;
                        }
                        case 2: 
                        case 3: {
                            if (this.resolveOrder[i] == 3 && name.name != "\u0001\u0002__MSBROWSE__\u0002" && name.hexCode != 29) {
                                request.addr = this.nbns;
                                request.isBroadcast = false;
                            } else {
                                request.addr = this.baddr;
                                request.isBroadcast = true;
                            }
                            int n = this.retryCount;
                            while (n-- > 0) {
                                try {
                                    this.send(request, response, this.retryTimeout);
                                }
                                catch (IOException ioe) {
                                    Log.printStackTrace("nbt name service send:", ioe);
                                    throw new UnknownHostException(ioe.getMessage());
                                }
                                if (response.received && response.resultCode == 0) {
                                    response.addrEntry.hostName.srcHashCode = request.addr.hashCode();
                                    return response.addrEntry;
                                }
                                if (this.resolveOrder[i] != 3) {
                                    continue;
                                }
                                break block18;
                            }
                            break;
                        }
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            ++i;
        }
        throw new UnknownHostException(name.name);
    }

    NbtAddress[] getNodeStatus(NbtAddress addr) throws UnknownHostException {
        NodeStatusResponse response = new NodeStatusResponse(addr);
        NodeStatusRequest request = new NodeStatusRequest(new Name("*\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000", 0, null));
        request.addr = addr.getInetAddress();
        int n = this.retryCount;
        while (n-- > 0) {
            try {
                this.send(request, response, this.retryTimeout);
            }
            catch (IOException ioe) {
                Log.printStackTrace("nbt name service send:", ioe);
                throw new UnknownHostException(ioe.getMessage());
            }
            if (!response.received || response.resultCode != 0) continue;
            int srcHashCode = request.addr.hashCode();
            int i = 0;
            while (i < response.addressArray.length) {
                response.addressArray[i].hostName.srcHashCode = srcHashCode;
                ++i;
            }
            return response.addressArray;
        }
        throw new UnknownHostException(addr.hostName.name);
    }
}

