/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import jcifs.Config;
import jcifs.smb.AndXServerMessageBlock;
import jcifs.smb.Log;
import jcifs.smb.ServerMessageBlock;

class SmbComOpenAndX
extends AndXServerMessageBlock {
    static final int FLAGS_RETURN_ADDITIONAL_INFO = 1;
    static final int FLAGS_REQUEST_OPLOCK = 2;
    static final int FLAGS_REQUEST_BATCH_OPLOCK = 4;
    static final int SHARING_COMPATIBILITY = 0;
    static final int SHARING_DENY_READ_WRITE_EXECUTE = 16;
    static final int SHARING_DENY_WRITE = 32;
    static final int SHARING_DENY_READ_EXECUTE = 48;
    static final int SHARING_DENY_NONE = 64;
    static final int DO_NOT_CACHE = 4096;
    static final int WRITE_THROUGH = 16384;
    static final int OPEN_FN_CREATE = 16;
    static final int OPEN_FN_FAIL_IF_EXISTS = 0;
    static final int OPEN_FN_OPEN = 1;
    static final int OPEN_FN_TRUNC = 2;
    static final int BATCH_LIMIT = Config.getInt("jcifs.smb.client.OpenAndX.ReadAndX", 1);
    int flags;
    int desiredAccess;
    int searchAttributes;
    int fileAttributes;
    int creationTime;
    int openFunction;
    int allocationSize;

    SmbComOpenAndX(String fileName, int flags, ServerMessageBlock andx) {
        super(andx);
        this.path = fileName;
        this.command = (byte)45;
        this.desiredAccess = flags >>> 16 & 3;
        if (this.desiredAccess == 3) {
            this.desiredAccess = 2;
        }
        this.desiredAccess |= 0x40;
        this.desiredAccess &= 0xFFFFFFFE;
        this.searchAttributes = 22;
        this.fileAttributes = 0;
        this.openFunction = (flags & 2) == 2 ? ((flags & 0x10) == 16 ? 18 : 2) : ((flags & 0x10) == 16 ? ((flags & 1) == 1 ? 16 : 17) : 1);
    }

    int getBatchLimit(byte command) {
        return command == 46 ? BATCH_LIMIT : 0;
    }

    int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        ServerMessageBlock.writeInt2(this.flags, dst, dstIndex);
        ServerMessageBlock.writeInt2(this.desiredAccess, dst, dstIndex += 2);
        ServerMessageBlock.writeInt2(this.searchAttributes, dst, dstIndex += 2);
        ServerMessageBlock.writeInt2(this.fileAttributes, dst, dstIndex += 2);
        this.creationTime = 0;
        ServerMessageBlock.writeInt4(this.creationTime, dst, dstIndex += 2);
        ServerMessageBlock.writeInt2(this.openFunction, dst, dstIndex += 4);
        ServerMessageBlock.writeInt4(this.allocationSize, dst, dstIndex += 2);
        dstIndex += 4;
        int i = 0;
        while (i < 8) {
            dst[dstIndex++] = 0;
            ++i;
        }
        return dstIndex - start;
    }

    int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        if (this.useUnicode) {
            dst[dstIndex++] = 0;
        }
        dstIndex += this.writeString(this.path, dst, dstIndex);
        return dstIndex - start;
    }

    int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    int readBytesDirectWireFormat(InputStream in, int byteCount) throws IOException {
        return 0;
    }

    public String toString() {
        return new String("SmbComOpenAndX[" + super.toString() + ",flags=0x" + Log.getHexString(this.flags, 2) + ",desiredAccess=0x" + Log.getHexString(this.desiredAccess, 4) + ",searchAttributes=0x" + Log.getHexString(this.searchAttributes, 4) + ",fileAttributes=0x" + Log.getHexString(this.fileAttributes, 4) + ",creationTime=" + new Date(this.creationTime) + ",openFunction=0x" + Log.getHexString(this.openFunction, 2) + ",allocationSize=" + this.allocationSize + ",fileName=" + this.path + "]");
    }
}

