/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.util.Enumeration;
import jcifs.smb.FileEntry;
import jcifs.smb.Log;
import jcifs.smb.ServerMessageBlock;

abstract class SmbComTransactionResponse
extends ServerMessageBlock
implements Enumeration {
    static final int SETUP_OFFSET = 61;
    static final int DISCONNECT_TID = 1;
    static final int ONE_WAY_TRANSACTION = 2;
    int totalParameterCount;
    int totalDataCount;
    int parameterCount;
    int parameterOffset;
    int parameterDisplacement;
    int dataCount;
    int dataOffset;
    int dataDisplacement;
    int setupCount;
    byte subCommand;
    int pad;
    int pad1;
    boolean hasMore = true;
    boolean isPrimary = true;
    boolean parametersDone;
    boolean dataDone;
    byte[] txn_buf = null;
    int bufParameterStart;
    int bufDataStart;
    int status;
    int numEntries;
    FileEntry[] results;

    SmbComTransactionResponse() {
    }

    public void reset() {
        this.bufDataStart = 0;
        this.hasMore = true;
        this.isPrimary = true;
        this.dataDone = false;
        this.parametersDone = false;
    }

    public boolean hasMoreElements() {
        return this.hasMore;
    }

    public Object nextElement() {
        if (this.isPrimary) {
            this.isPrimary = false;
        }
        return this;
    }

    int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    int writeBytesWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        int start = bufferIndex;
        this.totalParameterCount = ServerMessageBlock.readInt2(buffer, bufferIndex);
        if (this.bufDataStart == 0) {
            this.bufDataStart = this.totalParameterCount;
        }
        this.totalDataCount = ServerMessageBlock.readInt2(buffer, bufferIndex += 2);
        this.parameterCount = ServerMessageBlock.readInt2(buffer, bufferIndex += 4);
        this.parameterOffset = ServerMessageBlock.readInt2(buffer, bufferIndex += 2);
        this.parameterDisplacement = ServerMessageBlock.readInt2(buffer, bufferIndex += 2);
        this.dataCount = ServerMessageBlock.readInt2(buffer, bufferIndex += 2);
        this.dataOffset = ServerMessageBlock.readInt2(buffer, bufferIndex += 2);
        this.dataDisplacement = ServerMessageBlock.readInt2(buffer, bufferIndex += 2);
        this.setupCount = buffer[bufferIndex += 2] & 0xFF;
        bufferIndex += 2;
        if (this.setupCount != 0) {
            Log.println(2, "smb transaction response", "setupCount is not zero: " + this.setupCount);
        }
        return bufferIndex - start;
    }

    int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        this.pad1 = 0;
        this.pad = 0;
        if (this.parameterCount > 0) {
            this.pad = this.parameterOffset - (bufferIndex - this.headerStart);
            System.arraycopy(buffer, bufferIndex += this.pad, this.txn_buf, this.bufParameterStart + this.parameterDisplacement, this.parameterCount);
            bufferIndex += this.parameterCount;
        }
        if (this.dataCount > 0) {
            this.pad1 = this.dataOffset - (bufferIndex - this.headerStart);
            System.arraycopy(buffer, bufferIndex += this.pad1, this.txn_buf, this.bufDataStart + this.dataDisplacement, this.dataCount);
            bufferIndex += this.dataCount;
        }
        if (!this.parametersDone && this.parameterDisplacement + this.parameterCount == this.totalParameterCount) {
            this.parametersDone = true;
        }
        if (!this.dataDone && this.dataDisplacement + this.dataCount == this.totalDataCount) {
            this.dataDone = true;
        }
        if (this.parametersDone && this.dataDone) {
            this.hasMore = false;
            this.readParametersWireFormat(this.txn_buf, this.bufParameterStart, this.totalParameterCount);
            this.readDataWireFormat(this.txn_buf, this.bufDataStart, this.totalDataCount);
        }
        return this.pad + this.parameterCount + this.pad1 + this.dataCount;
    }

    abstract int writeSetupWireFormat(byte[] var1, int var2);

    abstract int writeParametersWireFormat(byte[] var1, int var2);

    abstract int writeDataWireFormat(byte[] var1, int var2);

    abstract int readSetupWireFormat(byte[] var1, int var2, int var3);

    abstract int readParametersWireFormat(byte[] var1, int var2, int var3);

    abstract int readDataWireFormat(byte[] var1, int var2, int var3);

    public String toString() {
        return new String(super.toString() + ",totalParameterCount=" + this.totalParameterCount + ",totalDataCount=" + this.totalDataCount + ",parameterCount=" + this.parameterCount + ",parameterOffset=" + this.parameterOffset + ",parameterDisplacement=" + this.parameterDisplacement + ",dataCount=" + this.dataCount + ",dataOffset=" + this.dataOffset + ",dataDisplacement=" + this.dataDisplacement + ",setupCount=" + this.setupCount + ",pad=" + this.pad + ",pad1=" + this.pad1);
    }
}

