/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import jcifs.UniAddress;

public class SmbException
extends IOException {
    public static final int SUCCESS = 0;
    public static final int ERRDOS = 1;
    public static final int ERRSRV = 2;
    public static final int ERRHRD = 3;
    public static final int ERRCMD = 255;
    public static final int ERRRAP = 16;
    public static final int ERRCLI = 32;
    public static final int ERRbadfunc = 1;
    public static final int ERRbadfile = 2;
    public static final int ERRbadpath = 3;
    public static final int ERRnoaccess = 5;
    public static final int ERRbadfid = 6;
    public static final int ERRnospace = 8;
    public static final int ERRbadshare = 32;
    public static final int ERRdupname = 52;
    public static final int ERRbadnetname = 67;
    public static final int ERRnomoreconn = 71;
    public static final int ERRbadparm = 87;
    public static final int ERRfilexists = 80;
    public static final int ERRtoomanyuids = 90;
    public static final int ERRbrokenpipe = 109;
    public static final int ERRinvname = 123;
    public static final int ERRnotempty = 145;
    public static final int ERRexists = 183;
    public static final int ERRpipebusy = 231;
    public static final int ERRnodata = 232;
    public static final int ERRnoproc = 233;
    public static final int ERRerror = 1;
    public static final int ERRbadpw = 2;
    public static final int ERRreserved = 3;
    public static final int ERRaccess = 4;
    public static final int ERRinvnid = 5;
    public static final int ERRinvnetname = 6;
    public static final int ERRbaduid = 91;
    public static final int ERRaccountExpired = 2239;
    public static final int ERRbadClient = 2240;
    public static final int ERRbadLogonTime = 2241;
    public static final int ERRpasswordExpired = 2242;
    public static final int ERRnolisting = 6118;
    public static final int ERRnowrite = 19;
    public static final int ERRnotready = 21;
    public static final int ERRgeneral = 31;
    public static final int NERR_Success = 0;
    public static final int ERROR_MORE_DATA = 234;
    public static final int NERR_ServerNotStarted = 2114;
    public static final int NERR_BasicTransactConfig = 2141;
    public static final int ERRserverTimeout = 5000;
    public static final int ERRbadDialect = 5001;
    public static final int ERRioe = 5002;
    public static final int ERRlistFiles = 5003;
    public static final int ERRunknownHost = 5004;
    public static final int ERRinappro = 5005;
    public static final int ERRunknownType = 5006;
    public static final int ERRdfs = 5007;
    public static final int ERRhashesExternal = 5008;
    public static final int ERRimpossible = 5009;
    int errorClass;
    int errorCode;

    static String getErrorString(int errorClass, int errorCode) {
        String result = "";
        block0 : switch (errorClass) {
            case 0: {
                result = result + "The operation completed successfully";
                break;
            }
            case 1: {
                switch (errorCode) {
                    case 1: {
                        result = result + "Invalid function";
                        break block0;
                    }
                    case 2: {
                        result = result + "File not found";
                        break block0;
                    }
                    case 3: {
                        result = result + "Directory invalid";
                        break block0;
                    }
                    case 5: {
                        result = result + "Access denied";
                        break block0;
                    }
                    case 87: {
                        result = result + "Invalid parameter";
                        break block0;
                    }
                    case 123: {
                        result = result + "Invalid name";
                        break block0;
                    }
                    case 145: {
                        result = result + "The directory is not empty";
                        break block0;
                    }
                    case 80: {
                        result = result + "Cannot create a file when that file already exists";
                        break block0;
                    }
                    case 6: {
                        result = result + "Invalid file handle";
                        break block0;
                    }
                    case 8: {
                        result = result + "Not enough storage is available to process this command";
                        break block0;
                    }
                    case 32: {
                        result = result + "The file is being used by another process";
                        break block0;
                    }
                    case 52: {
                        result = result + "A duplicate name exists on the network";
                        break block0;
                    }
                    case 21: {
                        result = result + "The device is not ready";
                        break block0;
                    }
                    case 67: {
                        result = result + "The network name cannot be found";
                        break block0;
                    }
                    case 183: {
                        result = result + "File exists";
                        break block0;
                    }
                    case 231: {
                        result = result + "All pipe instances are busy";
                        break block0;
                    }
                    case 232: {
                        result = result + "The pipe is being closed";
                        break block0;
                    }
                    case 233: {
                        result = result + "No process is on the other end of the pipe";
                        break block0;
                    }
                    case 109: {
                        result = result + "The pipe has been ended";
                        break block0;
                    }
                    case 71: {
                        result = result + "No more connections can be made to this remote computer at this time because there are already as many connections as the computer can accept";
                        break block0;
                    }
                }
                result = result + "No description available [ERRDOS/" + errorCode + "]";
                break;
            }
            case 2: {
                switch (errorCode) {
                    case 1: {
                        result = result + "Non-specific error code";
                        break block0;
                    }
                    case 2: {
                        result = result + "Bad password";
                        break block0;
                    }
                    case 3: {
                        result = result + "Reserved";
                        break block0;
                    }
                    case 5: {
                        result = result + "The Tid specified was invalid";
                        break block0;
                    }
                    case 6: {
                        result = result + "Invalid network name in tree connect, service not found";
                        break block0;
                    }
                    case 91: {
                        result = result + "The UID is not known as a valid user identifier on this session";
                        break block0;
                    }
                    case 4: {
                        result = result + "The client does not have the necessary access rights for the requested function";
                        break block0;
                    }
                    case 2239: {
                        result = result + "The user account has expired";
                        break block0;
                    }
                    case 2240: {
                        result = result + "The user is not allowed to access this server from this client";
                        break block0;
                    }
                    case 2241: {
                        result = result + "The user is not permitted to access the server at this time";
                        break block0;
                    }
                    case 2242: {
                        result = result + "The password of the user has expired";
                        break block0;
                    }
                    case 90: {
                        result = result + "Too many Uids active on this session";
                        break block0;
                    }
                }
                result = result + "No description available [ERRSRV/" + errorCode + "]";
                break;
            }
            case 3: {
                switch (errorCode) {
                    case 19: {
                        result = result + "Attempt to write on write-protected media";
                        break block0;
                    }
                    case 21: {
                        result = result + "The device is not ready";
                        break block0;
                    }
                    case 31: {
                        result = result + "General failure";
                        break block0;
                    }
                }
                result = result + "No description available [ERRHRD/" + errorCode + "]";
                break;
            }
            case 255: {
                result = result + "Command was not in the \"SMB\" format";
                break;
            }
            case 16: {
                switch (errorCode) {
                    case 0: {
                        result = result + "The operation completed successfully";
                        break block0;
                    }
                    case 19: {
                        result = result + "The Server service is not started";
                        break block0;
                    }
                    case 2141: {
                        result = result + "The server is not configured for transactions";
                        break block0;
                    }
                    case 6118: {
                        result = result + "The list of servers for this workgroup is not currently available";
                        break block0;
                    }
                }
                result = result + "No description available [ERRRAP/" + errorCode + "]";
                break;
            }
            case 32: {
                switch (errorCode) {
                    case 5000: {
                        result = result + "Timeout waiting for response from server.";
                        break block0;
                    }
                    case 5001: {
                        result = result + "Failed to negotiate dialect with server.";
                        break block0;
                    }
                    case 5002: {
                        result = result + "An IO error occured.";
                        break block0;
                    }
                    case 5003: {
                        result = result + "The derived URL was malformed or a name service error occured during a listFiles() operation (this should not be possible, please report it to jcifs at samba dot org)";
                        break block0;
                    }
                    case 5004: {
                        result = result + "The hostname retrived from the Browser service is no longer valid";
                        break block0;
                    }
                    case 5005: {
                        result = result + "Inappropriate operation";
                        break block0;
                    }
                    case 5006: {
                        result = result + "Unknown resource type";
                        break block0;
                    }
                    case 5007: {
                        result = result + "Invalid DFS operation";
                        break block0;
                    }
                    case 5008: {
                        result = result + "The password hashes are external.";
                        break block0;
                    }
                }
                result = result + "No description available [ERRCLI/" + errorCode + "]";
                break;
            }
            default: {
                result = result + "unknown error class: " + errorClass;
            }
        }
        return result;
    }

    static String getErrorString(int code) {
        if (code == 0) {
            return "0x00000000";
        }
        return SmbException.getErrorString(code & 0xFF, code >> 16 & 0xFFFF);
    }

    SmbException() {
    }

    SmbException(int code) {
        super(SmbException.getErrorString(code & 0xFF, code >> 16 & 0xFFFF));
        this.errorClass = code & 0xFF;
        this.errorCode = code >> 16 & 0xFFFF;
    }

    SmbException(int errorClass, int errorCode) {
        super(SmbException.getErrorString(errorClass, errorCode));
        this.errorClass = errorClass;
        this.errorCode = errorCode;
    }

    SmbException(int errorClass, int errorCode, UniAddress addr) {
        super(SmbException.getErrorString(errorClass, errorCode) + " " + addr.toString());
        this.errorClass = errorClass;
        this.errorCode = errorCode;
    }

    SmbException(int errorClass, int errorCode, String message) {
        super(message);
        this.errorClass = errorClass;
        this.errorCode = errorCode;
    }

    SmbException(int code, String message) {
        super(message);
        this.errorClass = code & 0xFF;
        this.errorCode = code >> 16 & 0xFFFF;
    }

    public int getErrorClass() {
        return this.errorClass;
    }

    public int getErrorCode() {
        return this.errorCode;
    }
}

