/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;
import jcifs.UniAddress;
import jcifs.smb.Log;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.ServerMessageBlock;
import jcifs.smb.SmbComLogoffAndX;
import jcifs.smb.SmbComSessionSetupAndX;
import jcifs.smb.SmbComSessionSetupAndXResponse;
import jcifs.smb.SmbComTransaction;
import jcifs.smb.SmbComTransactionResponse;
import jcifs.smb.SmbException;
import jcifs.smb.SmbTransport;
import jcifs.smb.SmbTree;

public final class SmbSession {
    int uid;
    NtlmPasswordAuthentication auth;
    SmbTransport transport;
    Vector trees;
    boolean sessionSetup;

    public static byte[] getChallenge(UniAddress dc) throws SmbException, UnknownHostException {
        SmbTransport trans = SmbTransport.getSmbTransport(dc, 0);
        trans.negotiate();
        return trans.server.encryptionKey;
    }

    public static void logon(UniAddress dc, NtlmPasswordAuthentication auth) throws SmbException {
        SmbTransport.getSmbTransport(dc, 0).getSmbSession(auth).getSmbTree("IPC$", null).treeConnect(null, null);
    }

    SmbSession(SmbTransport transport, NtlmPasswordAuthentication auth) {
        this.transport = transport;
        this.auth = auth;
        this.trees = new Vector();
    }

    synchronized SmbTree getSmbTree(String share, String service) {
        SmbTree t;
        if (share == null) {
            share = "IPC$";
        }
        Enumeration e = this.trees.elements();
        while (e.hasMoreElements()) {
            t = (SmbTree)e.nextElement();
            if (!t.matches(share, service)) continue;
            return t;
        }
        t = new SmbTree(this, share, service);
        this.trees.addElement(t);
        return t;
    }

    boolean matches(NtlmPasswordAuthentication auth) {
        return this.auth == auth || this.auth.equals(auth);
    }

    void sendTransaction(SmbComTransaction request, SmbComTransactionResponse response) throws SmbException {
        this.sessionSetup(null, null);
        request.uid = this.uid;
        request.auth = this.auth;
        this.transport.sendTransaction(request, response);
    }

    void send(ServerMessageBlock request, ServerMessageBlock response) throws SmbException {
        if (response != null) {
            response.received = false;
        }
        this.sessionSetup(request, response);
        if (response != null && response.received) {
            return;
        }
        request.uid = this.uid;
        request.auth = this.auth;
        this.transport.send(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sessionSetup(ServerMessageBlock andx, ServerMessageBlock andxResponse) throws SmbException {
        SmbTransport smbTransport = this.transport;
        synchronized (smbTransport) {
            if (this.sessionSetup) {
                return;
            }
            this.transport.negotiate();
            if (this.transport.useSigning && this.transport.macSigningKey == null && NtlmPasswordAuthentication.NULL != this.auth && !NtlmPasswordAuthentication.NULL.equals(this.auth)) {
                this.transport.initSigning(this.auth);
            }
            Log.println(2, "smb session setup warning", " requesting session with accountName=" + this.auth.username + ",primaryDomain=" + this.auth.domain);
            SmbComSessionSetupAndX request = new SmbComSessionSetupAndX(this, andx);
            SmbComSessionSetupAndXResponse response = new SmbComSessionSetupAndXResponse(andxResponse);
            request.auth = this.auth;
            this.transport.send(request, response);
            this.uid = response.uid;
            this.sessionSetup = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logoff(boolean inError) {
        SmbTransport smbTransport = this.transport;
        synchronized (smbTransport) {
            if (!this.sessionSetup) {
                return;
            }
            Enumeration e = this.trees.elements();
            while (e.hasMoreElements()) {
                SmbTree t = (SmbTree)e.nextElement();
                t.treeDisconnect(inError);
            }
            if (this.transport.server.security == 0) {
                return;
            }
            if (!inError) {
                try {
                    SmbComLogoffAndX request = new SmbComLogoffAndX(null);
                    request.uid = this.uid;
                    this.transport.send(request, null);
                }
                catch (SmbException se) {
                    // empty catch block
                }
            }
            this.sessionSetup = false;
        }
    }

    public String toString() {
        return "SmbSession[accountName=" + this.auth.username + ",primaryDomain=" + this.auth.domain + ",uid=" + this.uid + ",sessionSetup=" + this.sessionSetup + "]";
    }
}

