/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.addresslist.dao;

import java.util.List;

import jp.sf.pal.addresslist.model.Online;

public interface OnlineDao
{
    public Class BEAN = Online.class;

    //add, update, delete
    public void save(Online online);

    public void delete(Online online);

    public void update(Online online);

    public void saveOrUpdate(Online online);

    // By id
    public String getOnlineById_ARGS = "id";

    public Online getOnlineById(long id);

    // All BlogMessage
    public List getAllOnline();

}
