/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.addresslist.model;

// Generated Jan 22, 2006 7:01:34 AM by Hibernate Tools 3.1.0 beta1JBIDERC2

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import jp.sf.pal.addresslist.AddressListConstants;

/**
 * User generated by hbm2java
 */

public class User implements java.io.Serializable
{

    /**
     * 
     */
    private static final long serialVersionUID = -1130337295005646385L;

    // Fields    


    private long id;

    private String owner;

    private Date updatedtime;

    private Date bdate;

    private String gender;

    private String employer;

    private String department;

    private String jobtitle;

    private String nameprefix;

    private String givenname;

    private String familyname;

    private String middlename;

    private String namesuffix;

    private String nickname;

    private Set customs = new HashSet();

    private Set telecoms = new HashSet();

    private Set postals = new HashSet();

    private Set onlines = new HashSet();

    // Constructors

    /** default constructor */
    public User()
    {
    }

    /** minimal constructor */
    public User(long id)
    {
        this.id = id;
    }

    /** full constructor */
    public User(long id, String owner, Date updatedtime, Date bdate, String gender, String employer, String department,
            String jobtitle, String nameprefix, String givenname, String familyname, String middlename,
            String namesuffix, String nickname, Set customs, Set telecoms, Set postals, Set onlines)
    {
        this.id = id;
        this.owner = owner;
        this.updatedtime = updatedtime;
        this.bdate = bdate;
        this.gender = gender;
        this.employer = employer;
        this.department = department;
        this.jobtitle = jobtitle;
        this.nameprefix = nameprefix;
        this.givenname = givenname;
        this.familyname = familyname;
        this.middlename = middlename;
        this.namesuffix = namesuffix;
        this.nickname = nickname;
        this.customs = customs;
        this.telecoms = telecoms;
        this.postals = postals;
        this.onlines = onlines;
    }

    // Property accessors

    public long getId()
    {
        return this.id;
    }

    public void setId(long id)
    {
        this.id = id;
    }

    public String getOwner()
    {
        return this.owner;
    }

    public void setOwner(String owner)
    {
        this.owner = owner;
    }

    public Date getUpdatedtime()
    {
        return this.updatedtime;
    }

    public void setUpdatedtime(Date updatedtime)
    {
        this.updatedtime = updatedtime;
    }

    public Date getBdate()
    {
        return this.bdate;
    }

    public void setBdate(Date bdate)
    {
        this.bdate = bdate;
    }

    public String getGender()
    {
        return this.gender;
    }

    public void setGender(String gender)
    {
        this.gender = gender;
    }

    public String getEmployer()
    {
        return this.employer;
    }

    public void setEmployer(String employer)
    {
        this.employer = employer;
    }

    public String getDepartment()
    {
        return this.department;
    }

    public void setDepartment(String department)
    {
        this.department = department;
    }

    public String getJobtitle()
    {
        return this.jobtitle;
    }

    public void setJobtitle(String jobtitle)
    {
        this.jobtitle = jobtitle;
    }

    public String getNameprefix()
    {
        return this.nameprefix;
    }

    public void setNameprefix(String nameprefix)
    {
        this.nameprefix = nameprefix;
    }

    public String getGivenname()
    {
        return this.givenname;
    }

    public void setGivenname(String givenname)
    {
        this.givenname = givenname;
    }

    public String getFamilyname()
    {
        return this.familyname;
    }

    public void setFamilyname(String familyname)
    {
        this.familyname = familyname;
    }

    public String getMiddlename()
    {
        return this.middlename;
    }

    public void setMiddlename(String middlename)
    {
        this.middlename = middlename;
    }

    public String getNamesuffix()
    {
        return this.namesuffix;
    }

    public void setNamesuffix(String namesuffix)
    {
        this.namesuffix = namesuffix;
    }

    public String getNickname()
    {
        return this.nickname;
    }

    public void setNickname(String nickname)
    {
        this.nickname = nickname;
    }

    public Set getCustoms()
    {
        return this.customs;
    }

    public void setCustoms(Set customs)
    {
        this.customs = customs;
    }

    public Set getTelecoms()
    {
        return this.telecoms;
    }

    public void setTelecoms(Set telecoms)
    {
        this.telecoms = telecoms;
    }

    public Set getPostals()
    {
        return this.postals;
    }

    public void setPostals(Set postals)
    {
        this.postals = postals;
    }

    public Set getOnlines()
    {
        return this.onlines;
    }

    public void setOnlines(Set onlines)
    {
        this.onlines = onlines;
    }

    public Postal getHomePostal()
    {
        Iterator ite = getPostals().iterator();
        while (ite.hasNext())
        {
            Postal postal = (Postal) ite.next();
            if (postal.getInfotype().equals(AddressListConstants.INFOTYPE_HOME))
            {
                return postal;
            }
        }
        return null;
    }

    public Postal getBusinessPostal()
    {
        Iterator ite = getPostals().iterator();
        while (ite.hasNext())
        {
            Postal postal = (Postal) ite.next();
            if (postal.getInfotype().equals(AddressListConstants.INFOTYPE_BUSINESS))
            {
                return postal;
            }
        }
        return null;
    }

    public Telecom getHomeTelephone()
    {
        Iterator ite = getTelecoms().iterator();
        while (ite.hasNext())
        {
            Telecom telecom = (Telecom) ite.next();
            if (telecom.getInfotype().equals(AddressListConstants.INFOTYPE_HOME))
            {
                if (telecom.getTelecomtype().equals(AddressListConstants.TELECOMTYPE_TELEPHONE))
                {
                    return telecom;
                }
            }
        }
        return null;
    }

    public Telecom getHomeFax()
    {
        Iterator ite = getTelecoms().iterator();
        while (ite.hasNext())
        {
            Telecom telecom = (Telecom) ite.next();
            if (telecom.getInfotype().equals(AddressListConstants.INFOTYPE_HOME))
            {
                if (telecom.getTelecomtype().equals(AddressListConstants.TELECOMTYPE_FAX))
                {
                    return telecom;
                }
            }
        }
        return null;
    }

    public Telecom getHomeMobile()
    {
        Iterator ite = getTelecoms().iterator();
        while (ite.hasNext())
        {
            Telecom telecom = (Telecom) ite.next();
            if (telecom.getInfotype().equals(AddressListConstants.INFOTYPE_HOME))
            {
                if (telecom.getTelecomtype().equals(AddressListConstants.TELECOMTYPE_MOBILE))
                {
                    return telecom;
                }
            }
        }
        return null;
    }

    public Telecom getHomePager()
    {
        Iterator ite = getTelecoms().iterator();
        while (ite.hasNext())
        {
            Telecom telecom = (Telecom) ite.next();
            if (telecom.getInfotype().equals(AddressListConstants.INFOTYPE_HOME))
            {
                if (telecom.getTelecomtype().equals(AddressListConstants.TELECOMTYPE_PAGER))
                {
                    return telecom;
                }
            }
        }
        return null;
    }

    public Telecom getBusinessTelephone()
    {
        Iterator ite = getTelecoms().iterator();
        while (ite.hasNext())
        {
            Telecom telecom = (Telecom) ite.next();
            if (telecom.getInfotype().equals(AddressListConstants.INFOTYPE_BUSINESS))
            {
                if (telecom.getTelecomtype().equals(AddressListConstants.TELECOMTYPE_TELEPHONE))
                {
                    return telecom;
                }
            }
        }
        return null;
    }

    public Telecom getBusinessFax()
    {
        Iterator ite = getTelecoms().iterator();
        while (ite.hasNext())
        {
            Telecom telecom = (Telecom) ite.next();
            if (telecom.getInfotype().equals(AddressListConstants.INFOTYPE_BUSINESS))
            {
                if (telecom.getTelecomtype().equals(AddressListConstants.TELECOMTYPE_FAX))
                {
                    return telecom;
                }
            }
        }
        return null;
    }

    public Telecom getBusinessMobile()
    {
        Iterator ite = getTelecoms().iterator();
        while (ite.hasNext())
        {
            Telecom telecom = (Telecom) ite.next();
            if (telecom.getInfotype().equals(AddressListConstants.INFOTYPE_BUSINESS))
            {
                if (telecom.getTelecomtype().equals(AddressListConstants.TELECOMTYPE_MOBILE))
                {
                    return telecom;
                }
            }
        }
        return null;
    }

    public Telecom getBusinessPager()
    {
        Iterator ite = getTelecoms().iterator();
        while (ite.hasNext())
        {
            Telecom telecom = (Telecom) ite.next();
            if (telecom.getInfotype().equals(AddressListConstants.INFOTYPE_BUSINESS))
            {
                if (telecom.getTelecomtype().equals(AddressListConstants.TELECOMTYPE_PAGER))
                {
                    return telecom;
                }
            }
        }
        return null;
    }

    public Online getHomeEmail1()
    {
        Iterator ite = getOnlines().iterator();
        while (ite.hasNext())
        {
            Online online = (Online) ite.next();
            if (online.getInfotype().equals(AddressListConstants.INFOTYPE_HOME))
            {
                if (online.getOnlinetype().equals(AddressListConstants.ONLINETYPE_EMAIL))
                {
                    if (online.getNum().intValue() == 0)
                    {
                        return online;
                    }
                }
            }
        }
        return null;
    }

    public Online getHomeEmail2()
    {
        Iterator ite = getOnlines().iterator();
        while (ite.hasNext())
        {
            Online online = (Online) ite.next();
            if (online.getInfotype().equals(AddressListConstants.INFOTYPE_HOME))
            {
                if (online.getOnlinetype().equals(AddressListConstants.ONLINETYPE_EMAIL))
                {
                    if (online.getNum().intValue() == 1)
                    {
                        return online;
                    }
                }
            }
        }
        return null;
    }

    public Online getHomeEmail3()
    {
        Iterator ite = getOnlines().iterator();
        while (ite.hasNext())
        {
            Online online = (Online) ite.next();
            if (online.getInfotype().equals(AddressListConstants.INFOTYPE_HOME))
            {
                if (online.getOnlinetype().equals(AddressListConstants.ONLINETYPE_EMAIL))
                {
                    if (online.getNum().intValue() == 2)
                    {
                        return online;
                    }
                }
            }
        }
        return null;
    }

    public Online getHomeUrl1()
    {
        Iterator ite = getOnlines().iterator();
        while (ite.hasNext())
        {
            Online online = (Online) ite.next();
            if (online.getInfotype().equals(AddressListConstants.INFOTYPE_HOME))
            {
                if (online.getOnlinetype().equals(AddressListConstants.ONLINETYPE_URL))
                {
                    if (online.getNum().intValue() == 0)
                    {
                        return online;
                    }
                }
            }
        }
        return null;
    }

    public Online getHomeUrl2()
    {
        Iterator ite = getOnlines().iterator();
        while (ite.hasNext())
        {
            Online online = (Online) ite.next();
            if (online.getInfotype().equals(AddressListConstants.INFOTYPE_HOME))
            {
                if (online.getOnlinetype().equals(AddressListConstants.ONLINETYPE_URL))
                {
                    if (online.getNum().intValue() == 1)
                    {
                        return online;
                    }
                }
            }
        }
        return null;
    }

    public Online getHomeUrl3()
    {
        Iterator ite = getOnlines().iterator();
        while (ite.hasNext())
        {
            Online online = (Online) ite.next();
            if (online.getInfotype().equals(AddressListConstants.INFOTYPE_HOME))
            {
                if (online.getOnlinetype().equals(AddressListConstants.ONLINETYPE_URL))
                {
                    if (online.getNum().intValue() == 2)
                    {
                        return online;
                    }
                }
            }
        }
        return null;
    }

    public Online getBusinessEmail1()
    {
        Iterator ite = getOnlines().iterator();
        while (ite.hasNext())
        {
            Online online = (Online) ite.next();
            if (online.getInfotype().equals(AddressListConstants.INFOTYPE_BUSINESS))
            {
                if (online.getOnlinetype().equals(AddressListConstants.ONLINETYPE_EMAIL))
                {
                    if (online.getNum().intValue() == 0)
                    {
                        return online;
                    }
                }
            }
        }
        return null;
    }

    public Online getBusinessEmail2()
    {
        Iterator ite = getOnlines().iterator();
        while (ite.hasNext())
        {
            Online online = (Online) ite.next();
            if (online.getInfotype().equals(AddressListConstants.INFOTYPE_BUSINESS))
            {
                if (online.getOnlinetype().equals(AddressListConstants.ONLINETYPE_EMAIL))
                {
                    if (online.getNum().intValue() == 1)
                    {
                        return online;
                    }
                }
            }
        }
        return null;
    }

    public Online getBusinessEmail3()
    {
        Iterator ite = getOnlines().iterator();
        while (ite.hasNext())
        {
            Online online = (Online) ite.next();
            if (online.getInfotype().equals(AddressListConstants.INFOTYPE_BUSINESS))
            {
                if (online.getOnlinetype().equals(AddressListConstants.ONLINETYPE_EMAIL))
                {
                    if (online.getNum().intValue() == 2)
                    {
                        return online;
                    }
                }
            }
        }
        return null;
    }

    public Online getBusinessUrl1()
    {
        Iterator ite = getOnlines().iterator();
        while (ite.hasNext())
        {
            Online online = (Online) ite.next();
            if (online.getInfotype().equals(AddressListConstants.INFOTYPE_BUSINESS))
            {
                if (online.getOnlinetype().equals(AddressListConstants.ONLINETYPE_URL))
                {
                    if (online.getNum().intValue() == 0)
                    {
                        return online;
                    }
                }
            }
        }
        return null;
    }

    public Online getBusinessUrl2()
    {
        Iterator ite = getOnlines().iterator();
        while (ite.hasNext())
        {
            Online online = (Online) ite.next();
            if (online.getInfotype().equals(AddressListConstants.INFOTYPE_BUSINESS))
            {
                if (online.getOnlinetype().equals(AddressListConstants.ONLINETYPE_URL))
                {
                    if (online.getNum().intValue() == 1)
                    {
                        return online;
                    }
                }
            }
        }
        return null;
    }

    public Online getBusinessUrl3()
    {
        Iterator ite = getOnlines().iterator();
        while (ite.hasNext())
        {
            Online online = (Online) ite.next();
            if (online.getInfotype().equals(AddressListConstants.INFOTYPE_BUSINESS))
            {
                if (online.getOnlinetype().equals(AddressListConstants.ONLINETYPE_URL))
                {
                    if (online.getNum().intValue() == 2)
                    {
                        return online;
                    }
                }
            }
        }
        return null;
    }

    public Custom getCustom1()
    {
        Iterator ite = getCustoms().iterator();
        while (ite.hasNext())
        {
            Custom custom = (Custom) ite.next();
            if (custom.getInfotype().equals(AddressListConstants.INFOTYPE_CUSTOM))
            {
                if (custom.getNum().intValue() == 0)
                {
                    return custom;
                }
            }
        }
        return null;
    }

    public Custom getCustom2()
    {
        Iterator ite = getCustoms().iterator();
        while (ite.hasNext())
        {
            Custom custom = (Custom) ite.next();
            if (custom.getInfotype().equals(AddressListConstants.INFOTYPE_CUSTOM))
            {
                if (custom.getNum().intValue() == 1)
                {
                    return custom;
                }
            }
        }
        return null;
    }

    public Custom getCustom3()
    {
        Iterator ite = getCustoms().iterator();
        while (ite.hasNext())
        {
            Custom custom = (Custom) ite.next();
            if (custom.getInfotype().equals(AddressListConstants.INFOTYPE_CUSTOM))
            {
                if (custom.getNum().intValue() == 2)
                {
                    return custom;
                }
            }
        }
        return null;
    }

    public Custom getCustom4()
    {
        Iterator ite = getCustoms().iterator();
        while (ite.hasNext())
        {
            Custom custom = (Custom) ite.next();
            if (custom.getInfotype().equals(AddressListConstants.INFOTYPE_CUSTOM))
            {
                if (custom.getNum().intValue() == 3)
                {
                    return custom;
                }
            }
        }
        return null;
    }
}
