/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.addresslist.model;

import java.util.Calendar;
import java.util.Date;

import jp.sf.pal.addresslist.AbstractTestCase;
import jp.sf.pal.addresslist.dao.UserDao;
import junit.framework.Test;
import junit.framework.TestSuite;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.hibernate3.impl.S2SessionFactoryImpl;

public class AddressListTest extends AbstractTestCase
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(AddressListTest.class);

    public static long testId = -1;

    /* (non-Javadoc)
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception
    {
        if (log.isDebugEnabled())
        {
            log.debug("setUp() - start");
        }

        // TODO Auto-generated method stub
        super.setUp();

        if (log.isDebugEnabled())
        {
            log.debug("setUp() - end");
        }
    }

    /**
     * Create the test case
     *
     * @param testName name of the test case
     */
    public AddressListTest(String testName)
    {
        super(testName);
    }

    /**
     * @return the suite of tests being tested
     */
    public static Test suite()
    {
        if (log.isDebugEnabled())
        {
            log.debug("suite() - start");
        }

        TestSuite suite = new TestSuite();
        suite.addTest(new AddressListTest("addUser"));
        suite.addTest(new AddressListTest("deleteUser"));

        if (log.isDebugEnabled())
        {
            log.debug("suite() - end");
        }
        return suite;
    }

    public void addUser()
    {

        SingletonS2ContainerFactory.setConfigPath("jp/sf/pal/addresslist/AddressList.dicon");
        SingletonS2ContainerFactory.init();
        S2Container container = SingletonS2ContainerFactory.getContainer();

        UserDao userDao = (UserDao) container.getComponent(UserDao.class);

        User user = new User();
        Date now = Calendar.getInstance().getTime();
        user.setBdate(now);
        user.setDepartment("Department");
        user.setEmployer("Employer");
        user.setFamilyname("Familyname");
        user.setGender("Gender");
        user.setGivenname("Givenname");
        user.setJobtitle("Jobtitle");
        user.setMiddlename("Middlename");
        user.setNameprefix("prefix");
        user.setNamesuffix("suffix");
        user.setNickname("NickName");
        
        userDao.save(user);

        testId = user.getId();

        SingletonS2ContainerFactory.destroy();

        assertTrue(testId != -1);

    }

    public void deleteUser()
    {
        SingletonS2ContainerFactory.setConfigPath("jp/sf/pal/addresslist/AddressList.dicon");
        SingletonS2ContainerFactory.init();
        S2Container container = SingletonS2ContainerFactory.getContainer();

        UserDao userDao = (UserDao) container.getComponent(UserDao.class);
        S2SessionFactoryImpl s2SessionFactory = (S2SessionFactoryImpl) SingletonS2ContainerFactory.getContainer()
                .getComponent(S2SessionFactoryImpl.class);

        User user = userDao.getUserById(testId);

        userDao.delete(user);

        s2SessionFactory.getSession().flush();

        assertNull(userDao.getUserById(testId));

        SingletonS2ContainerFactory.destroy();

    }
}
