/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.notepad.bean;

import java.util.Calendar;
import java.util.Date;

import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;

import jp.sf.pal.notepad.NotepadConstants;
import jp.sf.pal.notepad.NotepadRuntimeException;
import jp.sf.pal.notepad.model.Note;
import jp.sf.pal.notepad.util.NotepadDaoUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.portlet.util.PortletResourceBundleUtil;

import com.marevol.utils.faces.application.FacesMessageUtil;
import com.marevol.utils.faces.util.LocaleUtil;

public class NotepadAddPageBean
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(NotepadAddPageBean.class);

    private String name;

    private String content;

    private String permission;

    private NotepadSessionBean notepadSession;

    public NotepadAddPageBean()
    {
        permission = NotepadConstants.PUBLIC_PERMISSION;
    }

    public String save()
    {
        try
        {
            Note note = new Note();
            if (notepadSession != null && notepadSession.getCategoryId().longValue() != -1)
            {
                note.setCategory(notepadSession.getCategory());
            }
            Date now = Calendar.getInstance().getTime();
            note.setContent(getContent());
            note.setCreatedtime(now);
            note.setName(getName());
            String username = FacesContext.getCurrentInstance().getExternalContext().getRemoteUser();
            if (username == null)
            {
                username = NotepadConstants.GUEST_USER;
            }
            note.setOwner(username);
            note.setPermission(permission);
            note.setScope(notepadSession.getScope());
            note.setUpdatedtime(now);

            NotepadDaoUtil.getNoteDao().save(note);

            // i18n
            FacesMessageUtil.addInfoMessage(PortletResourceBundleUtil.getString(LocaleUtil.getLocale(),
                    "notepadadd.AddedTheNote"));

            return NotepadConstants.NOTEPAD_VIEW_VIEW_ID;
        }
        catch (NotepadRuntimeException e)
        {
            // i18n
            FacesMessageUtil.addErrorMessage(PortletResourceBundleUtil.getString(LocaleUtil.getLocale(),
                    "notepadadd.FailedToAddTheNote"), e.toString());
            log.error("Failed to add notepad. ", e);
        }
        catch (RuntimeException e)
        {
            // i18n
            FacesMessageUtil.addErrorMessage(PortletResourceBundleUtil.getString(LocaleUtil.getLocale(),
                    "notepadadd.FailedToAddTheNote"), e.toString());
            log.error("Failed to add notepad. ", e);
        }

        return null;
    }

    public String back()
    {
        return NotepadConstants.NOTEPAD_VIEW_VIEW_ID;
    }

    public SelectItem[] getPermissionItems()
    {
        // i18n
        return new SelectItem[] {
                new SelectItem(NotepadConstants.PUBLIC_PERMISSION, PortletResourceBundleUtil.getString(LocaleUtil
                        .getLocale(), "notepadadd.Public")),
                new SelectItem(NotepadConstants.PRIVATE_PERMISSION, PortletResourceBundleUtil.getString(LocaleUtil
                        .getLocale(), "notepadadd.Private")) };
    }

    /**
     * @return Returns the content.
     */
    public String getContent()
    {
        return content;
    }

    /**
     * @param content The content to set.
     */
    public void setContent(String content)
    {
        this.content = content;
    }

    /**
     * @return Returns the name.
     */
    public String getName()
    {
        return name;
    }

    /**
     * @param name The name to set.
     */
    public void setName(String name)
    {
        this.name = name;
    }

    /**
     * @return Returns the notepadSession.
     */
    public NotepadSessionBean getNotepadSession()
    {
        return notepadSession;
    }

    /**
     * @param notepadSession The notepadSession to set.
     */
    public void setNotepadSession(NotepadSessionBean notepadSession)
    {
        this.notepadSession = notepadSession;
    }

    /**
     * @return Returns the permission.
     */
    public String getPermission()
    {
        return permission;
    }

    /**
     * @param permission The permission to set.
     */
    public void setPermission(String permission)
    {
        this.permission = permission;
    }
}
