<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h"%>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f"%>
<%@ taglib uri="http://myfaces.apache.org/tomahawk" prefix="t"%>

<f:view>
	<f:loadBundle basename="jp.sf.pal.notepad.resources.NotepadResources"
		var="msgs" />

	<!-- Menu -->
	<f:subview id="menu">
		<jsp:include page="Menubar.jsp" />
	</f:subview>

	<!-- Edit mode -->
	<h:form rendered="#{notepadMenuPage.validUser}">
		<h:messages styleClass="portlet-msg-success"
			errorClass="portlet-msg-error" fatalClass="portlet-msg-error"
			warnClass="portlet-msg-alert" infoClass="portlet-msg-info" />

		<h:panelGrid columns="3">
			<h:outputLabel for="name">
				<h:outputText value="#{msgs['notepadeditpage.Name']}" />
			</h:outputLabel>
			<h:inputText id="name" value="#{notepadEditPage.name}"
				maxlength="255" />
			<h:message for="name"></h:message>

			<h:outputLabel for="permission">
				<h:outputText value="#{msgs['notepadeditpage.Permission']}" />
			</h:outputLabel>
			<h:selectOneMenu id="permission"
				value="#{notepadEditPage.permission}">
				<f:selectItems value="#{notepadEditPage.permissionItems}" />
			</h:selectOneMenu>
			<h:message for="permission"></h:message>

			<h:outputLabel for="category">
				<h:outputText value="#{msgs['notepadeditpage.Category']}" />
			</h:outputLabel>
			<h:selectOneMenu id="category" value="#{notepadEditPage.categoryId}">
				<f:selectItems value="#{notepadEditPage.categoryItems}" />
			</h:selectOneMenu>
			<h:message for="category"></h:message>

		</h:panelGrid>
		<h:panelGrid columns="1">

			<h:panelGroup>
				<h:outputLabel for="content">
					<h:outputText value="#{msgs['notepadeditpage.Content']}" />
				</h:outputLabel>
				<h:message for="content"></h:message>
			</h:panelGroup>

			<!-- Contents -->
			<h:inputTextarea id="content" value="#{notepadEditPage.content}"
				cols="80" rows="30" />

		</h:panelGrid>

		<h:inputHidden value="#{notepadEditPage.id}" />

		<h:panelGrid columns="3">
			<h:commandButton action="#{notepadEditPage.update}" value="#{msgs['notepadeditpage.Update']}"
				rendered="#{notepadMenuPage.validUser}" />
			<h:commandButton action="#{notepadEditPage.delete}" value="#{msgs['notepadeditpage.Delete']}"
				rendered="#{notepadMenuPage.validUser}" />
			<h:commandButton action="#{notepadEditPage.back}" value="#{msgs['notepadeditpage.Back']}"
				immediate="true" />
		</h:panelGrid>
	</h:form>

	<!-- View mode -->
	<h:form rendered="#{!notepadMenuPage.validUser}">
		<h:messages styleClass="portlet-msg-success"
			errorClass="portlet-msg-error" fatalClass="portlet-msg-error"
			warnClass="portlet-msg-alert" infoClass="portlet-msg-info" />

		<h:panelGrid columns="2">
			<h:outputLabel for="name">
				<h:outputText value="#{msgs['notepadeditpage.Name']}" />
			</h:outputLabel>
			<h:outputText id="name" value="#{notepadEditPage.name}" />

			<h:outputLabel for="owner">
				<h:outputText value="#{msgs['notepadeditpage.Owner']}" />
			</h:outputLabel>
			<h:outputText id="owner" value="#{notepadEditPage.owner}" />

			<h:outputLabel for="permission">
				<h:outputText value="#{msgs['notepadeditpage.Permission']}" />
			</h:outputLabel>
			<h:outputText id="permission"
				value="#{notepadEditPage.permissionLabel}" />

			<h:outputLabel for="category">
				<h:outputText value="#{msgs['notepadeditpage.Category']}" />
			</h:outputLabel>
			<h:outputText id="category" value="#{notepadEditPage.categoryName}" />

		</h:panelGrid>
		<h:panelGrid columns="1">

			<h:panelGroup>
				<h:outputLabel for="content">
					<h:outputText value="#{msgs['notepadeditpage.Content']}" />
				</h:outputLabel>
				<h:message for="content"></h:message>
			</h:panelGroup>

			<!-- Contents -->
			<h:outputText id="content"
				value="#{notepadEditPage.formattedContent}" escape="false" />

		</h:panelGrid>

		<h:panelGrid columns="1">
			<h:commandButton action="#{notepadEditPage.back}" value="#{msgs['notepadeditpage.Back']}"
				immediate="true" />
		</h:panelGrid>
	</h:form>

</f:view>
