/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.charttest.bean;

import java.awt.Color;
import java.awt.Paint;
import java.text.DecimalFormat;
import java.text.NumberFormat;

import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class ChartTestSessionBean
{
    public static String PIE_CHART_3D = "PIE_CHART_3D";

    public static String PIE_CHART_2D = "PIE_CHART_2D";

    public static String LINE_CHART = "LINE_CHART";

    public static String STACK_BAR_CHART = "STACK_BAR_CHART";

    public static String BAR_CHART = "BAR_CHART";

    public static String BAR_CHART_2D = "BAR_CHART_2D";

    public static String AREA_CHART = "AREA_CHART";

    private NumberFormat formatter = new DecimalFormat("#,##0.00");

    private Paint[] paint = new Paint[] { Color.GREEN, Color.ORANGE, Color.PINK };

    private String chartType;

    private String chartTitle;

    private String title;

    private String name1;

    private String name2;

    private String name3;

    private String name4;

    private String name5;

    private Integer value1;

    private Integer value2;

    private Integer value3;

    private Integer value4;

    private Integer value5;

    private String fileType;

    private String color;

    private String width;

    private String height;

    private String transparency;

    private String axisXLabel;

    private String axisYLabel;

    public ChartTestSessionBean()
    {
        setColor("#FFFFFF");
        setChartTitle("Chart Title");
        setWidth("450");
        setHeight("300");
        setTitle("Title");
        setFileType("jpg");
        setTransparency("0.6");

        setName1("A");
        setValue1(new Integer(5));
        setName2("B");
        setValue2(new Integer(10));
        setName3("C");
        setValue3(new Integer(15));
        setName4("D");
        setValue4(new Integer(20));
        setName5("E");
        setValue5(new Integer(25));

        setAxisXLabel("x axis desc");
        setAxisYLabel("y axis desc");
    }

    public PieDataset getDataset()
    {
        DefaultPieDataset dataset = new DefaultPieDataset();
        dataset.setValue(getName1(), getValue1().doubleValue());
        dataset.setValue(getName2(), getValue2().doubleValue());
        dataset.setValue(getName3(), getValue3().doubleValue());
        dataset.setValue(getName4(), getValue4().doubleValue());
        dataset.setValue(getName5(), getValue5().doubleValue());

        return dataset;
    }

    public CategoryDataset getBarDataset()
    {
        DefaultCategoryDataset barDataset = new DefaultCategoryDataset();
        barDataset.addValue(getValue1().doubleValue() + (Math.random() * 100)
                - 50.0, getName1(), "10");
        barDataset.addValue(getValue1().doubleValue() + (Math.random() * 100)
                - 50.0, getName1(), "20");
        barDataset.addValue(getValue1().doubleValue() + (Math.random() * 100)
                - 50.0, getName1(), "30");
        barDataset.addValue(getValue1().doubleValue() + (Math.random() * 100)
                - 50.0, getName1(), "40");
        barDataset.addValue(getValue1().doubleValue() + (Math.random() * 100)
                - 50.0, getName1(), "50");

        barDataset.addValue(getValue2().doubleValue() + (Math.random() * 100)
                - 50.0, getName2(), "10");
        barDataset.addValue(getValue2().doubleValue() + (Math.random() * 100)
                - 50.0, getName2(), "20");
        barDataset.addValue(getValue2().doubleValue() + (Math.random() * 100)
                - 50.0, getName2(), "30");
        barDataset.addValue(getValue2().doubleValue() + (Math.random() * 100)
                - 50.0, getName2(), "40");
        barDataset.addValue(getValue2().doubleValue() + (Math.random() * 100)
                - 50.0, getName2(), "50");

        barDataset.addValue(getValue3().doubleValue() + (Math.random() * 100)
                - 50.0, getName3(), "10");
        barDataset.addValue(getValue3().doubleValue() + (Math.random() * 100)
                - 50.0, getName3(), "20");
        barDataset.addValue(getValue3().doubleValue() + (Math.random() * 100)
                - 50.0, getName3(), "30");
        barDataset.addValue(getValue3().doubleValue() + (Math.random() * 100)
                - 50.0, getName3(), "40");
        barDataset.addValue(getValue3().doubleValue() + (Math.random() * 100)
                - 50.0, getName3(), "50");

        return barDataset;
    }

    public boolean isPieChart()
    {
        if (PIE_CHART_3D.equals(chartType))
        {
            return true;
        }
        return false;
    }

    public boolean isPieChart2D()
    {
        if (PIE_CHART_2D.equals(chartType))
        {
            return true;
        }
        return false;
    }

    public boolean isLineChart()
    {
        if (LINE_CHART.equals(chartType))
        {
            return true;
        }
        return false;
    }

    public boolean isStackBarChart()
    {
        if (STACK_BAR_CHART.equals(chartType))
        {
            return true;
        }
        return false;
    }

    public boolean isBarChart()
    {
        if (BAR_CHART.equals(chartType))
        {
            return true;
        }
        return false;
    }

    public boolean isBarChart2D()
    {
        if (BAR_CHART_2D.equals(chartType))
        {
            return true;
        }
        return false;
    }

    public boolean isAreaChart()
    {
        if (AREA_CHART.equals(chartType))
        {
            return true;
        }
        return false;
    }

    /**
     * @return Returns the chartTitle.
     */
    public String getChartTitle()
    {
        return chartTitle;
    }

    /**
     * @param chartTitle The chartTitle to set.
     */
    public void setChartTitle(String name)
    {
        this.chartTitle = name;
    }

    /**
     * @return Returns the color.
     */
    public String getColor()
    {
        return color;
    }

    /**
     * @param color The color to set.
     */
    public void setColor(String color)
    {
        this.color = color;
    }

    /**
     * @return Returns the fileType.
     */
    public String getFileType()
    {
        return fileType;
    }

    /**
     * @param fileType The fileType to set.
     */
    public void setFileType(String fileType)
    {
        this.fileType = fileType;
    }

    /**
     * @return Returns the height.
     */
    public String getHeight()
    {
        return height;
    }

    /**
     * @param height The height to set.
     */
    public void setHeight(String height)
    {
        this.height = height;
    }

    /**
     * @return Returns the name1.
     */
    public String getName1()
    {
        return name1;
    }

    /**
     * @param name1 The name1 to set.
     */
    public void setName1(String name1)
    {
        this.name1 = name1;
    }

    /**
     * @return Returns the name2.
     */
    public String getName2()
    {
        return name2;
    }

    /**
     * @param name2 The name2 to set.
     */
    public void setName2(String name2)
    {
        this.name2 = name2;
    }

    /**
     * @return Returns the name3.
     */
    public String getName3()
    {
        return name3;
    }

    /**
     * @param name3 The name3 to set.
     */
    public void setName3(String name3)
    {
        this.name3 = name3;
    }

    /**
     * @return Returns the name4.
     */
    public String getName4()
    {
        return name4;
    }

    /**
     * @param name4 The name4 to set.
     */
    public void setName4(String name4)
    {
        this.name4 = name4;
    }

    /**
     * @return Returns the name5.
     */
    public String getName5()
    {
        return name5;
    }

    /**
     * @param name5 The name5 to set.
     */
    public void setName5(String name5)
    {
        this.name5 = name5;
    }

    /**
     * @return Returns the title.
     */
    public String getTitle()
    {
        return title;
    }

    /**
     * @param title The title to set.
     */
    public void setTitle(String title)
    {
        this.title = title;
    }

    /**
     * @return Returns the width.
     */
    public String getWidth()
    {
        return width;
    }

    /**
     * @param width The width to set.
     */
    public void setWidth(String width)
    {
        this.width = width;
    }

    /**
     * @return Returns the transparency.
     */
    public String getTransparency()
    {
        return transparency;
    }

    /**
     * @param transparency The transparency to set.
     */
    public void setTransparency(String transparency)
    {
        this.transparency = transparency;
    }

    /**
     * @return Returns the value1.
     */
    public Integer getValue1()
    {
        return value1;
    }

    /**
     * @param value1 The value1 to set.
     */
    public void setValue1(Integer value1)
    {
        this.value1 = value1;
    }

    /**
     * @return Returns the value2.
     */
    public Integer getValue2()
    {
        return value2;
    }

    /**
     * @param value2 The value2 to set.
     */
    public void setValue2(Integer value2)
    {
        this.value2 = value2;
    }

    /**
     * @return Returns the value3.
     */
    public Integer getValue3()
    {
        return value3;
    }

    /**
     * @param value3 The value3 to set.
     */
    public void setValue3(Integer value3)
    {
        this.value3 = value3;
    }

    /**
     * @return Returns the value4.
     */
    public Integer getValue4()
    {
        return value4;
    }

    /**
     * @param value4 The value4 to set.
     */
    public void setValue4(Integer value4)
    {
        this.value4 = value4;
    }

    /**
     * @return Returns the value5.
     */
    public Integer getValue5()
    {
        return value5;
    }

    /**
     * @param value5 The value5 to set.
     */
    public void setValue5(Integer value5)
    {
        this.value5 = value5;
    }

    /**
     * @return Returns the chartType.
     */
    public String getChartType()
    {
        return chartType;
    }

    /**
     * @param chartType The chartType to set.
     */
    public void setChartType(String chartType)
    {
        this.chartType = chartType;
    }

    /**
     * @return Returns the axisXLabel.
     */
    public String getAxisXLabel()
    {
        return axisXLabel;
    }

    /**
     * @param axisXLabel The axisXLabel to set.
     */
    public void setAxisXLabel(String axisXLabel)
    {
        this.axisXLabel = axisXLabel;
    }

    /**
     * @return Returns the axisYLabel.
     */
    public String getAxisYLabel()
    {
        return axisYLabel;
    }

    /**
     * @param axisYLabel The axisYLabel to set.
     */
    public void setAxisYLabel(String axisYLabel)
    {
        this.axisYLabel = axisYLabel;
    }

    /**
     * @return Returns the formatter.
     */
    public NumberFormat getFormatter()
    {
        return formatter;
    }

    /**
     * @param formatter The formatter to set.
     */
    public void setFormatter(NumberFormat formatter)
    {
        this.formatter = formatter;
    }

    /**
     * @return Returns the paint.
     */
    public Paint[] getPaint()
    {
        return paint;
    }

    /**
     * @param paint The paint to set.
     */
    public void setPaint(Paint[] paint)
    {
        this.paint = paint;
    }
}
