/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.jstock.reader;

import java.io.IOException;
import java.text.ParseException;
import java.util.List;

import jp.sf.pal.jstock.dto.StockDataDto;

import org.xml.sax.SAXException;

/**
 * Get the Information of Stock Prices.<br>
 * 
 * 株価情報を取得する．
 * 
 * @author karma
 * @version $Id$
 */
public interface StockDataReader {
    
    /**
     * 取得したい株の証券コード (String) のリスト．
     * @param codes 株式コードのリスト
     */
    public void setCodes(List codes);

    /**
     * 与えられた証券コードの株式の情報を取得する．
     * @param code 証券コード
     * @return 与えられた証券コードの株の情報．
     * 
     * @throws SAXException
     * @throws IOException
     * @throws ParseException
     */
    public StockDataDto getStockData(String code) throws SAXException, IOException, ParseException ;
    
    /**
     * 与えられた証券コードのリストの株式の情報を取得する．
     * @return 株式の情報 (StockDataDto) のリスト
     * 
     * @throws SAXException
     * @throws IOException
     * @throws ParseException
     */
    public List getStockDataList() throws SAXException, IOException, ParseException ;
    
}
