/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.blog.importer.hatena;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;

import jp.sf.pal.blog.dao.BlogCommentDao;
import jp.sf.pal.blog.dao.BlogMessageDao;
import jp.sf.pal.blog.importer.Importer;
import jp.sf.pal.blog.model.BlogComment;
import jp.sf.pal.blog.model.BlogMessage;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

public class HatenaImporter extends Thread implements Importer
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(HatenaImporter.class);

    private File importFile;

    private String owner;

    private String formatType;

    private Map localizedName;

    public HatenaImporter(String formatType, Map localizedName)
    {
        super();

        setFormatType(formatType);
        setLocalizedName(localizedName);

    }

    /* (non-Javadoc)
     * @see java.lang.Thread#run()
     */
    /* (non-Javadoc)
     * @see jp.sf.pal.blog.importer.hatena.Importer#run()
     */
    /* (non-Javadoc)
     * @see jp.sf.pal.blog.importer.hatena.Importer#run()
     */
    public void run()
    {
        if (log.isDebugEnabled())
        {
            log.debug("run()");
        }

        //        S2Container container = S2ContainerFactory
        //                .create(SingletonS2ContainerFactory.getConfigPath());
        //        container.init();
        S2Container container = SingletonS2ContainerFactory.getContainer();

        BlogMessageDao bmDao = (BlogMessageDao) container
                .getComponent(BlogMessageDao.class);
        BlogCommentDao bcDao = (BlogCommentDao) container
                .getComponent(BlogCommentDao.class);

        try
        {
            Diary diary = HatenaUtil.parse(importFile);

            Iterator i1 = diary.getDays().iterator();
            while (i1.hasNext())
            {
                Day day = (Day) i1.next();
                BlogMessage bm = new BlogMessage();
                if (log.isDebugEnabled())
                {
                    log.debug("Adding message.. " + day.getTitle());
                }
                bm.setCreatedtime(day.getTime());
                bm.setFormattype(getFormatType());
                bm.setMessage(day.getBody());
                bm.setOwner(owner);
                if (day.getTitle() != null && !day.getTime().equals(""))
                {
                    bm.setTitle(day.getTitle());
                }
                else
                {
                    bm.setTitle(day.getDate());
                }
                bm.setUpdatedtime(Calendar.getInstance().getTime());

                bmDao.save(bm);

                Iterator i2 = day.getComments().iterator();
                while (i2.hasNext())
                {
                    Comment comment = (Comment) i2.next();
                    if (log.isDebugEnabled())
                    {
                        log.debug("Adding comment.. " + comment.getUsername());
                    }
                    BlogComment bc = new BlogComment();
                    bc.setBlogMessage(bm);
                    bc.setCreatedtime(comment.getTime());
                    bc.setMessage(comment.getBody());
                    bc.setName(comment.getUsername());
                    bc.setEmail("");
                    bc.setUrl("");

                    bcDao.save(bc);
                }
            }
        }
        catch (FileNotFoundException e)
        {
            log.error(e);
        }
        finally
        {
            //            container.destroy();
        }
    }

    /* (non-Javadoc)
     * @see jp.sf.pal.blog.importer.hatena.Importer#getImportFile()
     */
    /* (non-Javadoc)
     * @see jp.sf.pal.blog.importer.hatena.Importer#getImportFile()
     */
    public File getImportFile()
    {
        return importFile;
    }

    /* (non-Javadoc)
     * @see jp.sf.pal.blog.importer.hatena.Importer#setImportFile(java.io.File)
     */
    /* (non-Javadoc)
     * @see jp.sf.pal.blog.importer.hatena.Importer#setImportFile(java.io.File)
     */
    public void setImportFile(File importFile)
    {
        this.importFile = importFile;
    }

    /* (non-Javadoc)
     * @see jp.sf.pal.blog.importer.hatena.Importer#getOwner()
     */
    /* (non-Javadoc)
     * @see jp.sf.pal.blog.importer.hatena.Importer#getOwner()
     */
    public String getOwner()
    {
        return owner;
    }

    /* (non-Javadoc)
     * @see jp.sf.pal.blog.importer.hatena.Importer#setOwner(java.lang.String)
     */
    /* (non-Javadoc)
     * @see jp.sf.pal.blog.importer.hatena.Importer#setOwner(java.lang.String)
     */
    public void setOwner(String owner)
    {
        this.owner = owner;
    }

    /* (non-Javadoc)
     * @see jp.sf.pal.blog.importer.hatena.Importer#getLocalizedName()
     */
    public Map getLocalizedNames()
    {
        return localizedName;
    }

    /* (non-Javadoc)
     * @see jp.sf.pal.blog.importer.hatena.Importer#setLocalizedName(java.util.Map)
     */
    public void setLocalizedName(Map localizedName)
    {
        this.localizedName = localizedName;
    }

    /* (non-Javadoc)
     * @see jp.sf.pal.blog.importer.hatena.Importer#getFormatType()
     */
    public String getFormatType()
    {
        return formatType;
    }

    /* (non-Javadoc)
     * @see jp.sf.pal.blog.importer.hatena.Importer#setFormatType(java.lang.String)
     */
    public void setFormatType(String formatType)
    {
        this.formatType = formatType;
    }

    /* (non-Javadoc)
     * @see java.lang.Thread#start()
     */
    public synchronized void start()
    {
        super.start();
    }

}
