/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.cms;

public class CMSConstants {
    public static final String CONSTANT_PREFIX = "jp.sf.pal.cms.";

    public static final String PATH_SEPARATOR = "/";

    public static final String KEY_SEPARATOR = ":";

    public static final String ROOT_FOLDER = PATH_SEPARATOR;

    public static final String DEFAULT_ENCODING = "UTF-8";

    public static final String DEFAULT_LANG = CONSTANT_PREFIX + "DEFAULT";

    public static final String DEFAULT_TEXT_MIMETYPE = "text/plain";

    public static final String DEFAULT_HTML_MIMETYPE = "text/html";

    public static final String DEFAULT_CONTENT_PATH = PATH_SEPARATOR
            + "index.html";

    public static final String PAGE_NAME = "page";

    public static final String CONTENT_MANAGEMENT_PROTOCOL = "cmp://";

    public static final String DISPLAY_FOLDER_LIST_PAGE = "DISPLAY_FOLDER_LIST_PAGE";

    public static final String DISPLAY_FILE_DETAIL_PAGE = "DISPLAY_FILE_DETAIL_PAGE";

    public static final String DISPLAY_FOLDER_DETAIL_PAGE = "DISPLAY_FOLDER_DETAIL_PAGE";

    public static final String CREATE_NEW_FILE_PAGE = "CREATE_NEW_FILE_PAGE";

    public static final String CREATE_NEW_FOLDER_PAGE = "CREATE_NEW_FOLDER_PAGE";

    public static final String WRITE_TEXT_CONTENT_PAGE = "WRITE_TEXT_CONTENT_PAGE";

    public static final String WRITE_HTML_CONTENT_PAGE = "WRITE_HTML_CONTENT_PAGE";

    public static final String UPLOAD_FILE_PAGE = "UPLOAD_FILE_PAGE";

    public static final String PATH = CONSTANT_PREFIX + "Path";

    public static final String CONTENT_PATH = CONSTANT_PREFIX + "ContentPath";

    public static final String CONTENT_TARGET = CONSTANT_PREFIX
            + "ContentTarget";

    public static final String CONTENT_TARGET_PREFIX = "cms" + KEY_SEPARATOR;

    public static final String SCOPE = CONSTANT_PREFIX + "Scope";

    public static final String IMPORT_FILE = CONSTANT_PREFIX + "ImportFile";

    public static final String DEFAULT_SCOPE_VALUE = "default";

    public static final String NEW_OBJECT_NAME = CONSTANT_PREFIX
            + "NewObjectName";

    public static final String SELECTED_OBJECT_NAME = CONSTANT_PREFIX
            + "SelectedObjectName";

    public static final String FILE_ID = CONSTANT_PREFIX + "FileId";

    public static final String FILE_SERVLET = "/file";

    public static final String NT_FILE = "nt:file";

    public static final String NT_FOLDER = "nt:folder";

    public static final String NT_RESOURCE = "nt:resource";

    public static final String CMS_NAMESPACE = "cms:";

    // public static final String JCR_NAMESPACE = "jcr:";

    public static final String SCOPE_NODE = CMS_NAMESPACE + "scope";

    public static final String SCOPE_NODE_NAME_ATTR = CMS_NAMESPACE + "name";

    public static final String FOLDER_NODE = CMS_NAMESPACE + "folder";

    public static final String FOLDER_NODE_NAME_ATTR = CMS_NAMESPACE + "name";

    public static final String FOLDER_NODE_CREATED_ATTR = CMS_NAMESPACE
            + "created";

    public static final String FOLDER_NODE_LASTMODIFIED_ATTR = CMS_NAMESPACE
            + "lastModified";

    public static final String FILE_NODE = CMS_NAMESPACE + "file";

    public static final String FILE_NODE_NAME_ATTR = CMS_NAMESPACE + "name";

    public static final String FILE_NODE_CREATED_ATTR = CMS_NAMESPACE
            + "created";

    public static final String FILE_NODE_LASTMODIFIED_ATTR = CMS_NAMESPACE
            + "lastModified";

    public static final String CONTENT_NODE = CMS_NAMESPACE + "content";

    public static final String CONTENT_NODE_TITLE_ATTR = CMS_NAMESPACE
            + "title";

    public static final String CONTENT_NODE_DESCRIPTION_ATTR = CMS_NAMESPACE
            + "description";

    public static final String CONTENT_NODE_MIMETYPE_ATTR = CMS_NAMESPACE
            + "mimeType";

    public static final String CONTENT_NODE_LANG_ATTR = CMS_NAMESPACE + "lang";

    public static final String CONTENT_NODE_ENCODING_ATTR = CMS_NAMESPACE
            + "encoding";

    public static final String CONTENT_NODE_DATA_ATTR = CMS_NAMESPACE + "data";

    public static final String CONTENT_NODE_LASTMODIFIED_ATTR = CMS_NAMESPACE
            + "lastModified";

    public static final String AUTHORING_CONTENT_NODE = CMS_NAMESPACE
            + "authoring-content";

    public static final String PAGE_NODE = CMS_NAMESPACE + "page";

    public static final String PAGE_NODE_PATH_ATTR = CMS_NAMESPACE + "path";

}
