/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sf.pal.cms.dao;

import jp.sf.pal.cms.CMSException;
import jp.sf.pal.cms.dto.FolderNodeDto;

/**
 * @author shinsuke
 * 
 */
public interface FolderNodeDao {
    public FolderNodeDto getFolderNode(String scopeName, String path)
            throws CMSException;

    public void insert(FolderNodeDto folderNode) throws CMSException;

    public void update(FolderNodeDto folderNode) throws CMSException;

    public void delete(FolderNodeDto folderNode) throws CMSException;
}
